﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Enum.User;
using VT.FW.DB;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 储值卡合并/赠送
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_DepositBalance
    {
        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 原购买id(主要针对合并的记录与合并的id值)
        /// </summary>
        public int OldDepositBuyId { get; set; }


        /// <summary>
        /// 新购买id(主要针对合并的记录与合并的id值)
        /// </summary>
        public int NewDepositBuyId { get; set; }
        /// <summary>
        /// 用户id
        /// </summary>
        public int? UserId { get; set; }
        

        /// <summary>
        /// 储值卡名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 储值卡封面
        /// </summary>
        public string CouponIco { get; set; }
        /// <summary>
        /// 储值卡售价
        /// </summary>
        public decimal SalePrice { get; set; }

        /// <summary>
        /// 储值卡面值
        /// </summary>
        public decimal DepositPrice { get; set; }

        /// <summary>
        /// 类型  1增加  2减少
        /// </summary>        
        public RecordTypeEnum? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 使用之前金额
        /// </summary>        
        public decimal? Balance
        {
            get;
            set;
        }

        /// <summary>
        /// 使用之后金额
        /// </summary>        
        public decimal? Surplus
        {
            get;
            set;
        }


        /// <summary>
        /// 1-合并记录，2-赠送记录，3-消费
        /// </summary>
        public int MergeType { get; set; }


        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }


        /// <summary>
        /// 状态
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }

    }
}
