﻿using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 小程序管理员实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miniprogram_Admin
    {
		/// <summary>
		/// 管理员编号
		/// </summary>
		public int AdminId { get; set; }

		/// <summary>
		/// 用户编号(rb_member_user表中的Id)
		/// </summary>
		public int UserId { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public DateStateEnum Status { get; set; }

		/// <summary>
		/// 商户号
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 修改时间
		/// </summary>
		public DateTime UpdateDate { get; set; }
	}
}
