﻿using Mall.Common.Plugin;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.User;
using Mall.Model.Query;
using Mall.Repository.Product;
using Mall.Repository.User;
using Newtonsoft.Json.Linq;
using NPOI.SS.Formula.Functions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.MarketingCenter
{
    public class StatisticsModule
    {
        private readonly RB_Goods_OrderRepository orderRepository = new RB_Goods_OrderRepository();
        /// <summary>
        /// 返佣
        /// </summary>
        private readonly RB_Goods_OrderCommissionRepository goods_OrderCommissionRepository = new RB_Goods_OrderCommissionRepository();

        /// <summary>
        /// 会员
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();

        /// <summary>
        /// 会员仓储层对象
        /// </summary>
        private readonly RB_Member_UserRepository2 member_UserRepository2 = new RB_Member_UserRepository2();

        /// <summary>
        /// 分销商
        /// </summary>
        private readonly RB_Distributor_InfoRepository distributor_InfoRepository = new RB_Distributor_InfoRepository();

        /// <summary>
        /// 和平等级
        /// </summary>
        private readonly RB_Distributor_HPGradeInfoRepository distributor_HPGradeInfoRepository = new RB_Distributor_HPGradeInfoRepository();

        /// <summary>
        /// 用户统计
        /// </summary>
        private readonly RB_User_StatisticsRepository user_StatisticsRepository = new RB_User_StatisticsRepository();

        /// <summary>
        /// 粉象返佣
        /// </summary>
        private readonly RB_Distributor_FXGradeRepository distributor_FXGradeRepository = new RB_Distributor_FXGradeRepository();

        #region 数据统计-数据概况

        /// <summary>
        /// 损益核算表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<OrderStatistics_Query> GetOrderProfitLossList(int pageIndex, int pageSize, out long count, OrderStatistics_Query dmodel)
        {
            return orderRepository.GetOrderProfitLossList(pageIndex, pageSize, out count, dmodel);
        }



        public List<OrderStatistics_Query> GetAllOrderProfitLossList(OrderStatistics_Query dmodel)
        {
            return orderRepository.GetAllOrderProfitLossList(dmodel);
        }



        /// <summary>
        /// 数据概况
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetOrdertSatistics(DataStatistics_Query dmodel)
        {
            return orderRepository.GetOrdertSatistics(dmodel);
        }


        #region 粉象收益核算
        public List<OrderStatistics_Query> GetFXOrderProfitLossList(int pageIndex, int pageSize, out long count, OrderStatistics_Query dmodel)
        {
            var list = orderRepository.GetFXOrderProfitLossList(pageIndex, pageSize, out count, dmodel);

            if (list != null && list.Any())
            {
                //查询订单的返佣信息
                string orderDetailIds = string.Join(",", list.Select(x => x.Id));
                //分销情况
                var oclist = goods_OrderCommissionRepository.GetListGroupByUser_V2(new RB_Goods_OrderCommission_Extend { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, OrderDetailIds = orderDetailIds });

                foreach (var item in list)
                {
                    item.FXCommission = (oclist != null && oclist.Any()) ? oclist.Where(x => x.OrderDetailId == item.Id).Sum(x => (x.Commission ?? 0)) : 0;
                    item.RemitFXCommission = (oclist != null && oclist.Any()) ? oclist.Where(x => x.OrderDetailId == item.Id && x.IsRemit == 1).Sum(x => (x.Commission ?? 0)) : 0;
                }
            }

            return list;
        }

        /// <summary>
        /// 徐总报表使用
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<OrderStatistics_Query> GetFXOrderProfitLossList_V2(OrderStatistics_Query dmodel)
        {
            var list = orderRepository.GetFXOrderProfitLossList_V2(dmodel);

            if (list != null && list.Any())
            {
                //查询订单的返佣信息
                string orderDetailIds = string.Join(",", list.Select(x => x.Id));
                //分销情况
                var oclist = goods_OrderCommissionRepository.GetListGroupByUser_V2(new RB_Goods_OrderCommission_Extend { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, OrderDetailIds = orderDetailIds });

                foreach (var item in list)
                {
                    item.FXCommission = (oclist != null && oclist.Any()) ? oclist.Where(x => x.OrderDetailId == item.Id).Sum(x => (x.Commission ?? 0)) : 0;
                    item.RemitFXCommission = (oclist != null && oclist.Any()) ? oclist.Where(x => x.OrderDetailId == item.Id && x.IsRemit == 1).Sum(x => (x.Commission ?? 0)) : 0;
                }
            }

            return list;
        }

        public List<OrderStatistics_Query> GetFXAllOrderProfitLossList(OrderStatistics_Query dmodel)
        {
            var list = orderRepository.GetFXAllOrderProfitLossList(dmodel);

            if (list != null && list.Any())
            {
                //分销情况
                //分销情况
                var oclist = goods_OrderCommissionRepository.GetListGroupByUser_V2(new RB_Goods_OrderCommission_Extend { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, OrderIds = string.Join(",", list.Select(x => x.OrderId)) });
                // var oclist = goods_OrderCommissionRepository.GetListGroupByOrderDetailIds(new RB_Goods_OrderCommission_Extend() { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, OrderIds = string.Join(",", list.Select(x => x.OrderId)) });
                if (dmodel.IsSelectOrderCommission == 1)
                {
                    if (oclist.Any())
                    {
                        //获取用户
                        var ulist = member_UserRepository.GetList(new RB_Member_User_Extend() { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, UserIds = string.Join(",", oclist.Select(x => x.UserId).Distinct()) });
                        //获取分销商
                        var dislist = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId, UserIds = string.Join(",", oclist.Select(x => x.UserId).Distinct()) });
                        var HpgradeList = new List<RB_Distributor_HPGradeInfo_Extend>();
                        if (oclist.Where(x => x.Type == 2).Any())
                        {
                            string gradeIds = string.Join(",", oclist.Where(x => x.Type == 2).Select(x => x.Grade).Distinct());
                            HpgradeList = distributor_HPGradeInfoRepository.GetList(new RB_Distributor_HPGradeInfo_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId }, true);
                        }
                        var FXGradeList = new List<RB_Distributor_FXGrade_Extend>();
                        if (oclist.Where(x => x.Type == 3).Any())
                        {
                            string gradeIds = string.Join(",", oclist.Where(x => x.Type == 3).Select(x => x.Grade).Distinct());
                            FXGradeList = distributor_FXGradeRepository.GetList(new RB_Distributor_FXGrade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                        }
                        foreach (var item in oclist)
                        {
                            var umodel = ulist.Where(x => x.Id == item.UserId).FirstOrDefault();
                            item.UserName = umodel?.Name ?? "";
                            item.Mobile = umodel?.Moblie ?? "";
                            item.Name = dislist.Where(x => x.UserId == item.UserId).FirstOrDefault()?.Name ?? "";
                            if (item.CommissionType == 1 || item.CommissionType == 4)
                            {
                                if (item.Type == 1)
                                {
                                    if (item.Grade == 0)
                                    {
                                        item.GradeDescription = "自购返利";
                                    }
                                    else if (item.Grade == 1)
                                    {
                                        item.GradeDescription = "一级佣金";
                                    }
                                    else if (item.Grade == 2)
                                    {
                                        item.GradeDescription = "二级佣金";
                                    }
                                    else if (item.Grade == 3)
                                    {
                                        item.GradeDescription = "三级佣金";
                                    }
                                }
                                else if (item.Type == 2)
                                {
                                    var hpGModel = HpgradeList.Where(x => x.Id == item.Grade).FirstOrDefault();
                                    item.GradeDescription = hpGModel?.GradeName ?? "暂无等级";
                                }
                                else if (item.Type == 3)
                                {
                                    var fxGModel = FXGradeList.Where(x => x.Id == item.Grade).FirstOrDefault();
                                    item.GradeDescription = fxGModel?.GradeName ?? "暂无等级";
                                }
                            }
                            else if (item.CommissionType == 2)
                            {
                                item.GradeDescription = "供应商返佣";
                            }
                            else if (item.CommissionType == 3)
                            {
                                item.GradeDescription = "微店返佣";
                            }
                        }
                    }
                }
                foreach (var item in list)
                {
                    item.OrderCommissionList = oclist.Where(x => x.OrderDetailId == item.Id).ToList();
                    item.FXCommission = (item.OrderCommissionList != null && item.OrderCommissionList.Any()) ? item.OrderCommissionList.Where(x => x.OrderDetailId == item.Id).Sum(x => (x.Commission ?? 0)) : 0;
                    item.RemitFXCommission = (item.OrderCommissionList != null && item.OrderCommissionList.Any()) ? item.OrderCommissionList.Where(x => x.OrderDetailId == item.Id && x.IsRemit == 1).Sum(x => (x.Commission ?? 0)) : 0;
                }
            }
            return list;
        }

        /// <summary>
        /// 售后订单
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<OrderStatistics_Query> GetFXAllAftersaleOrderProfitLossList(OrderStatistics_Query dmodel)
        {
            var list = orderRepository.GetFXAllAftersaleOrderProfitLossList(dmodel);
            return list;
        }

        /// <summary>
        /// 徐总统计
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<OrderStatistics_Query> GetFXAllAftersaleOrderProfitLossList_V2(OrderStatistics_Query dmodel)
        {
            var list = orderRepository.GetFXAllAftersaleOrderProfitLossList_V2(dmodel);
            return list;
        }


        /// <summary>
        /// 取消订单
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<OrderStatistics_Query> GetFXAllCancelOrderProfitLossList(OrderStatistics_Query dmodel)
        {
            var list = orderRepository.GetFXAllCancelOrderProfitLossList(dmodel);
            return list;
        }

        /// <summary>
        /// 徐总统计
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<OrderStatistics_Query> GetFXAllCancelOrderProfitLossList_V2(OrderStatistics_Query dmodel)
        {
            var list = orderRepository.GetFXAllCancelOrderProfitLossList_V2(dmodel);
            return list;
        }



        public List<RB_Goods_OrderCommission_Extend> GetByOrderDetailId(RB_Goods_OrderCommission_Extend model)
        {
            //分销情况
            var oclist = goods_OrderCommissionRepository.GetListGroupByUser_V2(model);
            if (oclist.Any())
            {
                //获取用户
                var ulist = member_UserRepository.GetList(new RB_Member_User_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, UserIds = string.Join(",", oclist.Select(x => x.UserId).Distinct()) });
                //获取分销商
                var dislist = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { TenantId = model.TenantId, MallBaseId = model.MallBaseId, UserIds = string.Join(",", oclist.Select(x => x.UserId).Distinct()) });
                var HpgradeList = new List<RB_Distributor_HPGradeInfo_Extend>();
                if (oclist.Where(x => x.Type == 2).Any())
                {
                    string gradeIds = string.Join(",", oclist.Where(x => x.Type == 2 && (x.CommissionType == 1 || x.CommissionType == 4)).Select(x => x.Grade).Distinct());
                    HpgradeList = distributor_HPGradeInfoRepository.GetList(new RB_Distributor_HPGradeInfo_Extend() { GradeIds = gradeIds, TenantId = model.TenantId, MallBaseId = model.MallBaseId }, true);
                }
                var FXGradeList = new List<RB_Distributor_FXGrade_Extend>();
                if (oclist.Where(x => x.Type == 3).Any())
                {
                    string gradeIds = string.Join(",", oclist.Where(x => x.Type == 3 && (x.CommissionType == 1 || x.CommissionType == 4)).Select(x => x.Grade).Distinct());
                    FXGradeList = distributor_FXGradeRepository.GetList(new RB_Distributor_FXGrade_Extend() { GradeIds = gradeIds, TenantId = model.TenantId, MallBaseId = model.MallBaseId });
                }
                foreach (var item in oclist)
                {
                    var umodel = ulist.Where(x => x.Id == item.UserId).FirstOrDefault();
                    item.UserName = umodel?.Name ?? "";
                    item.Mobile = umodel?.Moblie ?? "";
                    item.Name = dislist.Where(x => x.UserId == item.UserId).FirstOrDefault()?.Name ?? "";
                    if (item.CommissionType == 1 || item.CommissionType == 4)
                    {
                        if (item.Type == 1)
                        {
                            if (item.Grade == 0)
                            {
                                item.GradeDescription = "自购返利";
                            }
                            else if (item.Grade == 1)
                            {
                                item.GradeDescription = "一级佣金";
                            }
                            else if (item.Grade == 2)
                            {
                                item.GradeDescription = "二级佣金";
                            }
                            else if (item.Grade == 3)
                            {
                                item.GradeDescription = "三级佣金";
                            }
                        }
                        else if (item.Type == 2)
                        {
                            var hpGModel = HpgradeList.Where(x => x.Id == item.Grade).FirstOrDefault();
                            item.GradeDescription = hpGModel?.GradeName ?? "暂无等级";
                        }
                        else if (item.Type == 3)
                        {
                            var fxGModel = FXGradeList.Where(x => x.Id == item.Grade).FirstOrDefault();
                            item.GradeDescription = fxGModel?.GradeName ?? "暂无等级";
                        }
                    }
                    else if (item.CommissionType == 2)
                    {
                        item.GradeDescription = "供应商返佣";
                    }
                    else if (item.CommissionType == 3)
                    {
                        item.GradeDescription = "微店返佣";
                    }
                }
            }

            return oclist;
        }


        #endregion


        /// <summary>
        /// 获取近一周的数据
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public DataStatistics_Query GetWeeklyOrder(DataStatistics_Query dmodel)
        {
            if (dmodel.IsYesterday == 1)
            {
                dmodel.StartDate = dmodel.EndDate = System.DateTime.Now.AddDays(-1).ToString("yyyy-MM-dd");
            }
            else
            {
                dmodel.StartDate = System.DateTime.Now.ToString("yyyy-MM-dd");
                dmodel.EndDate = System.DateTime.Now.AddDays(-7).ToString("yyyy-MM-dd");
            }
            var List = orderRepository.GetWeeklyOrder(dmodel);

            DataStatistics_Query model = new DataStatistics_Query();
            if (List != null && List.Any())
            {
                model.OrderNum = List.Sum(x => x.OrderNum ?? 0); //List.Count();
                model.PayMoney = List.Sum(x => x.Income ?? 0);
                model.PayMemerNum = List.Sum(x => x.PayMemerNum); // List.GroupBy(x => x.UserId).Count();
                model.GoodsNum = List.Sum(x => x.GoodsTotalNum);
                model.MemberNum = List.Max(x => x.TotalPayMemerNum);
                model.OrderPay = List.Count();
                //model.PayMoney = List.Sum(x => x.Income ?? 0);
                //model.PayMemerNum = List.Sum(x => x.PayMemerNum );
                model.BuyNum = List.Sum(x => x.GoodsTotalNum);
                model.OrderLineList = new List<OrderLine>();
                if (dmodel.IsYesterday == 1)//同一天
                {
                    for (int i = 1; i < 24; i++)
                    {
                        OrderLine modelOrderLine = new OrderLine
                        {
                            OrderPay = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).Count(),
                            PayMoney = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).Sum(x => x.Income ?? 0),
                            PayMemerNum = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).GroupBy(x => x.UserId).Count(),
                            BuyNum = List.Where(x => x.CreateDate.Value.ToString("dd") == ((i > 9) ? ("0" + i) : i.ToString())).Sum(x => x.GoodsTotalNum),
                            DateStr = (i > 9) ? ("0" + i) : i.ToString()
                        };
                        model.OrderLineList.Add(modelOrderLine);
                    }
                }
                else
                {
                    for (int i = 0; i < 7; i++)
                    {
                        OrderLine modelOrderLine = new OrderLine
                        {
                            OrderPay = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).Count(),
                            PayMoney = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).Sum(x => x.Income ?? 0),
                            PayMemerNum = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).GroupBy(x => x.UserId).Count(),
                            BuyNum = List.Where(x => x.CreateDate.Value.ToString("yyyy-MM-dd") == System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")).Sum(x => x.GoodsTotalNum),
                            DateStr = System.DateTime.Now.AddDays(i).ToString("yyyy-MM-dd")
                        };
                        model.OrderLineList.Add(modelOrderLine);
                    }
                }
            }
            return model;
        }



        /// <summary>
        /// 商品购买力TOP排行
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetGoosTop(DataStatistics_Query dmodel)
        {
            return orderRepository.GetGoosTop(dmodel);
        }


        /// <summary>
        /// 用户购买力TOP排行
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetMemberTop(DataStatistics_Query dmodel)
        {
            return orderRepository.GetMemberTop(dmodel);
        }

        #endregion


        #region 销售报表
        /// <summary>
        /// 销售统计
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetSellPageList(int pageIndex, int pageSize, out long count, DataStatistics_Query dmodel)
        {
            var list = orderRepository.GetSellPageList(pageIndex, pageSize, out count, dmodel);
            if (dmodel.OrderStatus == 0 || dmodel.OrderStatus == 1 || dmodel.OrderStatus == 2 || dmodel.OrderStatus == 3)
            {
                if (list != null && list.Any())
                {
                    //订单用户人数
                    List<RB_Member_User_Extend> orderUserList = new List<RB_Member_User_Extend>();
                    //活跃用户人数
                    List<RB_Member_User_Extend> loginUserList = new List<RB_Member_User_Extend>();
                    if (dmodel.OrderStatus == 0)
                    {
                        string minDate = list.Min(qitem => qitem.CreateDate);
                        string maxDate = list.Max(qitem => qitem.CreateDate);
                        orderUserList = orderRepository.GetOrderUserStatisticsRepository(dmodel, minDate, maxDate);
                        loginUserList = member_UserRepository2.GetMemberUserStatisticsRepository(new RB_Member_User_Extend()
                        {
                            MallBaseId = dmodel.MallBaseId,
                            TenantId = dmodel.TenantId
                        }, minDate, maxDate);
                    }

                    dmodel.RepurchaseNum = 0;
                    dmodel.UserIds = string.Join(",", list.Select(x => x.UserIds));
                    var allOrderList = orderRepository.GetOrderByUserIds(dmodel);
                    foreach (var item in list)
                    {
                        item.LoginEmpActive = loginUserList?.Where(qitem => Convert.ToDateTime(qitem.CreateDate).ToString("yyyy-MM-dd") == item.CreateDate && qitem.PostId == 0 && qitem.SuperiorId > 0 && qitem.SuperiorId < 20)?.Count() ?? 0;
                        item.LoginLeaderActive = loginUserList?.Where(qitem => Convert.ToDateTime(qitem.CreateDate).ToString("yyyy-MM-dd") == item.CreateDate && qitem.PostId == 1)?.Count() ?? 0;

                        item.OrderEmpActive = orderUserList?.Where(qitem => Convert.ToDateTime(qitem.CreateDate).ToString("yyyy-MM-dd") == item.CreateDate && qitem.PostId == 0 && qitem.SuperiorId > 0 && qitem.SuperiorId < 20)?.Count() ?? 0;
                        item.OrderLeaderActice = orderUserList?.Where(qitem => Convert.ToDateTime(qitem.CreateDate).ToString("yyyy-MM-dd") == item.CreateDate && qitem.PostId == 1)?.Count() ?? 0;

                        if (!string.IsNullOrWhiteSpace(item.UserIds))
                        {
                            try
                            {
                                DateTime nowTime = Convert.ToDateTime(item.CreateDate + " 00:00:00");
                                foreach (var itemUserIds in item.UserIds.Split(","))
                                {
                                    int orderNum = allOrderList.Where(x => x.CreateDate < nowTime && x.UserId.ToString() == itemUserIds).Count();
                                    if (orderNum > 0)
                                    {
                                        item.RepurchaseNum +=1;
                                    }

                                }

                            }
                            catch (Exception)
                            {

                            }
                        }
                    }
                }
            }
            return list;
        }


        /// <summary>
        /// 总成交
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public DataStatistics_Query GetSellOrder(DataStatistics_Query dmodel)
        {
            var List = orderRepository.GetWeeklyOrder(dmodel);
            DataStatistics_Query model = new DataStatistics_Query();
            if (List != null && List.Any())
            {
                model.OrderNum = List.Sum(x => x.OrderNum ?? 0); //List.Count();
                model.PayMoney = List.Sum(x => x.Income ?? 0);
                model.PayMemerNum = List.Sum(x => x.PayMemerNum); // List.GroupBy(x => x.UserId).Count();
                model.GoodsNum = List.Sum(x => x.GoodsTotalNum);
                model.MemberNum = List.Max(x => x.TotalPayMemerNum);
                model.OfflineOrder = List.Sum(x => x.OfflineOrder);
                model.OfflineOrderPrice= List.Sum(x => x.OfflineOrderPrice);

            }
            return model;
        }


        /// <summary>
        /// 销售统计导出
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<DataStatistics_Query> GetSellExcel(DataStatistics_Query dmodel)
        {
            return orderRepository.GetSellExcel(dmodel);
        }

        #endregion


        #region 电商统计

        /// <summary>
        /// 获取月度统计
        /// </summary>
        /// <param name="month"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetDSMonthStatistics(string month, int tenantId, int mallBaseId)
        {
            string StartTime = month + "-01";
            string EndTime = Convert.ToDateTime(StartTime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            var list = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = StartTime, EndTime = EndTime });
            //上月查询
            string prvSTime = Convert.ToDateTime(StartTime).AddMonths(-1).ToString("yyyy-MM-dd");
            string prvETime = Convert.ToDateTime(prvSTime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            var prvlist = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = prvSTime, EndTime = prvETime });
            List<object> RList = new List<object>();
            #region 首先 查询上期平均值
            int PreDay = Convert.ToDateTime(prvETime).Day - 20;
            #region 上月
            decimal presCancelOrderNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.CancelOrderNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPeopleNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presOrderNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPayMoney = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presBuyNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgOrderNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgBuyNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgUnitPrice = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgBuyPrice = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presMemberNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPaymentNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presMOrderRate = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presReBuyNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presReBuyRate = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presNewPeopleNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPXNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presVipNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presYXNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presJXNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presProfit = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presProfitRate = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / PreDay, 2, MidpointRounding.AwayFromZero);
            #endregion

            RList.Add(new
            {
                Date = "上期平均",
                CancelOrderNum = presCancelOrderNum,
                PeopleNum = presPeopleNum,
                OrderNum = presOrderNum,
                PayMoney = presPayMoney,
                BuyNum = presBuyNum,
                AvgOrderNum = presAvgOrderNum,
                AvgBuyNum = presAvgBuyNum,
                AvgUnitPrice = presAvgUnitPrice,
                AvgBuyPrice = presAvgBuyPrice,
                MemberNum = presMemberNum,
                PaymentNum = presPaymentNum,
                MOrderRate = presMOrderRate,
                ReBuyNum = presReBuyNum,
                ReBuyRate = presReBuyRate,
                NewPeopleNum = presNewPeopleNum,
                PXNum = presPXNum,
                VipNum = presVipNum,
                YXNum = presYXNum,
                JXNum = presJXNum,
                Profit = presProfit,
                ProfitRate = presProfitRate
            });

            #endregion

            //根据日期遍历
            int MaxDay = Convert.ToDateTime(EndTime).Day;
            string SDate = StartTime;
            #region 上期参数
            decimal sCancelOrderNum = 0;
            decimal sPeopleNum = 0;
            decimal sOrderNum = 0;
            decimal sPayMoney = 0;
            decimal sBuyNum = 0;
            decimal sAvgOrderNum = 0;
            decimal sAvgBuyNum = 0;
            decimal sAvgUnitPrice = 0;
            decimal sAvgBuyPrice = 0;
            decimal sMemberNum = 0;
            decimal sPaymentNum = 0;
            decimal sMOrderRate = 0;
            decimal sReBuyNum = 0;
            decimal sReBuyRate = 0;
            decimal sNewPeopleNum = 0;
            decimal sPXNum = 0;
            decimal sVipNum = 0;
            decimal sYXNum = 0;
            decimal sJXNum = 0;
            decimal sProfit = 0;
            decimal sProfitRate = 0;
            #endregion
            #region 月平均参数
            decimal yCancelOrderNum = 0;
            decimal yPeopleNum = 0;
            decimal yOrderNum = 0;
            decimal yPayMoney = 0;
            decimal yBuyNum = 0;
            decimal yAvgOrderNum = 0;
            decimal yAvgBuyNum = 0;
            decimal yAvgUnitPrice = 0;
            decimal yAvgBuyPrice = 0;
            decimal yMemberNum = 0;
            decimal yPaymentNum = 0;
            decimal yMOrderRate = 0;
            decimal yReBuyNum = 0;
            decimal yReBuyRate = 0;
            decimal yNewPeopleNum = 0;
            decimal yPXNum = 0;
            decimal yVipNum = 0;
            decimal yYXNum = 0;
            decimal yJXNum = 0;
            decimal yProfit = 0;
            decimal yProfitRate = 0;
            #endregion
            while (true)
            {
                #region 正常组装
                var smodel = list.Where(x => x.Date == Convert.ToDateTime(SDate)).FirstOrDefault();
                RList.Add(new
                {
                    DateStr = Convert.ToDateTime(SDate).ToString("MM-dd"),
                    CancelOrderNum = smodel?.CancelOrderNum ?? 0,
                    PeopleNum = smodel?.PeopleNum ?? 0,
                    OrderNum = smodel?.OrderNum ?? 0,
                    PayMoney = smodel?.PayMoney ?? 0,
                    BuyNum = smodel?.BuyNum ?? 0,
                    AvgOrderNum = smodel?.AvgOrderNum ?? 0,
                    AvgBuyNum = smodel?.AvgBuyNum ?? 0,
                    AvgUnitPrice = smodel?.AvgUnitPrice ?? 0,
                    AvgBuyPrice = smodel?.AvgBuyPrice ?? 0,
                    MemberNum = smodel?.MemberNum ?? 0,
                    PaymentNum = smodel?.PaymentNum ?? 0,
                    MOrderRate = smodel?.MOrderRate ?? 0,
                    ReBuyNum = smodel?.ReBuyNum ?? 0,
                    ReBuyRate = smodel?.ReBuyRate ?? 0,
                    NewPeopleNum = smodel?.NewPeopleNum ?? 0,
                    PXNum = smodel?.PXNum ?? 0,
                    VipNum = smodel?.VipNum ?? 0,
                    YXNum = smodel?.YXNum ?? 0,
                    JXNum = smodel?.JXNum ?? 0,
                    Profit = smodel?.Profit ?? 0,
                    ProfitRate = smodel?.ProfitRate ?? 0
                });
                #endregion
                if (Convert.ToDateTime(SDate).Day == 10)
                {
                    #region 本月
                    decimal CancelOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.CancelOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal OrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PayMoney = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal BuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MemberNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PaymentNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MOrderRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal NewPeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal VipNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal YXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal JXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal Profit = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ProfitRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    #endregion
                    #region 平均
                    RList.Add(new
                    {
                        Date = "平均",
                        CancelOrderNum,
                        PeopleNum,
                        OrderNum,
                        PayMoney,
                        BuyNum,
                        AvgOrderNum,
                        AvgBuyNum,
                        AvgUnitPrice,
                        AvgBuyPrice,
                        MemberNum,
                        PaymentNum,
                        MOrderRate,
                        ReBuyNum,
                        ReBuyRate,
                        NewPeopleNum,
                        PXNum,
                        VipNum,
                        YXNum,
                        JXNum,
                        Profit,
                        ProfitRate
                    });
                    #endregion
                    #region 环比成长
                    RList.Add(new
                    {
                        Date = "环比成长",
                        CancelOrderNum = Math.Round(presCancelOrderNum > 0 ? (CancelOrderNum - presCancelOrderNum) / presCancelOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PeopleNum = Math.Round(presPeopleNum > 0 ? (PeopleNum - presPeopleNum) / presPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        OrderNum = Math.Round(presOrderNum > 0 ? (OrderNum - presOrderNum) / presOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PayMoney = Math.Round(presPayMoney > 0 ? (PayMoney - presPayMoney) / presPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        BuyNum = Math.Round(presBuyNum > 0 ? (BuyNum - presBuyNum) / presBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgOrderNum = Math.Round(presAvgOrderNum > 0 ? (AvgOrderNum - presAvgOrderNum) / presAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgBuyNum = Math.Round(presAvgBuyNum > 0 ? (AvgBuyNum - presAvgBuyNum) / presAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgUnitPrice = Math.Round(presAvgUnitPrice > 0 ? (AvgUnitPrice - presAvgUnitPrice) / presAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgBuyPrice = Math.Round(presAvgBuyPrice > 0 ? (AvgBuyPrice - presAvgBuyPrice) / presAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        MemberNum = Math.Round(presMemberNum > 0 ? (MemberNum - presMemberNum) / presMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PaymentNum = Math.Round(presPaymentNum > 0 ? (PaymentNum - presPaymentNum) / presPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        MOrderRate = Math.Round(presMOrderRate > 0 ? (MOrderRate - presMOrderRate) / presMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ReBuyNum = Math.Round(presReBuyNum > 0 ? (ReBuyNum - presReBuyNum) / presReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ReBuyRate = Math.Round(presReBuyRate > 0 ? (ReBuyRate - presReBuyRate) / presReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        NewPeopleNum = Math.Round(presNewPeopleNum > 0 ? (NewPeopleNum - presNewPeopleNum) / presNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PXNum = Math.Round(presPXNum > 0 ? (PXNum - presPXNum) / presPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        VipNum = Math.Round(presVipNum > 0 ? (VipNum - presVipNum) / presVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        YXNum = Math.Round(presYXNum > 0 ? (YXNum - presYXNum) / presYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        JXNum = Math.Round(presJXNum > 0 ? (JXNum - presJXNum) / presJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        Profit = Math.Round(presProfit > 0 ? (Profit - presProfit) / presProfit : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ProfitRate = Math.Round(presProfitRate > 0 ? (ProfitRate - presProfitRate) / presProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                    });
                    #endregion

                    #region 月平均
                    yCancelOrderNum += CancelOrderNum;
                    yPeopleNum += PeopleNum;
                    yOrderNum += OrderNum;
                    yPayMoney += PayMoney;
                    yBuyNum += BuyNum;
                    yAvgOrderNum += AvgOrderNum;
                    yAvgBuyNum += AvgBuyNum;
                    yAvgUnitPrice += AvgUnitPrice;
                    yAvgBuyPrice += AvgBuyPrice;
                    yMemberNum += MemberNum;
                    yPaymentNum += PaymentNum;
                    yMOrderRate += MOrderRate;
                    yReBuyNum += ReBuyNum;
                    yReBuyRate += ReBuyRate;
                    yNewPeopleNum += NewPeopleNum;
                    yPXNum += PXNum;
                    yVipNum += VipNum;
                    yYXNum += YXNum;
                    yJXNum += JXNum;
                    yProfit += Profit;
                    yProfitRate += ProfitRate;
                    #endregion
                    #region 当期赋值  用于下期环比
                    sCancelOrderNum = CancelOrderNum;
                    sPeopleNum = PeopleNum;
                    sOrderNum = OrderNum;
                    sPayMoney = PayMoney;
                    sBuyNum = BuyNum;
                    sAvgOrderNum = AvgOrderNum;
                    sAvgBuyNum = AvgBuyNum;
                    sAvgUnitPrice = AvgUnitPrice;
                    sAvgBuyPrice = AvgBuyPrice;
                    sMemberNum = MemberNum;
                    sPaymentNum = PaymentNum;
                    sMOrderRate = MOrderRate;
                    sReBuyNum = ReBuyNum;
                    sReBuyRate = ReBuyRate;
                    sNewPeopleNum = NewPeopleNum;
                    sPXNum = PXNum;
                    sVipNum = VipNum;
                    sYXNum = YXNum;
                    sJXNum = JXNum;
                    sProfit = Profit;
                    sProfitRate = ProfitRate;
                    #endregion
                }
                else if (Convert.ToDateTime(SDate).Day == 20)
                {
                    #region 本月
                    decimal CancelOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.CancelOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal OrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PayMoney = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal BuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MemberNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PaymentNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MOrderRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal NewPeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal VipNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal YXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal JXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal Profit = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ProfitRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    #endregion
                    #region 平均
                    RList.Add(new
                    {
                        Date = "平均",
                        CancelOrderNum,
                        PeopleNum,
                        OrderNum,
                        PayMoney,
                        BuyNum,
                        AvgOrderNum,
                        AvgBuyNum,
                        AvgUnitPrice,
                        AvgBuyPrice,
                        MemberNum,
                        PaymentNum,
                        MOrderRate,
                        ReBuyNum,
                        ReBuyRate,
                        NewPeopleNum,
                        PXNum,
                        VipNum,
                        YXNum,
                        JXNum,
                        Profit,
                        ProfitRate
                    });
                    #endregion
                    #region 环比成长
                    RList.Add(new
                    {
                        Date = "环比成长",
                        CancelOrderNum = Math.Round(sCancelOrderNum > 0 ? (CancelOrderNum - sCancelOrderNum) / sCancelOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PeopleNum = Math.Round(sPeopleNum > 0 ? (PeopleNum - sPeopleNum) / sPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        OrderNum = Math.Round(sOrderNum > 0 ? (OrderNum - sOrderNum) / sOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PayMoney = Math.Round(sPayMoney > 0 ? (PayMoney - sPayMoney) / sPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        BuyNum = Math.Round(sBuyNum > 0 ? (BuyNum - sBuyNum) / sBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgOrderNum = Math.Round(sAvgOrderNum > 0 ? (AvgOrderNum - sAvgOrderNum) / sAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgBuyNum = Math.Round(sAvgBuyNum > 0 ? (AvgBuyNum - sAvgBuyNum) / sAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgUnitPrice = Math.Round(sAvgUnitPrice > 0 ? (AvgUnitPrice - sAvgUnitPrice) / sAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgBuyPrice = Math.Round(sAvgBuyPrice > 0 ? (AvgBuyPrice - sAvgBuyPrice) / sAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        MemberNum = Math.Round(sMemberNum > 0 ? (MemberNum - sMemberNum) / sMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PaymentNum = Math.Round(sPaymentNum > 0 ? (PaymentNum - sPaymentNum) / sPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        MOrderRate = Math.Round(sMOrderRate > 0 ? (MOrderRate - sMOrderRate) / sMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ReBuyNum = Math.Round(sReBuyNum > 0 ? (ReBuyNum - sReBuyNum) / sReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ReBuyRate = Math.Round(sReBuyRate > 0 ? (ReBuyRate - sReBuyRate) / sReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        NewPeopleNum = Math.Round(sNewPeopleNum > 0 ? (NewPeopleNum - sNewPeopleNum) / sNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PXNum = Math.Round(sPXNum > 0 ? (PXNum - sPXNum) / sPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        VipNum = Math.Round(sVipNum > 0 ? (VipNum - sVipNum) / sVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        YXNum = Math.Round(sYXNum > 0 ? (YXNum - sYXNum) / sYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        JXNum = Math.Round(sJXNum > 0 ? (JXNum - sJXNum) / sJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        Profit = Math.Round(sProfit > 0 ? (Profit - sProfit) / sProfit : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ProfitRate = Math.Round(sProfitRate > 0 ? (ProfitRate - sProfitRate) / sProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                    });
                    #endregion

                    #region 月平均
                    yCancelOrderNum += CancelOrderNum;
                    yPeopleNum += PeopleNum;
                    yOrderNum += OrderNum;
                    yPayMoney += PayMoney;
                    yBuyNum += BuyNum;
                    yAvgOrderNum += AvgOrderNum;
                    yAvgBuyNum += AvgBuyNum;
                    yAvgUnitPrice += AvgUnitPrice;
                    yAvgBuyPrice += AvgBuyPrice;
                    yMemberNum += MemberNum;
                    yPaymentNum += PaymentNum;
                    yMOrderRate += MOrderRate;
                    yReBuyNum += ReBuyNum;
                    yReBuyRate += ReBuyRate;
                    yNewPeopleNum += NewPeopleNum;
                    yPXNum += PXNum;
                    yVipNum += VipNum;
                    yYXNum += YXNum;
                    yJXNum += JXNum;
                    yProfit += Profit;
                    yProfitRate += ProfitRate;
                    #endregion
                    #region 当期赋值  用于下期环比
                    sCancelOrderNum = CancelOrderNum;
                    sPeopleNum = PeopleNum;
                    sOrderNum = OrderNum;
                    sPayMoney = PayMoney;
                    sBuyNum = BuyNum;
                    sAvgOrderNum = AvgOrderNum;
                    sAvgBuyNum = AvgBuyNum;
                    sAvgUnitPrice = AvgUnitPrice;
                    sAvgBuyPrice = AvgBuyPrice;
                    sMemberNum = MemberNum;
                    sPaymentNum = PaymentNum;
                    sMOrderRate = MOrderRate;
                    sReBuyNum = ReBuyNum;
                    sReBuyRate = ReBuyRate;
                    sNewPeopleNum = NewPeopleNum;
                    sPXNum = PXNum;
                    sVipNum = VipNum;
                    sYXNum = YXNum;
                    sJXNum = JXNum;
                    sProfit = Profit;
                    sProfitRate = ProfitRate;
                    #endregion
                }
                else if (Convert.ToDateTime(SDate).Day == MaxDay)
                {
                    int NowDay = MaxDay - 20;
                    #region 本月
                    decimal CancelOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.CancelOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal OrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PayMoney = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal BuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal MemberNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PaymentNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal MOrderRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal NewPeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal VipNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal YXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal JXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal Profit = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal ProfitRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    #endregion
                    #region 平均
                    RList.Add(new
                    {
                        Date = "平均",
                        CancelOrderNum,
                        PeopleNum,
                        OrderNum,
                        PayMoney,
                        BuyNum,
                        AvgOrderNum,
                        AvgBuyNum,
                        AvgUnitPrice,
                        AvgBuyPrice,
                        MemberNum,
                        PaymentNum,
                        MOrderRate,
                        ReBuyNum,
                        ReBuyRate,
                        NewPeopleNum,
                        PXNum,
                        VipNum,
                        YXNum,
                        JXNum,
                        Profit,
                        ProfitRate
                    });
                    #endregion
                    #region 环比成长
                    RList.Add(new
                    {
                        Date = "环比成长",
                        CancelOrderNum = Math.Round(sCancelOrderNum > 0 ? (CancelOrderNum - sCancelOrderNum) / sCancelOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PeopleNum = Math.Round(sPeopleNum > 0 ? (PeopleNum - sPeopleNum) / sPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        OrderNum = Math.Round(sOrderNum > 0 ? (OrderNum - sOrderNum) / sOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PayMoney = Math.Round(sPayMoney > 0 ? (PayMoney - sPayMoney) / sPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        BuyNum = Math.Round(sBuyNum > 0 ? (BuyNum - sBuyNum) / sBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgOrderNum = Math.Round(sAvgOrderNum > 0 ? (AvgOrderNum - sAvgOrderNum) / sAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgBuyNum = Math.Round(sAvgBuyNum > 0 ? (AvgBuyNum - sAvgBuyNum) / sAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgUnitPrice = Math.Round(sAvgUnitPrice > 0 ? (AvgUnitPrice - sAvgUnitPrice) / sAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        AvgBuyPrice = Math.Round(sAvgBuyPrice > 0 ? (AvgBuyPrice - sAvgBuyPrice) / sAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        MemberNum = Math.Round(sMemberNum > 0 ? (MemberNum - sMemberNum) / sMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PaymentNum = Math.Round(sPaymentNum > 0 ? (PaymentNum - sPaymentNum) / sPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        MOrderRate = Math.Round(sMOrderRate > 0 ? (MOrderRate - sMOrderRate) / sMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ReBuyNum = Math.Round(sReBuyNum > 0 ? (ReBuyNum - sReBuyNum) / sReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ReBuyRate = Math.Round(sReBuyRate > 0 ? (ReBuyRate - sReBuyRate) / sReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        NewPeopleNum = Math.Round(sNewPeopleNum > 0 ? (NewPeopleNum - sNewPeopleNum) / sNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        PXNum = Math.Round(sPXNum > 0 ? (PXNum - sPXNum) / sPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        VipNum = Math.Round(sVipNum > 0 ? (VipNum - sVipNum) / sVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        YXNum = Math.Round(sYXNum > 0 ? (YXNum - sYXNum) / sYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        JXNum = Math.Round(sJXNum > 0 ? (JXNum - sJXNum) / sJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        Profit = Math.Round(sProfit > 0 ? (Profit - sProfit) / sProfit : 1, 4, MidpointRounding.AwayFromZero) * 100,
                        ProfitRate = Math.Round(sProfitRate > 0 ? (ProfitRate - sProfitRate) / sProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100,
                    });
                    #endregion

                    #region 月平均
                    yCancelOrderNum += CancelOrderNum;
                    yPeopleNum += PeopleNum;
                    yOrderNum += OrderNum;
                    yPayMoney += PayMoney;
                    yBuyNum += BuyNum;
                    yAvgOrderNum += AvgOrderNum;
                    yAvgBuyNum += AvgBuyNum;
                    yAvgUnitPrice += AvgUnitPrice;
                    yAvgBuyPrice += AvgBuyPrice;
                    yMemberNum += MemberNum;
                    yPaymentNum += PaymentNum;
                    yMOrderRate += MOrderRate;
                    yReBuyNum += ReBuyNum;
                    yReBuyRate += ReBuyRate;
                    yNewPeopleNum += NewPeopleNum;
                    yPXNum += PXNum;
                    yVipNum += VipNum;
                    yYXNum += YXNum;
                    yJXNum += JXNum;
                    yProfit += Profit;
                    yProfitRate += ProfitRate;
                    #endregion
                }

                if (SDate == EndTime)
                {
                    break;
                }
                SDate = Convert.ToDateTime(SDate).AddDays(1).ToString("yyyy-MM-dd");
            }

            #region 月平均
            RList.Add(new
            {
                Date = "月平均",
                CancelOrderNum = Math.Round(yCancelOrderNum / 3, 2, MidpointRounding.AwayFromZero),
                PeopleNum = Math.Round(yPeopleNum / 3, 2, MidpointRounding.AwayFromZero),
                OrderNum = Math.Round(yOrderNum / 3, 2, MidpointRounding.AwayFromZero),
                PayMoney = Math.Round(yPayMoney / 3, 2, MidpointRounding.AwayFromZero),
                BuyNum = Math.Round(yBuyNum / 3, 2, MidpointRounding.AwayFromZero),
                AvgOrderNum = Math.Round(yAvgOrderNum / 3, 2, MidpointRounding.AwayFromZero),
                AvgBuyNum = Math.Round(yAvgBuyNum / 3, 2, MidpointRounding.AwayFromZero),
                AvgUnitPrice = Math.Round(yAvgUnitPrice / 3, 2, MidpointRounding.AwayFromZero),
                AvgBuyPrice = Math.Round(yAvgBuyPrice / 3, 2, MidpointRounding.AwayFromZero),
                MemberNum = Math.Round(yMemberNum / 3, 2, MidpointRounding.AwayFromZero),
                PaymentNum = Math.Round(yPaymentNum / 3, 2, MidpointRounding.AwayFromZero),
                MOrderRate = Math.Round(yMOrderRate / 3, 2, MidpointRounding.AwayFromZero),
                ReBuyNum = Math.Round(yReBuyNum / 3, 2, MidpointRounding.AwayFromZero),
                ReBuyRate = Math.Round(yReBuyRate / 3, 2, MidpointRounding.AwayFromZero),
                NewPeopleNum = Math.Round(yNewPeopleNum / 3, 2, MidpointRounding.AwayFromZero),
                PXNum = Math.Round(yPXNum / 3, 2, MidpointRounding.AwayFromZero),
                VipNum = Math.Round(yVipNum / 3, 2, MidpointRounding.AwayFromZero),
                YXNum = Math.Round(yYXNum / 3, 2, MidpointRounding.AwayFromZero),
                JXNum = Math.Round(yJXNum / 3, 2, MidpointRounding.AwayFromZero),
                Profit = Math.Round(yProfit / 3, 2, MidpointRounding.AwayFromZero),
                ProfitRate = Math.Round(yProfitRate / 3, 2, MidpointRounding.AwayFromZero)
            });
            #endregion

            #region 会员累计
            int TotalPXNum = list.Any() ? list.Max(x => x.PXLJNum) : 0;
            int TotalVIPNum = list.Any() ? list.Max(x => x.VipLJNum) : 0;
            int TotalYXNum = list.Any() ? list.Max(x => x.YXLJNum) : 0;
            int TotalJXNum = list.Any() ? list.Max(x => x.JXLJNum) : 0;
            #endregion

            return new
            {
                TotalCancenNum = list.Sum(x => x.CancelOrderNum),
                TotalPeopleNum = list.Sum(x => x.PeopleNum),
                TotalOrderNum = list.Sum(x => x.OrderNum),
                TotalPayMoney = list.Sum(x => x.PayMoney),
                TotalBuyNum = list.Sum(x => x.BuyNum),
                TotalPXNum,
                TotalVIPNum,
                TotalYXNum,
                TotalJXNum,
                AvgCancelNum = presCancelOrderNum,
                AvgPeopleNum = presPeopleNum,
                AvgOrderNum = presOrderNum,
                AvgPayMoney = presPayMoney,
                AvgBuyNum = presBuyNum,
                AvgAvgOrderNum = presAvgOrderNum,
                AvgAvgBuyNum = presAvgBuyNum,
                AvgAvgUnitPrice = presAvgUnitPrice,
                AvgAvgBuyPrice = presAvgBuyPrice,
                AvgMemberNum = presMemberNum,
                AvgPaymentNum = presPaymentNum,
                AvgMOrderRate = presMOrderRate,
                AvgReBuyNum = presReBuyNum,
                AvgReBuyRate = presReBuyRate,
                AvgNewPeopleNum = presNewPeopleNum,
                AvgPXNum = presPXNum,
                AvgVipNum = presVipNum,
                AvgYXNum = presYXNum,
                AvgJXNum = presJXNum,
                AvgProfit = presProfit,
                AvgProfitRate = presProfitRate,
                MonthProfit = list.Sum(x => x.Profit),
                MonthProfitRate = Math.Round(Convert.ToDecimal(list.Sum(x => x.ProfitRate)) / MaxDay, 2, MidpointRounding.AwayFromZero),
                RList
            };
        }

        /// <summary>
        /// 电商月度统计  - excel数据组装
        /// </summary>
        /// <param name="month"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<ExcelDataSource> GetDSMonthStatisticsToExcel(string month, int tenantId, int mallBaseId)
        {
            List<ExcelDataSource> DataList = new List<ExcelDataSource>();
            string StartTime = month + "-01";
            string EndTime = Convert.ToDateTime(StartTime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            var list = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = StartTime, EndTime = EndTime });
            //上月查询
            string prvSTime = Convert.ToDateTime(StartTime).AddMonths(-1).ToString("yyyy-MM-dd");
            string prvETime = Convert.ToDateTime(prvSTime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            var prvlist = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = prvSTime, EndTime = prvETime });
            #region 首先 查询上期平均值
            int PreDay = Convert.ToDateTime(prvETime).Day - 20;
            #region 上月
            decimal presCancelOrderNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.CancelOrderNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPeopleNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presOrderNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPayMoney = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presBuyNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgOrderNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgBuyNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgUnitPrice = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presAvgBuyPrice = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presMemberNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPaymentNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presMOrderRate = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presReBuyNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presReBuyRate = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presNewPeopleNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presPXNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presVipNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presYXNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presJXNum = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presProfit = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / PreDay, 2, MidpointRounding.AwayFromZero);
            decimal presProfitRate = Math.Round(Convert.ToDecimal(prvlist.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / PreDay, 2, MidpointRounding.AwayFromZero);
            #endregion

            #endregion

            List<object> RList = new List<object>();
            //根据日期遍历
            int MaxDay = Convert.ToDateTime(EndTime).Day;
            string SDate = StartTime;
            #region 初始上期平均
            ExcelDataSource datarow = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value:"上期平均"){ },
                    new ExcelColumn(value:presPeopleNum.ToString()){ },
                    new ExcelColumn(value:presOrderNum.ToString()){ },
                    new ExcelColumn(value:presPayMoney.ToString()){ },
                    new ExcelColumn(value:presBuyNum.ToString()){ },
                    new ExcelColumn(value:presCancelOrderNum.ToString()){ },
                    new ExcelColumn(value:presAvgOrderNum.ToString()){ },
                    new ExcelColumn(value:presAvgBuyNum.ToString()){ },
                    new ExcelColumn(value:presAvgUnitPrice.ToString()){ },
                    new ExcelColumn(value:presAvgBuyPrice.ToString()){ },
                    new ExcelColumn(value:presMemberNum.ToString()){ },
                    new ExcelColumn(value:presPaymentNum.ToString()){ },
                    new ExcelColumn(value:presMOrderRate.ToString() + "%"){ },
                    new ExcelColumn(value:presReBuyNum.ToString()){ },
                    new ExcelColumn(value:presReBuyRate.ToString() + "%"){ },
                    new ExcelColumn(value:presNewPeopleNum.ToString()){ },
                    new ExcelColumn(value:presPXNum.ToString()){ },
                    new ExcelColumn(value:presVipNum.ToString()){ },
                    new ExcelColumn(value:presYXNum.ToString()){ },
                    new ExcelColumn(value:presJXNum.ToString()){ }
                },
                ColumnHight = 30
            };
            DataList.Add(datarow);
            //增加行空白
            DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 19 } } });
            #endregion

            #region 增加主标题
            ExcelDataSource header1 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value: "日期") { },
                    new ExcelColumn(value: "付款人數") { },
                    new ExcelColumn(value: "付款單數") {  },
                    new ExcelColumn(value: "付款金額") {  },
                    new ExcelColumn(value: "付款件數") {  },
                    new ExcelColumn(value: "取消單數") {  },
                    new ExcelColumn(value: "平均每人購買單數") {  },
                    new ExcelColumn(value: "平均每人購買件數") {  },
                    new ExcelColumn(value: "平均每單單價") { },
                    new ExcelColumn(value: "平均每人購買單價") {  },
                    new ExcelColumn(value: "會員累計數") {  },
                    new ExcelColumn(value: "付款累計人數") {  },
                    new ExcelColumn(value: "會員下訂單轉換率") {  },
                    new ExcelColumn(value: "復夠人數") { },
                    new ExcelColumn(value: "復夠率") { },
                    new ExcelColumn(value: "新人下單") {  },
                    new ExcelColumn(value: "普象") {  },
                    new ExcelColumn(value: "VIP") {  },
                    new ExcelColumn(value: "銀象") { },
                    new ExcelColumn(value: "金象") { }
                },
                ColumnHight = 30
            };
            DataList.Add(header1);
            #endregion

            #region 上期参数
            decimal sCancelOrderNum = 0;
            decimal sPeopleNum = 0;
            decimal sOrderNum = 0;
            decimal sPayMoney = 0;
            decimal sBuyNum = 0;
            decimal sAvgOrderNum = 0;
            decimal sAvgBuyNum = 0;
            decimal sAvgUnitPrice = 0;
            decimal sAvgBuyPrice = 0;
            decimal sMemberNum = 0;
            decimal sPaymentNum = 0;
            decimal sMOrderRate = 0;
            decimal sReBuyNum = 0;
            decimal sReBuyRate = 0;
            decimal sNewPeopleNum = 0;
            decimal sPXNum = 0;
            decimal sVipNum = 0;
            decimal sYXNum = 0;
            decimal sJXNum = 0;
            decimal sProfit = 0;
            decimal sProfitRate = 0;
            #endregion
            #region 月平均参数
            decimal yCancelOrderNum = 0;
            decimal yPeopleNum = 0;
            decimal yOrderNum = 0;
            decimal yPayMoney = 0;
            decimal yBuyNum = 0;
            decimal yAvgOrderNum = 0;
            decimal yAvgBuyNum = 0;
            decimal yAvgUnitPrice = 0;
            decimal yAvgBuyPrice = 0;
            decimal yMemberNum = 0;
            decimal yPaymentNum = 0;
            decimal yMOrderRate = 0;
            decimal yReBuyNum = 0;
            decimal yReBuyRate = 0;
            decimal yNewPeopleNum = 0;
            decimal yPXNum = 0;
            decimal yVipNum = 0;
            decimal yYXNum = 0;
            decimal yJXNum = 0;
            decimal yProfit = 0;
            decimal yProfitRate = 0;
            #endregion
            while (true)
            {
                #region 正常组装
                var smodel = list.Where(x => x.Date == Convert.ToDateTime(SDate)).FirstOrDefault();
                ExcelDataSource datarow1 = new ExcelDataSource()
                {
                    ExcelRows = new List<ExcelColumn>(23) {
                        new ExcelColumn(value:Convert.ToDateTime(SDate).ToString("MM月dd日")){ },
                        new ExcelColumn(value:(smodel?.PeopleNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.OrderNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.PayMoney ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.BuyNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.CancelOrderNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.AvgOrderNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.AvgBuyNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.AvgUnitPrice ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.AvgBuyPrice ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.MemberNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.PaymentNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.MOrderRate ?? 0).ToString() + "%"){ },
                        new ExcelColumn(value:(smodel?.ReBuyNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.ReBuyRate ?? 0).ToString() + "%"){ },
                        new ExcelColumn(value:(smodel?.NewPeopleNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.PXNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.VipNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.YXNum ?? 0).ToString()){ },
                        new ExcelColumn(value:(smodel?.JXNum ?? 0).ToString()){ },
                    },
                    ColumnHight = 30
                };
                DataList.Add(datarow1);
                #endregion
                if (Convert.ToDateTime(SDate).Day == 10)
                {
                    #region 本月
                    decimal CancelOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.CancelOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal OrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PayMoney = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal BuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MemberNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PaymentNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MOrderRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal NewPeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal VipNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal YXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal JXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal Profit = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ProfitRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day <= 10).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    #endregion

                    #region 平均
                    ExcelDataSource datarow2 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value:"平均"){ },
                            new ExcelColumn(value:(PeopleNum).ToString()){ },
                            new ExcelColumn(value:(OrderNum).ToString()){ },
                            new ExcelColumn(value:(PayMoney).ToString()){ },
                            new ExcelColumn(value:(BuyNum).ToString()){ },
                            new ExcelColumn(value:(CancelOrderNum).ToString()){ },
                            new ExcelColumn(value:(AvgOrderNum).ToString()){ },
                            new ExcelColumn(value:(AvgBuyNum).ToString()){ },
                            new ExcelColumn(value:(AvgUnitPrice).ToString()){ },
                            new ExcelColumn(value:(AvgBuyPrice).ToString()){ },
                            new ExcelColumn(value:(MemberNum).ToString()){ },
                            new ExcelColumn(value:(PaymentNum).ToString()){ },
                            new ExcelColumn(value:(MOrderRate).ToString()+ "%"){ },
                            new ExcelColumn(value:(ReBuyNum).ToString()){ },
                            new ExcelColumn(value:(ReBuyRate).ToString()+ "%"){ },
                            new ExcelColumn(value:(NewPeopleNum).ToString()){ },
                            new ExcelColumn(value:(PXNum).ToString()){ },
                            new ExcelColumn(value:(VipNum).ToString()){ },
                            new ExcelColumn(value:(YXNum).ToString()){ },
                            new ExcelColumn(value:(JXNum).ToString()){ },
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(datarow2);
                    #endregion
                    #region 环比成长
                    ExcelDataSource datarow3 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value:"环比成长"){ },
                            new ExcelColumn(value:(Math.Round(presPeopleNum > 0 ? (PeopleNum - presPeopleNum) / presPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presOrderNum > 0 ? (OrderNum - presOrderNum) / presOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presPayMoney > 0 ? (PayMoney - presPayMoney) / presPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presBuyNum > 0 ? (BuyNum - presBuyNum) / presBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presCancelOrderNum > 0 ? (CancelOrderNum - presCancelOrderNum) / presCancelOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presAvgOrderNum > 0 ? (AvgOrderNum - presAvgOrderNum) / presAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presAvgBuyNum > 0 ? (AvgBuyNum - presAvgBuyNum) / presAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presAvgUnitPrice > 0 ? (AvgUnitPrice - presAvgUnitPrice) / presAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presAvgBuyPrice > 0 ? (AvgBuyPrice - presAvgBuyPrice) / presAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presMemberNum > 0 ? (MemberNum - presMemberNum) / presMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presPaymentNum > 0 ? (PaymentNum - presPaymentNum) / presPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presMOrderRate > 0 ? (MOrderRate - presMOrderRate) / presMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presReBuyNum > 0 ? (ReBuyNum - presReBuyNum) / presReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presReBuyRate > 0 ? (ReBuyRate - presReBuyRate) / presReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presNewPeopleNum > 0 ? (NewPeopleNum - presNewPeopleNum) / presNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presPXNum > 0 ? (PXNum - presPXNum) / presPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presVipNum > 0 ? (VipNum - presVipNum) / presVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presYXNum > 0 ? (YXNum - presYXNum) / presYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(presJXNum > 0 ? (JXNum - presJXNum) / presJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(datarow3);
                    #endregion
                    #region 增加主标题
                    //增加行空白
                    DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 19 } } });

                    ExcelDataSource header4 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value: "日期") { },
                            new ExcelColumn(value: "付款人數") { },
                            new ExcelColumn(value: "付款單數") {  },
                            new ExcelColumn(value: "付款金額") {  },
                            new ExcelColumn(value: "付款件數") {  },
                            new ExcelColumn(value: "取消單數") {  },
                            new ExcelColumn(value: "平均每人購買單數") {  },
                            new ExcelColumn(value: "平均每人購買件數") {  },
                            new ExcelColumn(value: "平均每單單價") { },
                            new ExcelColumn(value: "平均每人購買單價") {  },
                            new ExcelColumn(value: "會員累計數") {  },
                            new ExcelColumn(value: "付款累計人數") {  },
                            new ExcelColumn(value: "會員下訂單轉換率") {  },
                            new ExcelColumn(value: "復夠人數") { },
                            new ExcelColumn(value: "復夠率") { },
                            new ExcelColumn(value: "新人下單") {  },
                            new ExcelColumn(value: "普象") {  },
                            new ExcelColumn(value: "VIP") {  },
                            new ExcelColumn(value: "銀象") { },
                            new ExcelColumn(value: "金象") { }
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(header4);
                    #endregion


                    #region 月平均
                    yCancelOrderNum += CancelOrderNum;
                    yPeopleNum += PeopleNum;
                    yOrderNum += OrderNum;
                    yPayMoney += PayMoney;
                    yBuyNum += BuyNum;
                    yAvgOrderNum += AvgOrderNum;
                    yAvgBuyNum += AvgBuyNum;
                    yAvgUnitPrice += AvgUnitPrice;
                    yAvgBuyPrice += AvgBuyPrice;
                    yMemberNum += MemberNum;
                    yPaymentNum += PaymentNum;
                    yMOrderRate += MOrderRate;
                    yReBuyNum += ReBuyNum;
                    yReBuyRate += ReBuyRate;
                    yNewPeopleNum += NewPeopleNum;
                    yPXNum += PXNum;
                    yVipNum += VipNum;
                    yYXNum += YXNum;
                    yJXNum += JXNum;
                    yProfit += Profit;
                    yProfitRate += ProfitRate;
                    #endregion
                    #region 当期赋值  用于下期环比
                    sCancelOrderNum = CancelOrderNum;
                    sPeopleNum = PeopleNum;
                    sOrderNum = OrderNum;
                    sPayMoney = PayMoney;
                    sBuyNum = BuyNum;
                    sAvgOrderNum = AvgOrderNum;
                    sAvgBuyNum = AvgBuyNum;
                    sAvgUnitPrice = AvgUnitPrice;
                    sAvgBuyPrice = AvgBuyPrice;
                    sMemberNum = MemberNum;
                    sPaymentNum = PaymentNum;
                    sMOrderRate = MOrderRate;
                    sReBuyNum = ReBuyNum;
                    sReBuyRate = ReBuyRate;
                    sNewPeopleNum = NewPeopleNum;
                    sPXNum = PXNum;
                    sVipNum = VipNum;
                    sYXNum = YXNum;
                    sJXNum = JXNum;
                    sProfit = Profit;
                    sProfitRate = ProfitRate;
                    #endregion
                }
                else if (Convert.ToDateTime(SDate).Day == 20)
                {
                    #region 本月
                    decimal CancelOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.CancelOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal OrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PayMoney = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal BuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MemberNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PaymentNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal MOrderRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal NewPeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal PXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal VipNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal YXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal JXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal Profit = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                    decimal ProfitRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                    #endregion

                    #region 平均
                    ExcelDataSource datarow2 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value:"平均"){ },
                            new ExcelColumn(value:(PeopleNum).ToString()){ },
                            new ExcelColumn(value:(OrderNum).ToString()){ },
                            new ExcelColumn(value:(PayMoney).ToString()){ },
                            new ExcelColumn(value:(BuyNum).ToString()){ },
                            new ExcelColumn(value:(CancelOrderNum).ToString()){ },
                            new ExcelColumn(value:(AvgOrderNum).ToString()){ },
                            new ExcelColumn(value:(AvgBuyNum).ToString()){ },
                            new ExcelColumn(value:(AvgUnitPrice).ToString()){ },
                            new ExcelColumn(value:(AvgBuyPrice).ToString()){ },
                            new ExcelColumn(value:(MemberNum).ToString()){ },
                            new ExcelColumn(value:(PaymentNum).ToString()){ },
                            new ExcelColumn(value:(MOrderRate).ToString()+ "%"){ },
                            new ExcelColumn(value:(ReBuyNum).ToString()){ },
                            new ExcelColumn(value:(ReBuyRate).ToString()+ "%"){ },
                            new ExcelColumn(value:(NewPeopleNum).ToString()){ },
                            new ExcelColumn(value:(PXNum).ToString()){ },
                            new ExcelColumn(value:(VipNum).ToString()){ },
                            new ExcelColumn(value:(YXNum).ToString()){ },
                            new ExcelColumn(value:(JXNum).ToString()){ },
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(datarow2);
                    #endregion
                    #region 环比成长
                    ExcelDataSource datarow3 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value:"环比成长"){ },
                            new ExcelColumn(value:(Math.Round(sPeopleNum > 0 ? (PeopleNum - sPeopleNum) / sPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sOrderNum > 0 ? (OrderNum - sOrderNum) / sOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sPayMoney > 0 ? (PayMoney - sPayMoney) / sPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sBuyNum > 0 ? (BuyNum - sBuyNum) / sBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sCancelOrderNum > 0 ? (CancelOrderNum - sCancelOrderNum) / sCancelOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgOrderNum > 0 ? (AvgOrderNum - sAvgOrderNum) / sAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgBuyNum > 0 ? (AvgBuyNum - sAvgBuyNum) / sAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgUnitPrice > 0 ? (AvgUnitPrice - sAvgUnitPrice) / sAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgBuyPrice > 0 ? (AvgBuyPrice - sAvgBuyPrice) / sAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sMemberNum > 0 ? (MemberNum - sMemberNum) / sMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sPaymentNum > 0 ? (PaymentNum - sPaymentNum) / sPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sMOrderRate > 0 ? (MOrderRate - sMOrderRate) / sMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sReBuyNum > 0 ? (ReBuyNum - sReBuyNum) / sReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sReBuyRate > 0 ? (ReBuyRate - sReBuyRate) / sReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sNewPeopleNum > 0 ? (NewPeopleNum - sNewPeopleNum) / sNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sPXNum > 0 ? (PXNum - sPXNum) / sPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sVipNum > 0 ? (VipNum - sVipNum) / sVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sYXNum > 0 ? (YXNum - sYXNum) / sYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sJXNum > 0 ? (JXNum - sJXNum) / sJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(datarow3);
                    #endregion

                    #region 增加主标题
                    //增加行空白
                    DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 19 } } });

                    ExcelDataSource header4 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value: "日期") { },
                            new ExcelColumn(value: "付款人數") { },
                            new ExcelColumn(value: "付款單數") {  },
                            new ExcelColumn(value: "付款金額") {  },
                            new ExcelColumn(value: "付款件數") {  },
                            new ExcelColumn(value: "取消單數") {  },
                            new ExcelColumn(value: "平均每人購買單數") {  },
                            new ExcelColumn(value: "平均每人購買件數") {  },
                            new ExcelColumn(value: "平均每單單價") { },
                            new ExcelColumn(value: "平均每人購買單價") {  },
                            new ExcelColumn(value: "會員累計數") {  },
                            new ExcelColumn(value: "付款累計人數") {  },
                            new ExcelColumn(value: "會員下訂單轉換率") {  },
                            new ExcelColumn(value: "復夠人數") { },
                            new ExcelColumn(value: "復夠率") { },
                            new ExcelColumn(value: "新人下單") {  },
                            new ExcelColumn(value: "普象") {  },
                            new ExcelColumn(value: "VIP") {  },
                            new ExcelColumn(value: "銀象") { },
                            new ExcelColumn(value: "金象") { }
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(header4);
                    #endregion

                    #region 月平均
                    yCancelOrderNum += CancelOrderNum;
                    yPeopleNum += PeopleNum;
                    yOrderNum += OrderNum;
                    yPayMoney += PayMoney;
                    yBuyNum += BuyNum;
                    yAvgOrderNum += AvgOrderNum;
                    yAvgBuyNum += AvgBuyNum;
                    yAvgUnitPrice += AvgUnitPrice;
                    yAvgBuyPrice += AvgBuyPrice;
                    yMemberNum += MemberNum;
                    yPaymentNum += PaymentNum;
                    yMOrderRate += MOrderRate;
                    yReBuyNum += ReBuyNum;
                    yReBuyRate += ReBuyRate;
                    yNewPeopleNum += NewPeopleNum;
                    yPXNum += PXNum;
                    yVipNum += VipNum;
                    yYXNum += YXNum;
                    yJXNum += JXNum;
                    yProfit += Profit;
                    yProfitRate += ProfitRate;
                    #endregion
                    #region 当期赋值  用于下期环比
                    sCancelOrderNum = CancelOrderNum;
                    sPeopleNum = PeopleNum;
                    sOrderNum = OrderNum;
                    sPayMoney = PayMoney;
                    sBuyNum = BuyNum;
                    sAvgOrderNum = AvgOrderNum;
                    sAvgBuyNum = AvgBuyNum;
                    sAvgUnitPrice = AvgUnitPrice;
                    sAvgBuyPrice = AvgBuyPrice;
                    sMemberNum = MemberNum;
                    sPaymentNum = PaymentNum;
                    sMOrderRate = MOrderRate;
                    sReBuyNum = ReBuyNum;
                    sReBuyRate = ReBuyRate;
                    sNewPeopleNum = NewPeopleNum;
                    sPXNum = PXNum;
                    sVipNum = VipNum;
                    sYXNum = YXNum;
                    sJXNum = JXNum;
                    sProfit = Profit;
                    sProfitRate = ProfitRate;
                    #endregion
                }
                else if (Convert.ToDateTime(SDate).Day == MaxDay)
                {
                    int NowDay = MaxDay - 20;
                    #region 本月
                    decimal CancelOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.CancelOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal OrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PayMoney = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal BuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgOrderNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal MemberNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PaymentNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal MOrderRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal ReBuyRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal NewPeopleNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal PXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal VipNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal YXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal JXNum = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal Profit = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    decimal ProfitRate = Math.Round(Convert.ToDecimal(list.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                    #endregion

                    #region 平均
                    ExcelDataSource datarow2 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value:"平均"){ },
                            new ExcelColumn(value:(PeopleNum).ToString()){ },
                            new ExcelColumn(value:(OrderNum).ToString()){ },
                            new ExcelColumn(value:(PayMoney).ToString()){ },
                            new ExcelColumn(value:(BuyNum).ToString()){ },
                            new ExcelColumn(value:(CancelOrderNum).ToString()){ },
                            new ExcelColumn(value:(AvgOrderNum).ToString()){ },
                            new ExcelColumn(value:(AvgBuyNum).ToString()){ },
                            new ExcelColumn(value:(AvgUnitPrice).ToString()){ },
                            new ExcelColumn(value:(AvgBuyPrice).ToString()){ },
                            new ExcelColumn(value:(MemberNum).ToString()){ },
                            new ExcelColumn(value:(PaymentNum).ToString()){ },
                            new ExcelColumn(value:(MOrderRate).ToString()+ "%"){ },
                            new ExcelColumn(value:(ReBuyNum).ToString()){ },
                            new ExcelColumn(value:(ReBuyRate).ToString()+ "%"){ },
                            new ExcelColumn(value:(NewPeopleNum).ToString()){ },
                            new ExcelColumn(value:(PXNum).ToString()){ },
                            new ExcelColumn(value:(VipNum).ToString()){ },
                            new ExcelColumn(value:(YXNum).ToString()){ },
                            new ExcelColumn(value:(JXNum).ToString()){ },
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(datarow2);
                    #endregion
                    #region 环比成长
                    ExcelDataSource datarow3 = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value:"环比成长"){ },
                            new ExcelColumn(value:(Math.Round(sPeopleNum > 0 ? (PeopleNum - sPeopleNum) / sPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sOrderNum > 0 ? (OrderNum - sOrderNum) / sOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sPayMoney > 0 ? (PayMoney - sPayMoney) / sPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sBuyNum > 0 ? (BuyNum - sBuyNum) / sBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sCancelOrderNum > 0 ? (CancelOrderNum - sCancelOrderNum) / sCancelOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgOrderNum > 0 ? (AvgOrderNum - sAvgOrderNum) / sAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgBuyNum > 0 ? (AvgBuyNum - sAvgBuyNum) / sAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgUnitPrice > 0 ? (AvgUnitPrice - sAvgUnitPrice) / sAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sAvgBuyPrice > 0 ? (AvgBuyPrice - sAvgBuyPrice) / sAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sMemberNum > 0 ? (MemberNum - sMemberNum) / sMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sPaymentNum > 0 ? (PaymentNum - sPaymentNum) / sPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sMOrderRate > 0 ? (MOrderRate - sMOrderRate) / sMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sReBuyNum > 0 ? (ReBuyNum - sReBuyNum) / sReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sReBuyRate > 0 ? (ReBuyRate - sReBuyRate) / sReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sNewPeopleNum > 0 ? (NewPeopleNum - sNewPeopleNum) / sNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sPXNum > 0 ? (PXNum - sPXNum) / sPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sVipNum > 0 ? (VipNum - sVipNum) / sVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sYXNum > 0 ? (YXNum - sYXNum) / sYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                            new ExcelColumn(value:(Math.Round(sJXNum > 0 ? (JXNum - sJXNum) / sJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100).ToString("#0.00")+ "%"){ },
                        },
                        ColumnHight = 30
                    };
                    DataList.Add(datarow3);
                    #endregion

                    //增加行空白
                    DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 19 } } });

                    #region 月平均
                    yCancelOrderNum += CancelOrderNum;
                    yPeopleNum += PeopleNum;
                    yOrderNum += OrderNum;
                    yPayMoney += PayMoney;
                    yBuyNum += BuyNum;
                    yAvgOrderNum += AvgOrderNum;
                    yAvgBuyNum += AvgBuyNum;
                    yAvgUnitPrice += AvgUnitPrice;
                    yAvgBuyPrice += AvgBuyPrice;
                    yMemberNum += MemberNum;
                    yPaymentNum += PaymentNum;
                    yMOrderRate += MOrderRate;
                    yReBuyNum += ReBuyNum;
                    yReBuyRate += ReBuyRate;
                    yNewPeopleNum += NewPeopleNum;
                    yPXNum += PXNum;
                    yVipNum += VipNum;
                    yYXNum += YXNum;
                    yJXNum += JXNum;
                    yProfit += Profit;
                    yProfitRate += ProfitRate;
                    #endregion
                }

                if (SDate == EndTime)
                {
                    break;
                }
                SDate = Convert.ToDateTime(SDate).AddDays(1).ToString("yyyy-MM-dd");
            }

            #region 月平均
            ExcelDataSource datarow5 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                            new ExcelColumn(value:"月平均"){ },
                            new ExcelColumn(value: Math.Round(yPeopleNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yOrderNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yPayMoney/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yBuyNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yCancelOrderNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yAvgOrderNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yAvgBuyNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yAvgUnitPrice/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yAvgBuyPrice/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yMemberNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yPaymentNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yMOrderRate/3,2,MidpointRounding.AwayFromZero).ToString()+ "%"){ },
                            new ExcelColumn(value:Math.Round(yReBuyNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yReBuyRate/3,2,MidpointRounding.AwayFromZero).ToString()+ "%"){ },
                            new ExcelColumn(value:Math.Round(yNewPeopleNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yPXNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yVipNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yYXNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                            new ExcelColumn(value:Math.Round(yJXNum/3,2,MidpointRounding.AwayFromZero).ToString()){ },
                        },
                ColumnHight = 30
            };
            DataList.Add(datarow5);
            #endregion

            //增加行空白
            DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 19 } } });

            #region 增加统计标题
            ExcelDataSource header2 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "付款人數累計") { },
                    new ExcelColumn(value: "付款單數累計") { },
                    new ExcelColumn(value: "付款金額累計") { },
                    new ExcelColumn(value: "購買件數累計") { },
                    new ExcelColumn(value: "取消單數累計") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "普象累計") { },
                    new ExcelColumn(value: "VIP累計") { },
                    new ExcelColumn(value: "銀象累計") { },
                    new ExcelColumn(value: "金象累計") { }
                },
                ColumnHight = 30
            };
            DataList.Add(header2);
            #endregion

            #region 会员累计
            int TotalPXNum = list.Any() ? list.Max(x => x.PXLJNum) : 0;
            int TotalVIPNum = list.Any() ? list.Max(x => x.VipLJNum) : 0;
            int TotalYXNum = list.Any() ? list.Max(x => x.YXLJNum) : 0;
            int TotalJXNum = list.Any() ? list.Max(x => x.JXLJNum) : 0;

            ExcelDataSource datarow7 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value: "月小计") { },
                    new ExcelColumn(value: list.Sum(x => x.PeopleNum).ToString()) { },
                    new ExcelColumn(value: list.Sum(x => x.OrderNum).ToString()) { },
                    new ExcelColumn(value: list.Sum(x => x.PayMoney).ToString()) { },
                    new ExcelColumn(value: list.Sum(x => x.BuyNum).ToString()) { },
                    new ExcelColumn(value: list.Sum(x => x.CancelOrderNum).ToString()) { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: TotalPXNum.ToString()) { },
                    new ExcelColumn(value: TotalVIPNum.ToString()) { },
                    new ExcelColumn(value: TotalYXNum.ToString()) { },
                    new ExcelColumn(value: TotalJXNum.ToString()) { }
                },
                ColumnHight = 30
            };
            DataList.Add(datarow7);
            ExcelDataSource datarow8 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value: "月毛利") { },
                    new ExcelColumn(value: list.Sum(x => x.Profit).ToString()) { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "會員總數") { },
                    new ExcelColumn(value: (TotalPXNum+TotalVIPNum+TotalYXNum+TotalJXNum).ToString()) { }
                },
                ColumnHight = 30
            };
            DataList.Add(datarow8);
            ExcelDataSource datarow6 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value: "毛利率") { },
                    new ExcelColumn(value: Math.Round(Convert.ToDecimal(list.Sum(x => x.ProfitRate)) / MaxDay, 2, MidpointRounding.AwayFromZero).ToString()+ "%") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { },
                    new ExcelColumn(value: "") { }
                },
                ColumnHight = 30
            };
            DataList.Add(datarow6);
            #endregion

            return DataList;
        }

        /// <summary>
        /// 获取每月统计
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetDSMoreMonthStatistics(string startTime, string endTime, int tenantId, int mallBaseId)
        {
            string StartDate = Convert.ToDateTime(startTime + "-01").AddMonths(-1).ToString("yyyy-MM-dd");// 默认查询提前一个月  用于做对比
            string EndDate = Convert.ToDateTime(endTime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            var list = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = StartDate, EndTime = EndDate });
            List<User_Statistics_Query> MonthSList = new List<User_Statistics_Query>();//月统计数据
            //根据月份遍历
            string SMonth = Convert.ToDateTime(StartDate).ToString("yyyy-MM");
            int TotalMonthNum = 0;
            while (true)
            {
                TotalMonthNum++;
                User_Statistics_Query mmodel = new User_Statistics_Query() { Date = SMonth };
                //查询当月数据
                var mlist = list.Where(x => x.DateMonth == SMonth).ToList();
                mmodel.PeopleNum = mlist.Sum(x => x.PeopleNum);
                mmodel.OrderNum = mlist.Sum(x => x.OrderNum);
                mmodel.PayMoney = mlist.Sum(x => x.PayMoney);
                mmodel.BuyNum = mlist.Sum(x => x.BuyNum);
                mmodel.TotalPayPeople = mlist.Any() ? mlist.Max(x => x.PaymentNum) : 0;
                mmodel.Profit = mlist.Sum(x => x.Profit);
                //抓取累计数据  不使用累计
                //int TotalPXNum = mlist.Any() ? mlist.Max(x => x.PXLJNum) : 0;
                //int TotalVIPNum = mlist.Any() ? mlist.Max(x => x.VipLJNum) : 0;
                //int TotalYXNum = mlist.Any() ? mlist.Max(x => x.YXLJNum) : 0;
                //int TotalJXNum = mlist.Any() ? mlist.Max(x => x.JXLJNum) : 0;
                mmodel.PXNum = mlist.Sum(x => x.PXNum);
                mmodel.VipNum = mlist.Sum(x => x.VipNum);
                mmodel.YXNum = mlist.Sum(x => x.YXNum);
                mmodel.JXNum = mlist.Sum(x => x.JXNum);
                mmodel.TotalMNum = mmodel.PXNum + mmodel.VipNum + mmodel.YXNum + mmodel.JXNum;

                #region 求月平均
                #region 月平均参数
                decimal yPeopleNum = 0;
                decimal yOrderNum = 0;
                decimal yPayMoney = 0;
                decimal yBuyNum = 0;
                decimal yAvgOrderNum = 0;
                decimal yAvgBuyNum = 0;
                decimal yAvgUnitPrice = 0;
                decimal yAvgBuyPrice = 0;
                decimal yMemberNum = 0;
                decimal yPaymentNum = 0;
                decimal yMOrderRate = 0;
                decimal yReBuyNum = 0;
                decimal yReBuyRate = 0;
                decimal yNewPeopleNum = 0;
                decimal yPXNum = 0;
                decimal yVipNum = 0;
                decimal yYXNum = 0;
                decimal yJXNum = 0;
                decimal yProfit = 0;
                decimal yProfitRate = 0;
                #endregion
                string SDate = SMonth + "-01";
                string EDate = Convert.ToDateTime(SMonth + "-01").AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
                int MaxDay = Convert.ToDateTime(EDate).Day;
                while (true)
                {
                    if (Convert.ToDateTime(SDate).Day == 10)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    else if (Convert.ToDateTime(SDate).Day == 20)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    else if (Convert.ToDateTime(SDate).Day == MaxDay)
                    {
                        int NowDay = MaxDay - 20;
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }

                    if (SDate == EDate)
                    {
                        break;
                    }
                    SDate = Convert.ToDateTime(SDate).AddDays(1).ToString("yyyy-MM-dd");
                }

                #region 月平均赋值
                mmodel.MAvgPeopleNum = Math.Round(yPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.MAvgOrderNum = Math.Round(yOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.MAvgPayMoney = Math.Round(yPayMoney / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.MAvgBuyNum = Math.Round(yBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgOrderNum = Math.Round(yAvgOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgBuyNum = Math.Round(yAvgBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgUnitPrice = Math.Round(yAvgUnitPrice / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgBuyPrice = Math.Round(yAvgBuyPrice / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgMemberNum = Math.Round(yMemberNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgPaymentNum = Math.Round(yPaymentNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgMOrderRate = Math.Round(yMOrderRate / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgReBuyNum = Math.Round(yReBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgReBuyRate = Math.Round(yReBuyRate / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgNewPeopleNum = Math.Round(yNewPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgProfitRate = Math.Round(yProfitRate / 3, 2, MidpointRounding.AwayFromZero);
                #endregion
                #endregion

                MonthSList.Add(mmodel);
                if (SMonth == endTime)
                {
                    break;
                }
                SMonth = Convert.ToDateTime(SMonth + "-01").AddMonths(1).ToString("yyyy-MM");
            }
            if (MonthSList.Any())
            {
                string ContrastMonth = Convert.ToDateTime(StartDate).ToString("yyyy-MM");
                var MonthSList2 = MonthSList.Where(x => x.Date != ContrastMonth).ToList();
                TotalMonthNum--;
                //计算平均/总计    平均需排除掉对比月数据
                User_Statistics_Query MTotalModel = new User_Statistics_Query()
                {
                    Date = "平均/总计",
                    PeopleNum = MonthSList2.Sum(x => x.PeopleNum),
                    OrderNum = MonthSList2.Sum(x => x.OrderNum),
                    PayMoney = MonthSList2.Sum(x => x.PayMoney),
                    BuyNum = MonthSList2.Sum(x => x.BuyNum),
                    Profit = MonthSList2.Sum(x => x.Profit),
                    TotalPayPeople = MonthSList2.Any() ? MonthSList2.Max(x => x.TotalPayPeople) : 0,
                    PXNum = MonthSList2.Sum(x => x.PXNum),
                    VipNum = MonthSList2.Sum(x => x.VipNum),
                    YXNum = MonthSList2.Sum(x => x.YXNum),
                    JXNum = MonthSList2.Sum(x => x.JXNum),
                    TotalMNum = MonthSList2.Sum(x => x.TotalMNum),

                    MAvgPeopleNum = Math.Round(MonthSList2.Sum(x => x.MAvgPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    MAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.MAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    MAvgPayMoney = Math.Round(MonthSList2.Sum(x => x.MAvgPayMoney) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    MAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.MAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.PAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgUnitPrice = Math.Round(MonthSList2.Sum(x => x.PAvgUnitPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgBuyPrice = Math.Round(MonthSList2.Sum(x => x.PAvgBuyPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgMemberNum = Math.Round(MonthSList2.Sum(x => x.PAvgMemberNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgPaymentNum = Math.Round(MonthSList2.Sum(x => x.PAvgPaymentNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgMOrderRate = Math.Round(MonthSList2.Sum(x => x.PAvgMOrderRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgReBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgReBuyRate = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgNewPeopleNum = Math.Round(MonthSList2.Sum(x => x.PAvgNewPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgProfitRate = Math.Round(MonthSList2.Sum(x => x.PAvgProfitRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero)
                };
                MonthSList.Add(MTotalModel);
            }
            #region 计算比率
            List<User_Statistics_Rate_Query> ReRateList = new List<User_Statistics_Rate_Query>();//概率数据
            string SRateMonth = startTime;
            //这个要从查询第一个月开始
            while (true)
            {
                //求当月的所有比例    (当月-上月)/上月
                var NowMmodel = MonthSList.Where(x => x.Date == SRateMonth).FirstOrDefault();
                var PreMmodel = MonthSList.Where(x => x.Date == Convert.ToDateTime(SRateMonth + "-01").AddMonths(-1).ToString("yyyy-MM")).FirstOrDefault();

                User_Statistics_Rate_Query smodel = new User_Statistics_Rate_Query() { Date = SRateMonth };
                smodel.MAvgPeopleNum = NowMmodel.MAvgPeopleNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgPeopleNum > 0 ? (NowMmodel.MAvgPeopleNum - PreMmodel.MAvgPeopleNum) / PreMmodel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.MAvgOrderNum = NowMmodel.MAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgOrderNum > 0 ? (NowMmodel.MAvgOrderNum - PreMmodel.MAvgOrderNum) / PreMmodel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.MAvgPayMoney = NowMmodel.MAvgPayMoney <= 0 ? 0 : Math.Round(PreMmodel.MAvgPayMoney > 0 ? (NowMmodel.MAvgPayMoney - PreMmodel.MAvgPayMoney) / PreMmodel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.MAvgBuyNum = NowMmodel.MAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgBuyNum > 0 ? (NowMmodel.MAvgBuyNum - PreMmodel.MAvgBuyNum) / PreMmodel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgOrderNum = NowMmodel.PAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgOrderNum > 0 ? (NowMmodel.PAvgOrderNum - PreMmodel.PAvgOrderNum) / PreMmodel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgBuyNum = NowMmodel.PAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyNum > 0 ? (NowMmodel.PAvgBuyNum - PreMmodel.PAvgBuyNum) / PreMmodel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgUnitPrice = NowMmodel.PAvgUnitPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgUnitPrice > 0 ? (NowMmodel.PAvgUnitPrice - PreMmodel.PAvgUnitPrice) / PreMmodel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgBuyPrice = NowMmodel.PAvgBuyPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyPrice > 0 ? (NowMmodel.PAvgBuyPrice - PreMmodel.PAvgBuyPrice) / PreMmodel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgMOrderRate = NowMmodel.PAvgMOrderRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgMOrderRate > 0 ? (NowMmodel.PAvgMOrderRate - PreMmodel.PAvgMOrderRate) / PreMmodel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgProfitRate = NowMmodel.PAvgProfitRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgProfitRate > 0 ? (NowMmodel.PAvgProfitRate - PreMmodel.PAvgProfitRate) / PreMmodel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgProfit = NowMmodel.Profit <= 0 ? 0 : Math.Round(PreMmodel.Profit > 0 ? (NowMmodel.Profit - PreMmodel.Profit) / PreMmodel.Profit : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgPXNum = NowMmodel.PXNum <= 0 ? 0 : Math.Round(PreMmodel.PXNum > 0 ? Convert.ToDecimal(NowMmodel.PXNum - PreMmodel.PXNum) / PreMmodel.PXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgVipNum = NowMmodel.VipNum <= 0 ? 0 : Math.Round(PreMmodel.VipNum > 0 ? Convert.ToDecimal(NowMmodel.VipNum - PreMmodel.VipNum) / PreMmodel.VipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgYXNum = NowMmodel.YXNum <= 0 ? 0 : Math.Round(PreMmodel.YXNum > 0 ? Convert.ToDecimal(NowMmodel.YXNum - PreMmodel.YXNum) / PreMmodel.YXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgJXNum = NowMmodel.JXNum <= 0 ? 0 : Math.Round(PreMmodel.JXNum > 0 ? Convert.ToDecimal(NowMmodel.JXNum - PreMmodel.JXNum) / PreMmodel.JXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgTotalMNum = NowMmodel.TotalMNum <= 0 ? 0 : Math.Round(PreMmodel.TotalMNum > 0 ? Convert.ToDecimal(NowMmodel.TotalMNum - PreMmodel.TotalMNum) / PreMmodel.TotalMNum : 1, 4, MidpointRounding.AwayFromZero) * 100;

                ReRateList.Add(smodel);
                if (SRateMonth == endTime)
                {
                    break;
                }
                SRateMonth = Convert.ToDateTime(SRateMonth + "-01").AddMonths(1).ToString("yyyy-MM");
            }
            if (ReRateList.Any())
            {
                TotalMonthNum++;
                User_Statistics_Rate_Query savgmodel = new User_Statistics_Rate_Query() { Date = "平均" };
                savgmodel.MAvgPeopleNum = Math.Round(ReRateList.Sum(x => x.MAvgPeopleNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.MAvgOrderNum = Math.Round(ReRateList.Sum(x => x.MAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.MAvgPayMoney = Math.Round(ReRateList.Sum(x => x.MAvgPayMoney) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.MAvgBuyNum = Math.Round(ReRateList.Sum(x => x.MAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgOrderNum = Math.Round(ReRateList.Sum(x => x.PAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgBuyNum = Math.Round(ReRateList.Sum(x => x.PAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgUnitPrice = Math.Round(ReRateList.Sum(x => x.PAvgUnitPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgBuyPrice = Math.Round(ReRateList.Sum(x => x.PAvgBuyPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgMOrderRate = Math.Round(ReRateList.Sum(x => x.PAvgMOrderRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgProfitRate = Math.Round(ReRateList.Sum(x => x.PAvgProfitRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgProfit = Math.Round(ReRateList.Sum(x => x.PAvgProfit) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgPXNum = Math.Round(ReRateList.Sum(x => x.PAvgPXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgVipNum = Math.Round(ReRateList.Sum(x => x.PAvgVipNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgYXNum = Math.Round(ReRateList.Sum(x => x.PAvgYXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgJXNum = Math.Round(ReRateList.Sum(x => x.PAvgJXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgTotalMNum = Math.Round(ReRateList.Sum(x => x.PAvgTotalMNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                ReRateList.Add(savgmodel);
            }
            #endregion

            return new
            {
                DataList = MonthSList,
                RateList = ReRateList.Select(x => new
                {
                    x.Date,
                    x.MAvgPeopleNum,
                    x.MAvgOrderNum,
                    x.MAvgPayMoney,
                    x.MAvgBuyNum,
                    x.PAvgOrderNum,
                    x.PAvgBuyNum,
                    x.PAvgUnitPrice,
                    x.PAvgBuyPrice,
                    x.PAvgMOrderRate,
                    x.PAvgProfitRate,
                    x.PAvgProfit,
                    x.PAvgPXNum,
                    x.PAvgVipNum,
                    x.PAvgYXNum,
                    x.PAvgJXNum,
                    x.PAvgTotalMNum
                })
            };
        }

        /// <summary>
        /// 每月统计excel导出
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<ExcelDataSource> GetDSMoreMonthStatisticsToExcel(string startTime, string endTime, int tenantId, int mallBaseId)
        {
            string StartDate = Convert.ToDateTime(startTime + "-01").AddMonths(-1).ToString("yyyy-MM-dd");// 默认查询提前一个月  用于做对比
            string EndDate = Convert.ToDateTime(endTime).AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
            var list = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = StartDate, EndTime = EndDate });
            List<User_Statistics_Query> MonthSList = new List<User_Statistics_Query>();//月统计数据
            //根据月份遍历
            string SMonth = Convert.ToDateTime(StartDate).ToString("yyyy-MM");
            int TotalMonthNum = 0;
            while (true)
            {
                TotalMonthNum++;
                User_Statistics_Query mmodel = new User_Statistics_Query() { Date = SMonth };
                //查询当月数据
                var mlist = list.Where(x => x.DateMonth == SMonth).ToList();
                mmodel.PeopleNum = mlist.Sum(x => x.PeopleNum);
                mmodel.OrderNum = mlist.Sum(x => x.OrderNum);
                mmodel.PayMoney = mlist.Sum(x => x.PayMoney);
                mmodel.BuyNum = mlist.Sum(x => x.BuyNum);
                mmodel.TotalPayPeople = mlist.Any() ? mlist.Max(x => x.PaymentNum) : 0;
                mmodel.Profit = mlist.Sum(x => x.Profit);
                //抓取累计数据  暂不使用
                //int TotalPXNum = mlist.Any() ? mlist.Max(x => x.PXLJNum) : 0;
                //int TotalVIPNum = mlist.Any() ? mlist.Max(x => x.VipLJNum) : 0;
                //int TotalYXNum = mlist.Any() ? mlist.Max(x => x.YXLJNum) : 0;
                //int TotalJXNum = mlist.Any() ? mlist.Max(x => x.JXLJNum) : 0;
                mmodel.PXNum = mlist.Sum(x => x.PXNum);
                mmodel.VipNum = mlist.Sum(x => x.VipNum);
                mmodel.YXNum = mlist.Sum(x => x.YXNum);
                mmodel.JXNum = mlist.Sum(x => x.JXNum);
                mmodel.TotalMNum = mmodel.PXNum + mmodel.VipNum + mmodel.YXNum + mmodel.JXNum;

                #region 求月平均
                #region 月平均参数
                decimal yPeopleNum = 0;
                decimal yOrderNum = 0;
                decimal yPayMoney = 0;
                decimal yBuyNum = 0;
                decimal yAvgOrderNum = 0;
                decimal yAvgBuyNum = 0;
                decimal yAvgUnitPrice = 0;
                decimal yAvgBuyPrice = 0;
                decimal yMemberNum = 0;
                decimal yPaymentNum = 0;
                decimal yMOrderRate = 0;
                decimal yReBuyNum = 0;
                decimal yReBuyRate = 0;
                decimal yNewPeopleNum = 0;
                decimal yPXNum = 0;
                decimal yVipNum = 0;
                decimal yYXNum = 0;
                decimal yJXNum = 0;
                decimal yProfit = 0;
                decimal yProfitRate = 0;
                #endregion
                string SDate = SMonth + "-01";
                string EDate = Convert.ToDateTime(SMonth + "-01").AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
                int MaxDay = Convert.ToDateTime(EDate).Day;
                while (true)
                {
                    if (Convert.ToDateTime(SDate).Day == 10)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    else if (Convert.ToDateTime(SDate).Day == 20)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    else if (Convert.ToDateTime(SDate).Day == MaxDay)
                    {
                        int NowDay = MaxDay - 20;
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }

                    if (SDate == EDate)
                    {
                        break;
                    }
                    SDate = Convert.ToDateTime(SDate).AddDays(1).ToString("yyyy-MM-dd");
                }

                #region 月平均赋值
                mmodel.MAvgPeopleNum = Math.Round(yPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.MAvgOrderNum = Math.Round(yOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.MAvgPayMoney = Math.Round(yPayMoney / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.MAvgBuyNum = Math.Round(yBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgOrderNum = Math.Round(yAvgOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgBuyNum = Math.Round(yAvgBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgUnitPrice = Math.Round(yAvgUnitPrice / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgBuyPrice = Math.Round(yAvgBuyPrice / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgMemberNum = Math.Round(yMemberNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgPaymentNum = Math.Round(yPaymentNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgMOrderRate = Math.Round(yMOrderRate / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgReBuyNum = Math.Round(yReBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgReBuyRate = Math.Round(yReBuyRate / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgNewPeopleNum = Math.Round(yNewPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                mmodel.PAvgProfitRate = Math.Round(yProfitRate / 3, 2, MidpointRounding.AwayFromZero);
                #endregion
                #endregion

                MonthSList.Add(mmodel);
                if (SMonth == endTime)
                {
                    break;
                }
                SMonth = Convert.ToDateTime(SMonth + "-01").AddMonths(1).ToString("yyyy-MM");
            }
            if (MonthSList.Any())
            {
                string ContrastMonth = Convert.ToDateTime(StartDate).ToString("yyyy-MM");
                var MonthSList2 = MonthSList.Where(x => x.Date != ContrastMonth).ToList();
                TotalMonthNum--;
                //计算平均/总计    平均需排除掉对比月数据
                User_Statistics_Query MTotalModel = new User_Statistics_Query()
                {
                    Date = "平均/总计",
                    PeopleNum = MonthSList2.Sum(x => x.PeopleNum),
                    OrderNum = MonthSList2.Sum(x => x.OrderNum),
                    PayMoney = MonthSList2.Sum(x => x.PayMoney),
                    BuyNum = MonthSList2.Sum(x => x.BuyNum),
                    Profit = MonthSList2.Sum(x => x.Profit),
                    TotalPayPeople = MonthSList2.Any() ? MonthSList2.Max(x => x.TotalPayPeople) : 0,
                    PXNum = MonthSList2.Sum(x => x.PXNum),
                    VipNum = MonthSList2.Sum(x => x.VipNum),
                    YXNum = MonthSList2.Sum(x => x.YXNum),
                    JXNum = MonthSList2.Sum(x => x.JXNum),
                    TotalMNum = MonthSList2.Sum(x => x.TotalMNum),

                    MAvgPeopleNum = Math.Round(MonthSList2.Sum(x => x.MAvgPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    MAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.MAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    MAvgPayMoney = Math.Round(MonthSList2.Sum(x => x.MAvgPayMoney) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    MAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.MAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.PAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgUnitPrice = Math.Round(MonthSList2.Sum(x => x.PAvgUnitPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgBuyPrice = Math.Round(MonthSList2.Sum(x => x.PAvgBuyPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgMemberNum = Math.Round(MonthSList2.Sum(x => x.PAvgMemberNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgPaymentNum = Math.Round(MonthSList2.Sum(x => x.PAvgPaymentNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgMOrderRate = Math.Round(MonthSList2.Sum(x => x.PAvgMOrderRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgReBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgReBuyRate = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgNewPeopleNum = Math.Round(MonthSList2.Sum(x => x.PAvgNewPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                    PAvgProfitRate = Math.Round(MonthSList2.Sum(x => x.PAvgProfitRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero)
                };
                MonthSList.Add(MTotalModel);
            }
            #region 计算比率
            List<User_Statistics_Rate_Query> ReRateList = new List<User_Statistics_Rate_Query>();//概率数据
            string SRateMonth = startTime;
            //这个要从下一个月开始
            while (true)
            {
                //求当月的所有比例    (当月-上月)/上月
                var NowMmodel = MonthSList.Where(x => x.Date == SRateMonth).FirstOrDefault();
                var PreMmodel = MonthSList.Where(x => x.Date == Convert.ToDateTime(SRateMonth + "-01").AddMonths(-1).ToString("yyyy-MM")).FirstOrDefault();

                User_Statistics_Rate_Query smodel = new User_Statistics_Rate_Query() { Date = SRateMonth };
                smodel.MAvgPeopleNum = NowMmodel.MAvgPeopleNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgPeopleNum > 0 ? (NowMmodel.MAvgPeopleNum - PreMmodel.MAvgPeopleNum) / PreMmodel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.MAvgOrderNum = NowMmodel.MAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgOrderNum > 0 ? (NowMmodel.MAvgOrderNum - PreMmodel.MAvgOrderNum) / PreMmodel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.MAvgPayMoney = NowMmodel.MAvgPayMoney <= 0 ? 0 : Math.Round(PreMmodel.MAvgPayMoney > 0 ? (NowMmodel.MAvgPayMoney - PreMmodel.MAvgPayMoney) / PreMmodel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.MAvgBuyNum = NowMmodel.MAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgBuyNum > 0 ? (NowMmodel.MAvgBuyNum - PreMmodel.MAvgBuyNum) / PreMmodel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgOrderNum = NowMmodel.PAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgOrderNum > 0 ? (NowMmodel.PAvgOrderNum - PreMmodel.PAvgOrderNum) / PreMmodel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgBuyNum = NowMmodel.PAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyNum > 0 ? (NowMmodel.PAvgBuyNum - PreMmodel.PAvgBuyNum) / PreMmodel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgUnitPrice = NowMmodel.PAvgUnitPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgUnitPrice > 0 ? (NowMmodel.PAvgUnitPrice - PreMmodel.PAvgUnitPrice) / PreMmodel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgBuyPrice = NowMmodel.PAvgBuyPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyPrice > 0 ? (NowMmodel.PAvgBuyPrice - PreMmodel.PAvgBuyPrice) / PreMmodel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgMOrderRate = NowMmodel.PAvgMOrderRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgMOrderRate > 0 ? (NowMmodel.PAvgMOrderRate - PreMmodel.PAvgMOrderRate) / PreMmodel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgProfitRate = NowMmodel.PAvgProfitRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgProfitRate > 0 ? (NowMmodel.PAvgProfitRate - PreMmodel.PAvgProfitRate) / PreMmodel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgProfit = NowMmodel.Profit <= 0 ? 0 : Math.Round(PreMmodel.Profit > 0 ? (NowMmodel.Profit - PreMmodel.Profit) / PreMmodel.Profit : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgPXNum = NowMmodel.PXNum <= 0 ? 0 : Math.Round(PreMmodel.PXNum > 0 ? Convert.ToDecimal(NowMmodel.PXNum - PreMmodel.PXNum) / PreMmodel.PXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgVipNum = NowMmodel.VipNum <= 0 ? 0 : Math.Round(PreMmodel.VipNum > 0 ? Convert.ToDecimal(NowMmodel.VipNum - PreMmodel.VipNum) / PreMmodel.VipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgYXNum = NowMmodel.YXNum <= 0 ? 0 : Math.Round(PreMmodel.YXNum > 0 ? Convert.ToDecimal(NowMmodel.YXNum - PreMmodel.YXNum) / PreMmodel.YXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgJXNum = NowMmodel.JXNum <= 0 ? 0 : Math.Round(PreMmodel.JXNum > 0 ? Convert.ToDecimal(NowMmodel.JXNum - PreMmodel.JXNum) / PreMmodel.JXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                smodel.PAvgTotalMNum = NowMmodel.TotalMNum <= 0 ? 0 : Math.Round(PreMmodel.TotalMNum > 0 ? Convert.ToDecimal(NowMmodel.TotalMNum - PreMmodel.TotalMNum) / PreMmodel.TotalMNum : 1, 4, MidpointRounding.AwayFromZero) * 100;

                ReRateList.Add(smodel);
                if (SRateMonth == endTime)
                {
                    break;
                }
                SRateMonth = Convert.ToDateTime(SRateMonth + "-01").AddMonths(1).ToString("yyyy-MM");
            }
            if (ReRateList.Any())
            {
                TotalMonthNum++;
                User_Statistics_Rate_Query savgmodel = new User_Statistics_Rate_Query() { Date = "平均" };
                savgmodel.MAvgPeopleNum = Math.Round(ReRateList.Sum(x => x.MAvgPeopleNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.MAvgOrderNum = Math.Round(ReRateList.Sum(x => x.MAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.MAvgPayMoney = Math.Round(ReRateList.Sum(x => x.MAvgPayMoney) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.MAvgBuyNum = Math.Round(ReRateList.Sum(x => x.MAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgOrderNum = Math.Round(ReRateList.Sum(x => x.PAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgBuyNum = Math.Round(ReRateList.Sum(x => x.PAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgUnitPrice = Math.Round(ReRateList.Sum(x => x.PAvgUnitPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgBuyPrice = Math.Round(ReRateList.Sum(x => x.PAvgBuyPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgMOrderRate = Math.Round(ReRateList.Sum(x => x.PAvgMOrderRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgProfitRate = Math.Round(ReRateList.Sum(x => x.PAvgProfitRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgProfit = Math.Round(ReRateList.Sum(x => x.PAvgProfit) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgPXNum = Math.Round(ReRateList.Sum(x => x.PAvgPXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgVipNum = Math.Round(ReRateList.Sum(x => x.PAvgVipNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgYXNum = Math.Round(ReRateList.Sum(x => x.PAvgYXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgJXNum = Math.Round(ReRateList.Sum(x => x.PAvgJXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                savgmodel.PAvgTotalMNum = Math.Round(ReRateList.Sum(x => x.PAvgTotalMNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                ReRateList.Add(savgmodel);
            }
            #endregion

            #region 组装excel数据
            List<ExcelDataSource> DataList = new List<ExcelDataSource>();
            //第一部分数据
            foreach (var item in MonthSList)
            {
                ExcelDataSource datarow = new ExcelDataSource()
                {
                    ExcelRows = new List<ExcelColumn>(23) {
                        new ExcelColumn(value: item.Date == "平均/总计" ? "平均" : item.Date){ },
                        new ExcelColumn(value: item.MAvgPeopleNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.MAvgOrderNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.MAvgPayMoney.ToString("#0.00")){ },
                        new ExcelColumn(value: item.MAvgBuyNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgOrderNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgBuyNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgUnitPrice.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgBuyPrice.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgMemberNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgPaymentNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgMOrderRate.ToString("#0.00")+"%"){ },
                        new ExcelColumn(value: item.PAvgReBuyNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgReBuyRate.ToString("#0.00")+"%"){ },
                        new ExcelColumn(value: item.PAvgNewPeopleNum.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PAvgProfitRate.ToString("#0.00")+"%"){ },
                    },
                    ColumnHight = 30
                };
                DataList.Add(datarow);
            }

            //增加行空白
            DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 16 } } });
            #region 增加统计标题
            ExcelDataSource header2 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value: "月小計") { },
                    new ExcelColumn(value: "付款人數累計") { },
                    new ExcelColumn(value: "付款單數累計") { },
                    new ExcelColumn(value: "付款金額累計") { },
                    new ExcelColumn(value: "購買件數累計") { },
                    new ExcelColumn(value: "付款人數") { },
                    new ExcelColumn(value: "毛利") { },
                    new ExcelColumn(value: "普象") { },
                    new ExcelColumn(value: "VIP") { },
                    new ExcelColumn(value: "銀象") { },
                    new ExcelColumn(value: "金象") { },
                    new ExcelColumn(value: "會員總數") { }
                },
                ColumnHight = 30
            };
            DataList.Add(header2);
            #endregion

            //第二部分数据
            foreach (var item in MonthSList)
            {
                ExcelDataSource datarow = new ExcelDataSource()
                {
                    ExcelRows = new List<ExcelColumn>(23) {
                        new ExcelColumn(value: item.Date == "平均/总计" ? "總計" : item.Date){ },
                        new ExcelColumn(value: item.PeopleNum.ToString()){ },
                        new ExcelColumn(value: item.OrderNum.ToString()){ },
                        new ExcelColumn(value: item.PayMoney.ToString("#0.00")){ },
                        new ExcelColumn(value: item.BuyNum.ToString()){ },
                        new ExcelColumn(value: item.TotalPayPeople.ToString()){ },
                        new ExcelColumn(value: item.Profit.ToString("#0.00")){ },
                        new ExcelColumn(value: item.PXNum.ToString()){ },
                        new ExcelColumn(value: item.VipNum.ToString()){ },
                        new ExcelColumn(value: item.YXNum.ToString()){ },
                        new ExcelColumn(value: item.JXNum.ToString()){ },
                        new ExcelColumn(value: item.TotalMNum.ToString()){ }
                    },
                    ColumnHight = 30
                };
                DataList.Add(datarow);
            }

            //增加行空白
            DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 16 } } });
            //增加行空白
            DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { new ExcelColumn(value: "") { Colspan = 16 } } });

            #region 第三部分
            //先组装标题
            ExcelDataSource header3 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(23) {
                    new ExcelColumn(value: "") { },
                },
                ColumnHight = 30
            };
            foreach (var item in ReRateList)
            {
                header3.ExcelRows.Add(new ExcelColumn(value: item.Date) { });
            }
            DataList.Add(header3);

            //组装数据
            List<string> RateRowList = new List<string>() {
                "MAvgPeopleNum|平均付款人數成長率",
                "MAvgOrderNum|平均付款單數成長率",
                "MAvgPayMoney|平均付款金額成長率",
                "MAvgBuyNum|平均付款件數成長率",
                "PAvgOrderNum|平均每人購買單數成長率",
                "PAvgBuyNum|平均每人購買件數成長率",
                "PAvgUnitPrice|平均每單單價成長率",
                "PAvgBuyPrice|平均每人購買單價成長率",
                "PAvgProfitRate|毛利率成長率",
                "PAvgProfit|毛利成長率",
                "PAvgMOrderRate|會員下訂單成長率",
                "PAvgPXNum|普象會員成長率",
                "PAvgVipNum|VIP會員成長率",
                "PAvgYXNum|銀象會員成長率",
                "PAvgJXNum|金象會員成長率",
                "PAvgTotalMNum|會員總成長率"
            };
            foreach (var item in RateRowList)
            {
                var fileNameArr = item.Split('|');
                ExcelDataSource datarow2 = new ExcelDataSource()
                {
                    ExcelRows = new List<ExcelColumn>(23) {
                        new ExcelColumn(value: fileNameArr[1]) { },
                    },
                    ColumnHight = 30
                };

                foreach (var qitem in ReRateList)
                {
                    JObject parms = JObject.Parse(JsonHelper.Serialize(qitem));
                    string mvalue = parms.GetStringValue(fileNameArr[0]);
                    datarow2.ExcelRows.Add(new ExcelColumn(value: mvalue + "%") { });
                }
                DataList.Add(datarow2);
            }
            #endregion

            #endregion

            return DataList;
        }

        /// <summary>
        /// 获取年度统计
        /// </summary>
        /// <param name="startYear"></param>
        /// <param name="endYear"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetDSYearStartistics(int startYear, int endYear, int tenantId, int mallBaseId)
        {
            string StartDate = Convert.ToDateTime(startYear + "-01-01").AddMonths(-1).ToString("yyyy-MM-dd");//查询提前一个月数据  用于成长率对比
            string EndDate = Convert.ToDateTime(endYear + "-01-01").AddYears(1).AddDays(-1).ToString("yyyy-MM-dd");
            var list = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = StartDate, EndTime = EndDate });
            List<User_Statistics_Query_V2> YearSList = new List<User_Statistics_Query_V2>();//月统计数据
            List<User_Statistics_Query> YearAvgSList = new List<User_Statistics_Query>();//年平均统计数据
            List<User_Statistics_Rate_Query> YearRateSList = new List<User_Statistics_Rate_Query>();//年成长率统计数据
            int SYear = startYear;
            while (true)
            {
                var ylist = list.Where(x => x.DateYear == SYear).ToList();
                #region 1表统计
                User_Statistics_Query_V2 ymodel = new User_Statistics_Query_V2() { Date = SYear.ToString() };
                ymodel.PeopleNum = ylist.Sum(x => x.PeopleNum);
                ymodel.OrderNum = ylist.Sum(x => x.OrderNum);
                ymodel.PayMoney = ylist.Sum(x => x.PayMoney);
                ymodel.BuyNum = ylist.Sum(x => x.BuyNum);
                ymodel.TotalPayPeople = ylist.Any() ? ylist.Max(x => x.MemberNum) : 0;
                ymodel.MAvgPeopleNum = ylist.Any() ? ylist.Max(x => x.PaymentNum) : 0;
                ymodel.Profit = ylist.Sum(x => x.Profit);
                ymodel.PXNum = ylist.Sum(x => x.PXNum);
                ymodel.VipNum = ylist.Sum(x => x.VipNum);
                ymodel.YXNum = ylist.Sum(x => x.YXNum);
                ymodel.JXNum = ylist.Sum(x => x.JXNum);
                ymodel.TotalMNum = ymodel.PXNum + ymodel.VipNum + ymodel.YXNum + ymodel.JXNum;
                YearSList.Add(ymodel);
                #endregion

                #region 2表平均统计
                List<User_Statistics_Query> MonthSList = new List<User_Statistics_Query>();//月统计数据
                string SMonth = Convert.ToDateTime(SYear + "-01-01").AddMonths(-1).ToString("yyyy-MM");//第一个月
                string endTime = Convert.ToDateTime(SYear + "-01-01").AddYears(1).AddDays(-1).ToString("yyyy-MM");//最后一个月
                int TotalMonthNum = 0;
                while (true)
                {
                    TotalMonthNum++;
                    User_Statistics_Query mmodel = new User_Statistics_Query() { Date = SMonth };
                    //查询当月数据
                    var mlist = list.Where(x => x.DateMonth == SMonth).ToList();
                    mmodel.PeopleNum = mlist.Sum(x => x.PeopleNum);
                    mmodel.OrderNum = mlist.Sum(x => x.OrderNum);
                    mmodel.PayMoney = mlist.Sum(x => x.PayMoney);
                    mmodel.BuyNum = mlist.Sum(x => x.BuyNum);
                    mmodel.TotalPayPeople = mlist.Any() ? mlist.Max(x => x.PaymentNum) : 0;
                    mmodel.Profit = mlist.Sum(x => x.Profit);
                    //int TotalPXNum = mlist.Any() ? mlist.Max(x => x.PXLJNum) : 0;
                    //int TotalVIPNum = mlist.Any() ? mlist.Max(x => x.VipLJNum) : 0;
                    //int TotalYXNum = mlist.Any() ? mlist.Max(x => x.YXLJNum) : 0;
                    //int TotalJXNum = mlist.Any() ? mlist.Max(x => x.JXLJNum) : 0;
                    mmodel.PXNum = mlist.Sum(x => x.PXNum);
                    mmodel.VipNum = mlist.Sum(x => x.VipNum);
                    mmodel.YXNum = mlist.Sum(x => x.YXNum);
                    mmodel.JXNum = mlist.Sum(x => x.JXNum);
                    mmodel.TotalMNum = mmodel.PXNum + mmodel.VipNum + mmodel.YXNum + mmodel.JXNum;

                    #region 求月平均
                    #region 月平均参数
                    decimal yPeopleNum = 0;
                    decimal yOrderNum = 0;
                    decimal yPayMoney = 0;
                    decimal yBuyNum = 0;
                    decimal yAvgOrderNum = 0;
                    decimal yAvgBuyNum = 0;
                    decimal yAvgUnitPrice = 0;
                    decimal yAvgBuyPrice = 0;
                    decimal yMemberNum = 0;
                    decimal yPaymentNum = 0;
                    decimal yMOrderRate = 0;
                    decimal yReBuyNum = 0;
                    decimal yReBuyRate = 0;
                    decimal yNewPeopleNum = 0;
                    decimal yPXNum = 0;
                    decimal yVipNum = 0;
                    decimal yYXNum = 0;
                    decimal yJXNum = 0;
                    decimal yProfit = 0;
                    decimal yProfitRate = 0;
                    #endregion
                    string SDate = SMonth + "-01";
                    string EDate = Convert.ToDateTime(SMonth + "-01").AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
                    int MaxDay = Convert.ToDateTime(EDate).Day;

                    //分三段求 每期的平均
                    if (true)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    if (true)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    if (true)
                    {
                        int NowDay = MaxDay - 20;
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }


                    #region 月平均赋值
                    mmodel.MAvgPeopleNum = Math.Round(yPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.MAvgOrderNum = Math.Round(yOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.MAvgPayMoney = Math.Round(yPayMoney / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.MAvgBuyNum = Math.Round(yBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgOrderNum = Math.Round(yAvgOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgBuyNum = Math.Round(yAvgBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgUnitPrice = Math.Round(yAvgUnitPrice / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgBuyPrice = Math.Round(yAvgBuyPrice / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgMemberNum = Math.Round(yMemberNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgPaymentNum = Math.Round(yPaymentNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgMOrderRate = Math.Round(yMOrderRate / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgReBuyNum = Math.Round(yReBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgReBuyRate = Math.Round(yReBuyRate / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgNewPeopleNum = Math.Round(yNewPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgProfitRate = Math.Round(yProfitRate / 3, 2, MidpointRounding.AwayFromZero);
                    #endregion
                    #endregion

                    MonthSList.Add(mmodel);
                    if (SMonth == endTime)
                    {
                        break;
                    }
                    SMonth = Convert.ToDateTime(SMonth + "-01").AddMonths(1).ToString("yyyy-MM");
                }
                if (MonthSList.Any())
                {
                    string ContrastMonth = Convert.ToDateTime(SYear + "-01-01").AddMonths(-1).ToString("yyyy-MM");
                    var MonthSList2 = MonthSList.Where(x => x.Date != ContrastMonth).ToList();
                    TotalMonthNum--;
                    //计算平均/总计    平均需排除掉对比月数据
                    User_Statistics_Query MTotalModel = new User_Statistics_Query()
                    {
                        Date = SYear.ToString(),
                        MAvgPeopleNum = Math.Round(MonthSList2.Sum(x => x.MAvgPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        MAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.MAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        MAvgPayMoney = Math.Round(MonthSList2.Sum(x => x.MAvgPayMoney) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        MAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.MAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.PAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgUnitPrice = Math.Round(MonthSList2.Sum(x => x.PAvgUnitPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgBuyPrice = Math.Round(MonthSList2.Sum(x => x.PAvgBuyPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgMemberNum = Math.Round(MonthSList2.Sum(x => x.PAvgMemberNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgPaymentNum = Math.Round(MonthSList2.Sum(x => x.PAvgPaymentNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgMOrderRate = Math.Round(MonthSList2.Sum(x => x.PAvgMOrderRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgReBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgReBuyRate = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgNewPeopleNum = Math.Round(MonthSList2.Sum(x => x.PAvgNewPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgProfitRate = Math.Round(MonthSList2.Sum(x => x.PAvgProfitRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero)
                    };
                    YearAvgSList.Add(MTotalModel);
                }
                #endregion

                #region 3表成长率统计
                List<User_Statistics_Rate_Query> ReRateList = new List<User_Statistics_Rate_Query>();//概率数据
                string SRateMonth = SYear + "-01";
                //这个要从查询第一个月开始
                while (true)
                {
                    //求当月的所有比例    (当月-上月)/上月
                    var NowMmodel = MonthSList.Where(x => x.Date == SRateMonth).FirstOrDefault();
                    var PreMmodel = MonthSList.Where(x => x.Date == Convert.ToDateTime(SRateMonth + "-01").AddMonths(-1).ToString("yyyy-MM")).FirstOrDefault();

                    User_Statistics_Rate_Query smodel = new User_Statistics_Rate_Query() { Date = SRateMonth };
                    smodel.MAvgPeopleNum = NowMmodel.MAvgPeopleNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgPeopleNum > 0 ? (NowMmodel.MAvgPeopleNum - PreMmodel.MAvgPeopleNum) / PreMmodel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.MAvgOrderNum = NowMmodel.MAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgOrderNum > 0 ? (NowMmodel.MAvgOrderNum - PreMmodel.MAvgOrderNum) / PreMmodel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.MAvgPayMoney = NowMmodel.MAvgPayMoney <= 0 ? 0 : Math.Round(PreMmodel.MAvgPayMoney > 0 ? (NowMmodel.MAvgPayMoney - PreMmodel.MAvgPayMoney) / PreMmodel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.MAvgBuyNum = NowMmodel.MAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgBuyNum > 0 ? (NowMmodel.MAvgBuyNum - PreMmodel.MAvgBuyNum) / PreMmodel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgOrderNum = NowMmodel.PAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgOrderNum > 0 ? (NowMmodel.PAvgOrderNum - PreMmodel.PAvgOrderNum) / PreMmodel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgBuyNum = NowMmodel.PAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyNum > 0 ? (NowMmodel.PAvgBuyNum - PreMmodel.PAvgBuyNum) / PreMmodel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgUnitPrice = NowMmodel.PAvgUnitPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgUnitPrice > 0 ? (NowMmodel.PAvgUnitPrice - PreMmodel.PAvgUnitPrice) / PreMmodel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgBuyPrice = NowMmodel.PAvgBuyPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyPrice > 0 ? (NowMmodel.PAvgBuyPrice - PreMmodel.PAvgBuyPrice) / PreMmodel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgMOrderRate = NowMmodel.PAvgMOrderRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgMOrderRate > 0 ? (NowMmodel.PAvgMOrderRate - PreMmodel.PAvgMOrderRate) / PreMmodel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgProfitRate = NowMmodel.PAvgProfitRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgProfitRate > 0 ? (NowMmodel.PAvgProfitRate - PreMmodel.PAvgProfitRate) / PreMmodel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgProfit = NowMmodel.Profit <= 0 ? 0 : Math.Round(PreMmodel.Profit > 0 ? (NowMmodel.Profit - PreMmodel.Profit) / PreMmodel.Profit : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgPXNum = NowMmodel.PXNum <= 0 ? 0 : Math.Round(PreMmodel.PXNum > 0 ? Convert.ToDecimal(NowMmodel.PXNum - PreMmodel.PXNum) / PreMmodel.PXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgVipNum = NowMmodel.VipNum <= 0 ? 0 : Math.Round(PreMmodel.VipNum > 0 ? Convert.ToDecimal(NowMmodel.VipNum - PreMmodel.VipNum) / PreMmodel.VipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgYXNum = NowMmodel.YXNum <= 0 ? 0 : Math.Round(PreMmodel.YXNum > 0 ? Convert.ToDecimal(NowMmodel.YXNum - PreMmodel.YXNum) / PreMmodel.YXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgJXNum = NowMmodel.JXNum <= 0 ? 0 : Math.Round(PreMmodel.JXNum > 0 ? Convert.ToDecimal(NowMmodel.JXNum - PreMmodel.JXNum) / PreMmodel.JXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgTotalMNum = NowMmodel.TotalMNum <= 0 ? 0 : Math.Round(PreMmodel.TotalMNum > 0 ? Convert.ToDecimal(NowMmodel.TotalMNum - PreMmodel.TotalMNum) / PreMmodel.TotalMNum : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    ReRateList.Add(smodel);
                    if (SRateMonth == endTime)
                    {
                        break;
                    }
                    SRateMonth = Convert.ToDateTime(SRateMonth + "-01").AddMonths(1).ToString("yyyy-MM");
                }
                if (ReRateList.Any())
                {
                    TotalMonthNum++;
                    User_Statistics_Rate_Query savgmodel = new User_Statistics_Rate_Query() { Date = SYear.ToString() };
                    savgmodel.MAvgPeopleNum = Math.Round(ReRateList.Sum(x => x.MAvgPeopleNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.MAvgOrderNum = Math.Round(ReRateList.Sum(x => x.MAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.MAvgPayMoney = Math.Round(ReRateList.Sum(x => x.MAvgPayMoney) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.MAvgBuyNum = Math.Round(ReRateList.Sum(x => x.MAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgOrderNum = Math.Round(ReRateList.Sum(x => x.PAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgBuyNum = Math.Round(ReRateList.Sum(x => x.PAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgUnitPrice = Math.Round(ReRateList.Sum(x => x.PAvgUnitPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgBuyPrice = Math.Round(ReRateList.Sum(x => x.PAvgBuyPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgMOrderRate = Math.Round(ReRateList.Sum(x => x.PAvgMOrderRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgProfitRate = Math.Round(ReRateList.Sum(x => x.PAvgProfitRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgProfit = Math.Round(ReRateList.Sum(x => x.PAvgProfit) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgPXNum = Math.Round(ReRateList.Sum(x => x.PAvgPXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgVipNum = Math.Round(ReRateList.Sum(x => x.PAvgVipNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgYXNum = Math.Round(ReRateList.Sum(x => x.PAvgYXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgJXNum = Math.Round(ReRateList.Sum(x => x.PAvgJXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgTotalMNum = Math.Round(ReRateList.Sum(x => x.PAvgTotalMNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    YearRateSList.Add(savgmodel);
                }
                #endregion

                if (SYear == endYear)
                {
                    break;
                }
                SYear = Convert.ToDateTime(SYear + "-01-01").AddYears(1).Year;
            }

            #region 拿到所有年数据  成长率值
            List<User_Statistics_Query_V2> YearSCList = new List<User_Statistics_Query_V2>();//月统计数据   成长率
            List<User_Statistics_Query> YearAvgSCList = new List<User_Statistics_Query>();//年平均统计数据   成长率
            List<User_Statistics_Rate_Query> YearRateSCList = new List<User_Statistics_Rate_Query>();//年成长率统计数据  成长率
            #region 第一表
            foreach (var item in YearSList)
            {
                //第一年没有  从第二年开始
                if (item.Date != startYear.ToString())
                {
                    int PreYear = Convert.ToInt32(item.Date) - 1;
                    var PreModel = YearSList.Where(x => x.Date == PreYear.ToString()).FirstOrDefault();
                    User_Statistics_Query_V2 cmodel = new User_Statistics_Query_V2() { Date = item.Date + "成長率" };
                    // 成长率 = (当前年 - 上年） /上年
                    cmodel.PeopleNum = Math.Round(PreModel.PeopleNum > 0 ? Convert.ToDecimal(item.PeopleNum - PreModel.PeopleNum) / PreModel.PeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.OrderNum = Math.Round(PreModel.OrderNum > 0 ? Convert.ToDecimal(item.OrderNum - PreModel.OrderNum) / PreModel.OrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PayMoney = Math.Round(PreModel.PayMoney > 0 ? Convert.ToDecimal(item.PayMoney - PreModel.PayMoney) / PreModel.PayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.BuyNum = Math.Round(PreModel.BuyNum > 0 ? Convert.ToDecimal(item.BuyNum - PreModel.BuyNum) / PreModel.BuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.TotalPayPeople = Math.Round(PreModel.TotalPayPeople > 0 ? Convert.ToDecimal(item.TotalPayPeople - PreModel.TotalPayPeople) / PreModel.TotalPayPeople : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgPeopleNum = Math.Round(PreModel.MAvgPeopleNum > 0 ? Convert.ToDecimal(item.MAvgPeopleNum - PreModel.MAvgPeopleNum) / PreModel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.Profit = Math.Round(PreModel.Profit > 0 ? Convert.ToDecimal(item.Profit - PreModel.Profit) / PreModel.Profit : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PXNum = Math.Round(PreModel.PXNum > 0 ? Convert.ToDecimal(item.PXNum - PreModel.PXNum) / PreModel.PXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.VipNum = Math.Round(PreModel.VipNum > 0 ? Convert.ToDecimal(item.VipNum - PreModel.VipNum) / PreModel.VipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.YXNum = Math.Round(PreModel.YXNum > 0 ? Convert.ToDecimal(item.YXNum - PreModel.YXNum) / PreModel.YXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.JXNum = Math.Round(PreModel.JXNum > 0 ? Convert.ToDecimal(item.JXNum - PreModel.JXNum) / PreModel.JXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    var TotalMNum = item.PXNum + item.VipNum + item.YXNum + item.JXNum;
                    var PreTotalMNum = PreModel.PXNum + PreModel.VipNum + PreModel.YXNum + PreModel.JXNum;
                    cmodel.TotalMNum = Math.Round(PreTotalMNum > 0 ? Convert.ToDecimal(TotalMNum - PreTotalMNum) / PreTotalMNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    YearSCList.Add(cmodel);
                }
            }
            YearSList.AddRange(YearSCList);
            YearSList = YearSList.OrderBy(x => x.Date).ToList();//拍一下序
            #endregion

            #region 第二表
            foreach (var item in YearAvgSList)
            {
                //第一年没有  从第二年开始
                if (item.Date != startYear.ToString())
                {
                    int PreYear = Convert.ToInt32(item.Date) - 1;
                    var PreModel = YearAvgSList.Where(x => x.Date == PreYear.ToString()).FirstOrDefault();
                    User_Statistics_Query cmodel = new User_Statistics_Query() { Date = item.Date + "成長率" };
                    // 成长率 = (当前年 - 上年） /上年
                    cmodel.MAvgPeopleNum = Math.Round(PreModel.MAvgPeopleNum > 0 ? Convert.ToDecimal(item.MAvgPeopleNum - PreModel.MAvgPeopleNum) / PreModel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgOrderNum = Math.Round(PreModel.MAvgOrderNum > 0 ? Convert.ToDecimal(item.MAvgOrderNum - PreModel.MAvgOrderNum) / PreModel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgPayMoney = Math.Round(PreModel.MAvgPayMoney > 0 ? Convert.ToDecimal(item.MAvgPayMoney - PreModel.MAvgPayMoney) / PreModel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgBuyNum = Math.Round(PreModel.MAvgBuyNum > 0 ? Convert.ToDecimal(item.MAvgBuyNum - PreModel.MAvgBuyNum) / PreModel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgOrderNum = Math.Round(PreModel.PAvgOrderNum > 0 ? Convert.ToDecimal(item.PAvgOrderNum - PreModel.PAvgOrderNum) / PreModel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyNum = Math.Round(PreModel.PAvgBuyNum > 0 ? Convert.ToDecimal(item.PAvgBuyNum - PreModel.PAvgBuyNum) / PreModel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyPrice = Math.Round(PreModel.PAvgBuyPrice > 0 ? Convert.ToDecimal(item.PAvgBuyPrice - PreModel.PAvgBuyPrice) / PreModel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgUnitPrice = Math.Round(PreModel.PAvgUnitPrice > 0 ? Convert.ToDecimal(item.PAvgUnitPrice - PreModel.PAvgUnitPrice) / PreModel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgMemberNum = Math.Round(PreModel.PAvgMemberNum > 0 ? Convert.ToDecimal(item.PAvgMemberNum - PreModel.PAvgMemberNum) / PreModel.PAvgMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgPaymentNum = Math.Round(PreModel.PAvgPaymentNum > 0 ? Convert.ToDecimal(item.PAvgPaymentNum - PreModel.PAvgPaymentNum) / PreModel.PAvgPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgMOrderRate = Math.Round(PreModel.PAvgMOrderRate > 0 ? Convert.ToDecimal(item.PAvgMOrderRate - PreModel.PAvgMOrderRate) / PreModel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgReBuyNum = Math.Round(PreModel.PAvgReBuyNum > 0 ? Convert.ToDecimal(item.PAvgReBuyNum - PreModel.PAvgReBuyNum) / PreModel.PAvgReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgReBuyRate = Math.Round(PreModel.PAvgReBuyRate > 0 ? Convert.ToDecimal(item.PAvgReBuyRate - PreModel.PAvgReBuyRate) / PreModel.PAvgReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgNewPeopleNum = Math.Round(PreModel.PAvgNewPeopleNum > 0 ? Convert.ToDecimal(item.PAvgNewPeopleNum - PreModel.PAvgNewPeopleNum) / PreModel.PAvgNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgProfitRate = Math.Round(PreModel.PAvgProfitRate > 0 ? Convert.ToDecimal(item.PAvgProfitRate - PreModel.PAvgProfitRate) / PreModel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    YearAvgSCList.Add(cmodel);
                }
            }
            YearAvgSList.AddRange(YearAvgSCList);
            YearAvgSList = YearAvgSList.OrderBy(x => x.Date).ToList();
            #endregion

            #region 第三表
            foreach (var item in YearRateSList)
            {
                //第一年没有  从第二年开始
                if (item.Date != startYear.ToString())
                {
                    int PreYear = Convert.ToInt32(item.Date) - 1;
                    var PreModel = YearRateSList.Where(x => x.Date == PreYear.ToString()).FirstOrDefault();
                    User_Statistics_Rate_Query cmodel = new User_Statistics_Rate_Query() { Date = item.Date + "成長率" };
                    // 成长率 = (当前年 - 上年） /上年
                    cmodel.MAvgPeopleNum = Math.Round(PreModel.MAvgPeopleNum > 0 ? Convert.ToDecimal(item.MAvgPeopleNum - PreModel.MAvgPeopleNum) / PreModel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgOrderNum = Math.Round(PreModel.MAvgOrderNum > 0 ? Convert.ToDecimal(item.MAvgOrderNum - PreModel.MAvgOrderNum) / PreModel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgPayMoney = Math.Round(PreModel.MAvgPayMoney > 0 ? Convert.ToDecimal(item.MAvgPayMoney - PreModel.MAvgPayMoney) / PreModel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgBuyNum = Math.Round(PreModel.MAvgBuyNum > 0 ? Convert.ToDecimal(item.MAvgBuyNum - PreModel.MAvgBuyNum) / PreModel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgOrderNum = Math.Round(PreModel.PAvgOrderNum > 0 ? Convert.ToDecimal(item.PAvgOrderNum - PreModel.PAvgOrderNum) / PreModel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyNum = Math.Round(PreModel.PAvgBuyNum > 0 ? Convert.ToDecimal(item.PAvgBuyNum - PreModel.PAvgBuyNum) / PreModel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyPrice = Math.Round(PreModel.PAvgBuyPrice > 0 ? Convert.ToDecimal(item.PAvgBuyPrice - PreModel.PAvgBuyPrice) / PreModel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgUnitPrice = Math.Round(PreModel.PAvgUnitPrice > 0 ? Convert.ToDecimal(item.PAvgUnitPrice - PreModel.PAvgUnitPrice) / PreModel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgMOrderRate = Math.Round(PreModel.PAvgMOrderRate > 0 ? Convert.ToDecimal(item.PAvgMOrderRate - PreModel.PAvgMOrderRate) / PreModel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgProfitRate = Math.Round(PreModel.PAvgProfitRate > 0 ? Convert.ToDecimal(item.PAvgProfitRate - PreModel.PAvgProfitRate) / PreModel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    cmodel.PAvgPXNum = Math.Round(PreModel.PAvgPXNum > 0 ? Convert.ToDecimal(item.PAvgPXNum - PreModel.PAvgPXNum) / PreModel.PAvgPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgVipNum = Math.Round(PreModel.PAvgVipNum > 0 ? Convert.ToDecimal(item.PAvgVipNum - PreModel.PAvgVipNum) / PreModel.PAvgVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgYXNum = Math.Round(PreModel.PAvgYXNum > 0 ? Convert.ToDecimal(item.PAvgYXNum - PreModel.PAvgYXNum) / PreModel.PAvgYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgJXNum = Math.Round(PreModel.PAvgJXNum > 0 ? Convert.ToDecimal(item.PAvgJXNum - PreModel.PAvgJXNum) / PreModel.PAvgJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgTotalMNum = Math.Round(PreModel.PAvgTotalMNum > 0 ? Convert.ToDecimal(item.PAvgTotalMNum - PreModel.PAvgTotalMNum) / PreModel.PAvgTotalMNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgProfit = Math.Round(PreModel.PAvgProfit > 0 ? Convert.ToDecimal(item.PAvgProfit - PreModel.PAvgProfit) / PreModel.PAvgProfit : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    YearRateSCList.Add(cmodel);
                }
            }
            YearRateSList.AddRange(YearRateSCList);
            YearRateSList = YearRateSList.OrderBy(x => x.Date).ToList();
            #endregion
            #endregion

            return new
            {
                YearSList = YearSList.Select(x => new
                {
                    x.Date,
                    x.PeopleNum,
                    x.OrderNum,
                    x.PayMoney,
                    x.BuyNum,
                    x.TotalPayPeople,
                    x.MAvgPeopleNum,
                    x.Profit,
                    x.PXNum,
                    x.VipNum,
                    x.YXNum,
                    x.JXNum,
                    x.TotalMNum
                }),
                YearAvgSList = YearAvgSList.Select(x => new
                {
                    x.Date,
                    x.MAvgPeopleNum,
                    x.MAvgOrderNum,
                    x.MAvgPayMoney,
                    x.MAvgBuyNum,
                    x.PAvgOrderNum,
                    x.PAvgBuyNum,
                    x.PAvgBuyPrice,
                    x.PAvgUnitPrice,
                    x.PAvgMemberNum,
                    x.PAvgPaymentNum,
                    x.PAvgMOrderRate,
                    x.PAvgReBuyNum,
                    x.PAvgReBuyRate,
                    x.PAvgNewPeopleNum,
                    x.PAvgProfitRate
                }),
                YearRateSList
            };
        }

        /// <summary>
        /// 年度统计excel导出
        /// </summary>
        /// <param name="startYear"></param>
        /// <param name="endYear"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<ExcelDataSource> GetDSYearStartisticsToExcel(int startYear, int endYear, int tenantId, int mallBaseId)
        {
            string StartDate = Convert.ToDateTime(startYear + "-01-01").AddMonths(-1).ToString("yyyy-MM-dd");//查询提前一个月数据  用于成长率对比
            string EndDate = Convert.ToDateTime(endYear + "-01-01").AddYears(1).AddDays(-1).ToString("yyyy-MM-dd");
            var list = user_StatisticsRepository.GetList(new RB_User_Statistics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, StartTime = StartDate, EndTime = EndDate });
            List<User_Statistics_Query_V2> YearSList = new List<User_Statistics_Query_V2>();//月统计数据
            List<User_Statistics_Query> YearAvgSList = new List<User_Statistics_Query>();//年平均统计数据
            List<User_Statistics_Rate_Query> YearRateSList = new List<User_Statistics_Rate_Query>();//年成长率统计数据
            int SYear = startYear;
            while (true)
            {
                var ylist = list.Where(x => x.DateYear == SYear).ToList();
                #region 1表统计
                User_Statistics_Query_V2 ymodel = new User_Statistics_Query_V2() { Date = SYear.ToString() };
                ymodel.PeopleNum = ylist.Sum(x => x.PeopleNum);
                ymodel.OrderNum = ylist.Sum(x => x.OrderNum);
                ymodel.PayMoney = ylist.Sum(x => x.PayMoney);
                ymodel.BuyNum = ylist.Sum(x => x.BuyNum);
                ymodel.TotalPayPeople = ylist.Any() ? ylist.Max(x => x.MemberNum) : 0;
                ymodel.MAvgPeopleNum = ylist.Any() ? ylist.Max(x => x.PaymentNum) : 0;
                ymodel.Profit = ylist.Sum(x => x.Profit);
                ymodel.PXNum = ylist.Sum(x => x.PXNum);
                ymodel.VipNum = ylist.Sum(x => x.VipNum);
                ymodel.YXNum = ylist.Sum(x => x.YXNum);
                ymodel.JXNum = ylist.Sum(x => x.JXNum);
                ymodel.TotalMNum = ymodel.PXNum + ymodel.VipNum + ymodel.YXNum + ymodel.JXNum;
                YearSList.Add(ymodel);
                #endregion

                #region 2表平均统计
                List<User_Statistics_Query> MonthSList = new List<User_Statistics_Query>();//月统计数据
                string SMonth = Convert.ToDateTime(SYear + "-01-01").AddMonths(-1).ToString("yyyy-MM");//第一个月
                string endTime = Convert.ToDateTime(SYear + "-01-01").AddYears(1).AddDays(-1).ToString("yyyy-MM");//最后一个月
                int TotalMonthNum = 0;
                while (true)
                {
                    TotalMonthNum++;
                    User_Statistics_Query mmodel = new User_Statistics_Query() { Date = SMonth };
                    //查询当月数据
                    var mlist = list.Where(x => x.DateMonth == SMonth).ToList();
                    mmodel.PeopleNum = mlist.Sum(x => x.PeopleNum);
                    mmodel.OrderNum = mlist.Sum(x => x.OrderNum);
                    mmodel.PayMoney = mlist.Sum(x => x.PayMoney);
                    mmodel.BuyNum = mlist.Sum(x => x.BuyNum);
                    mmodel.TotalPayPeople = mlist.Any() ? mlist.Max(x => x.PaymentNum) : 0;
                    mmodel.Profit = mlist.Sum(x => x.Profit);
                    //int TotalPXNum = mlist.Any() ? mlist.Max(x => x.PXLJNum) : 0;
                    //int TotalVIPNum = mlist.Any() ? mlist.Max(x => x.VipLJNum) : 0;
                    //int TotalYXNum = mlist.Any() ? mlist.Max(x => x.YXLJNum) : 0;
                    //int TotalJXNum = mlist.Any() ? mlist.Max(x => x.JXLJNum) : 0;
                    mmodel.PXNum = mlist.Sum(x => x.PXNum);
                    mmodel.VipNum = mlist.Sum(x => x.VipNum);
                    mmodel.YXNum = mlist.Sum(x => x.YXNum);
                    mmodel.JXNum = mlist.Sum(x => x.JXNum);
                    mmodel.TotalMNum = mmodel.PXNum + mmodel.VipNum + mmodel.YXNum + mmodel.JXNum;

                    #region 求月平均
                    #region 月平均参数
                    decimal yPeopleNum = 0;
                    decimal yOrderNum = 0;
                    decimal yPayMoney = 0;
                    decimal yBuyNum = 0;
                    decimal yAvgOrderNum = 0;
                    decimal yAvgBuyNum = 0;
                    decimal yAvgUnitPrice = 0;
                    decimal yAvgBuyPrice = 0;
                    decimal yMemberNum = 0;
                    decimal yPaymentNum = 0;
                    decimal yMOrderRate = 0;
                    decimal yReBuyNum = 0;
                    decimal yReBuyRate = 0;
                    decimal yNewPeopleNum = 0;
                    decimal yPXNum = 0;
                    decimal yVipNum = 0;
                    decimal yYXNum = 0;
                    decimal yJXNum = 0;
                    decimal yProfit = 0;
                    decimal yProfitRate = 0;
                    #endregion
                    string SDate = SMonth + "-01";
                    string EDate = Convert.ToDateTime(SMonth + "-01").AddMonths(1).AddDays(-1).ToString("yyyy-MM-dd");
                    int MaxDay = Convert.ToDateTime(EDate).Day;

                    //分三段求 每期的平均
                    if (true)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day <= 10).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    if (true)
                    {
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.OrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PayMoney)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.BuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgOrderNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgUnitPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.AvgBuyPrice)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MemberNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PaymentNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.MOrderRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ReBuyRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.NewPeopleNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.PXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.VipNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.YXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.JXNum)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.Profit)) / 10, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 10 && x.Date.Day <= 20).Sum(x => x.ProfitRate)) / 10, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }
                    if (true)
                    {
                        int NowDay = MaxDay - 20;
                        #region 本月
                        decimal PeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal OrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.OrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PayMoney = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PayMoney)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal BuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.BuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgOrderNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgOrderNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgUnitPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgUnitPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal AvgBuyPrice = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.AvgBuyPrice)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MemberNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MemberNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PaymentNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PaymentNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal MOrderRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.MOrderRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ReBuyRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ReBuyRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal NewPeopleNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.NewPeopleNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal PXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.PXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal VipNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.VipNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal YXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.YXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal JXNum = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.JXNum)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal Profit = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.Profit)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        decimal ProfitRate = Math.Round(Convert.ToDecimal(mlist.Where(x => x.Date.Day > 20).Sum(x => x.ProfitRate)) / NowDay, 2, MidpointRounding.AwayFromZero);
                        #endregion

                        #region 月平均
                        yPeopleNum += PeopleNum;
                        yOrderNum += OrderNum;
                        yPayMoney += PayMoney;
                        yBuyNum += BuyNum;
                        yAvgOrderNum += AvgOrderNum;
                        yAvgBuyNum += AvgBuyNum;
                        yAvgUnitPrice += AvgUnitPrice;
                        yAvgBuyPrice += AvgBuyPrice;
                        yMemberNum += MemberNum;
                        yPaymentNum += PaymentNum;
                        yMOrderRate += MOrderRate;
                        yReBuyNum += ReBuyNum;
                        yReBuyRate += ReBuyRate;
                        yNewPeopleNum += NewPeopleNum;
                        yPXNum += PXNum;
                        yVipNum += VipNum;
                        yYXNum += YXNum;
                        yJXNum += JXNum;
                        yProfit += Profit;
                        yProfitRate += ProfitRate;
                        #endregion
                    }


                    #region 月平均赋值
                    mmodel.MAvgPeopleNum = Math.Round(yPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.MAvgOrderNum = Math.Round(yOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.MAvgPayMoney = Math.Round(yPayMoney / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.MAvgBuyNum = Math.Round(yBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgOrderNum = Math.Round(yAvgOrderNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgBuyNum = Math.Round(yAvgBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgUnitPrice = Math.Round(yAvgUnitPrice / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgBuyPrice = Math.Round(yAvgBuyPrice / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgMemberNum = Math.Round(yMemberNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgPaymentNum = Math.Round(yPaymentNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgMOrderRate = Math.Round(yMOrderRate / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgReBuyNum = Math.Round(yReBuyNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgReBuyRate = Math.Round(yReBuyRate / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgNewPeopleNum = Math.Round(yNewPeopleNum / 3, 2, MidpointRounding.AwayFromZero);
                    mmodel.PAvgProfitRate = Math.Round(yProfitRate / 3, 2, MidpointRounding.AwayFromZero);
                    #endregion
                    #endregion

                    MonthSList.Add(mmodel);
                    if (SMonth == endTime)
                    {
                        break;
                    }
                    SMonth = Convert.ToDateTime(SMonth + "-01").AddMonths(1).ToString("yyyy-MM");
                }
                if (MonthSList.Any())
                {
                    string ContrastMonth = Convert.ToDateTime(SYear + "-01-01").AddMonths(-1).ToString("yyyy-MM");
                    var MonthSList2 = MonthSList.Where(x => x.Date != ContrastMonth).ToList();
                    TotalMonthNum--;
                    //计算平均/总计    平均需排除掉对比月数据
                    User_Statistics_Query MTotalModel = new User_Statistics_Query()
                    {
                        Date = SYear.ToString(),
                        MAvgPeopleNum = Math.Round(MonthSList2.Sum(x => x.MAvgPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        MAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.MAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        MAvgPayMoney = Math.Round(MonthSList2.Sum(x => x.MAvgPayMoney) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        MAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.MAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgOrderNum = Math.Round(MonthSList2.Sum(x => x.PAvgOrderNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgUnitPrice = Math.Round(MonthSList2.Sum(x => x.PAvgUnitPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgBuyPrice = Math.Round(MonthSList2.Sum(x => x.PAvgBuyPrice) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgMemberNum = Math.Round(MonthSList2.Sum(x => x.PAvgMemberNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgPaymentNum = Math.Round(MonthSList2.Sum(x => x.PAvgPaymentNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgMOrderRate = Math.Round(MonthSList2.Sum(x => x.PAvgMOrderRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgReBuyNum = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgReBuyRate = Math.Round(MonthSList2.Sum(x => x.PAvgReBuyRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgNewPeopleNum = Math.Round(MonthSList2.Sum(x => x.PAvgNewPeopleNum) / TotalMonthNum, 2, MidpointRounding.AwayFromZero),
                        PAvgProfitRate = Math.Round(MonthSList2.Sum(x => x.PAvgProfitRate) / TotalMonthNum, 2, MidpointRounding.AwayFromZero)
                    };
                    YearAvgSList.Add(MTotalModel);
                }
                #endregion

                #region 3表成长率统计
                List<User_Statistics_Rate_Query> ReRateList = new List<User_Statistics_Rate_Query>();//概率数据
                string SRateMonth = SYear + "-01";
                //这个要从查询第一个月开始
                while (true)
                {
                    //求当月的所有比例    (当月-上月)/上月
                    var NowMmodel = MonthSList.Where(x => x.Date == SRateMonth).FirstOrDefault();
                    var PreMmodel = MonthSList.Where(x => x.Date == Convert.ToDateTime(SRateMonth + "-01").AddMonths(-1).ToString("yyyy-MM")).FirstOrDefault();

                    User_Statistics_Rate_Query smodel = new User_Statistics_Rate_Query() { Date = SRateMonth };
                    smodel.MAvgPeopleNum = NowMmodel.MAvgPeopleNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgPeopleNum > 0 ? (NowMmodel.MAvgPeopleNum - PreMmodel.MAvgPeopleNum) / PreMmodel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.MAvgOrderNum = NowMmodel.MAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgOrderNum > 0 ? (NowMmodel.MAvgOrderNum - PreMmodel.MAvgOrderNum) / PreMmodel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.MAvgPayMoney = NowMmodel.MAvgPayMoney <= 0 ? 0 : Math.Round(PreMmodel.MAvgPayMoney > 0 ? (NowMmodel.MAvgPayMoney - PreMmodel.MAvgPayMoney) / PreMmodel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.MAvgBuyNum = NowMmodel.MAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.MAvgBuyNum > 0 ? (NowMmodel.MAvgBuyNum - PreMmodel.MAvgBuyNum) / PreMmodel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgOrderNum = NowMmodel.PAvgOrderNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgOrderNum > 0 ? (NowMmodel.PAvgOrderNum - PreMmodel.PAvgOrderNum) / PreMmodel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgBuyNum = NowMmodel.PAvgBuyNum <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyNum > 0 ? (NowMmodel.PAvgBuyNum - PreMmodel.PAvgBuyNum) / PreMmodel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgUnitPrice = NowMmodel.PAvgUnitPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgUnitPrice > 0 ? (NowMmodel.PAvgUnitPrice - PreMmodel.PAvgUnitPrice) / PreMmodel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgBuyPrice = NowMmodel.PAvgBuyPrice <= 0 ? 0 : Math.Round(PreMmodel.PAvgBuyPrice > 0 ? (NowMmodel.PAvgBuyPrice - PreMmodel.PAvgBuyPrice) / PreMmodel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgMOrderRate = NowMmodel.PAvgMOrderRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgMOrderRate > 0 ? (NowMmodel.PAvgMOrderRate - PreMmodel.PAvgMOrderRate) / PreMmodel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgProfitRate = NowMmodel.PAvgProfitRate <= 0 ? 0 : Math.Round(PreMmodel.PAvgProfitRate > 0 ? (NowMmodel.PAvgProfitRate - PreMmodel.PAvgProfitRate) / PreMmodel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgProfit = NowMmodel.Profit <= 0 ? 0 : Math.Round(PreMmodel.Profit > 0 ? (NowMmodel.Profit - PreMmodel.Profit) / PreMmodel.Profit : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgPXNum = NowMmodel.PXNum <= 0 ? 0 : Math.Round(PreMmodel.PXNum > 0 ? Convert.ToDecimal(NowMmodel.PXNum - PreMmodel.PXNum) / PreMmodel.PXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgVipNum = NowMmodel.VipNum <= 0 ? 0 : Math.Round(PreMmodel.VipNum > 0 ? Convert.ToDecimal(NowMmodel.VipNum - PreMmodel.VipNum) / PreMmodel.VipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgYXNum = NowMmodel.YXNum <= 0 ? 0 : Math.Round(PreMmodel.YXNum > 0 ? Convert.ToDecimal(NowMmodel.YXNum - PreMmodel.YXNum) / PreMmodel.YXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgJXNum = NowMmodel.JXNum <= 0 ? 0 : Math.Round(PreMmodel.JXNum > 0 ? Convert.ToDecimal(NowMmodel.JXNum - PreMmodel.JXNum) / PreMmodel.JXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    smodel.PAvgTotalMNum = NowMmodel.TotalMNum <= 0 ? 0 : Math.Round(PreMmodel.TotalMNum > 0 ? Convert.ToDecimal(NowMmodel.TotalMNum - PreMmodel.TotalMNum) / PreMmodel.TotalMNum : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    ReRateList.Add(smodel);
                    if (SRateMonth == endTime)
                    {
                        break;
                    }
                    SRateMonth = Convert.ToDateTime(SRateMonth + "-01").AddMonths(1).ToString("yyyy-MM");
                }
                if (ReRateList.Any())
                {
                    TotalMonthNum++;
                    User_Statistics_Rate_Query savgmodel = new User_Statistics_Rate_Query() { Date = SYear.ToString() };
                    savgmodel.MAvgPeopleNum = Math.Round(ReRateList.Sum(x => x.MAvgPeopleNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.MAvgOrderNum = Math.Round(ReRateList.Sum(x => x.MAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.MAvgPayMoney = Math.Round(ReRateList.Sum(x => x.MAvgPayMoney) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.MAvgBuyNum = Math.Round(ReRateList.Sum(x => x.MAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgOrderNum = Math.Round(ReRateList.Sum(x => x.PAvgOrderNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgBuyNum = Math.Round(ReRateList.Sum(x => x.PAvgBuyNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgUnitPrice = Math.Round(ReRateList.Sum(x => x.PAvgUnitPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgBuyPrice = Math.Round(ReRateList.Sum(x => x.PAvgBuyPrice) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgMOrderRate = Math.Round(ReRateList.Sum(x => x.PAvgMOrderRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgProfitRate = Math.Round(ReRateList.Sum(x => x.PAvgProfitRate) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgProfit = Math.Round(ReRateList.Sum(x => x.PAvgProfit) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgPXNum = Math.Round(ReRateList.Sum(x => x.PAvgPXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgVipNum = Math.Round(ReRateList.Sum(x => x.PAvgVipNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgYXNum = Math.Round(ReRateList.Sum(x => x.PAvgYXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgJXNum = Math.Round(ReRateList.Sum(x => x.PAvgJXNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    savgmodel.PAvgTotalMNum = Math.Round(ReRateList.Sum(x => x.PAvgTotalMNum) / (TotalMonthNum - 1), 2, MidpointRounding.AwayFromZero);
                    YearRateSList.Add(savgmodel);
                }
                #endregion

                if (SYear == endYear)
                {
                    break;
                }
                SYear = Convert.ToDateTime(SYear + "-01-01").AddYears(1).Year;
            }

            #region 拿到所有年数据  成长率值
            List<User_Statistics_Query_V2> YearSCList = new List<User_Statistics_Query_V2>();//月统计数据   成长率
            List<User_Statistics_Query> YearAvgSCList = new List<User_Statistics_Query>();//年平均统计数据   成长率
            List<User_Statistics_Rate_Query> YearRateSCList = new List<User_Statistics_Rate_Query>();//年成长率统计数据  成长率
            #region 第一表
            foreach (var item in YearSList)
            {
                //第一年没有  从第二年开始
                if (item.Date != startYear.ToString())
                {
                    int PreYear = Convert.ToInt32(item.Date) - 1;
                    var PreModel = YearSList.Where(x => x.Date == PreYear.ToString()).FirstOrDefault();
                    User_Statistics_Query_V2 cmodel = new User_Statistics_Query_V2() { Date = item.Date + "成長率" };
                    // 成长率 = (当前年 - 上年） /上年
                    cmodel.PeopleNum = Math.Round(PreModel.PeopleNum > 0 ? Convert.ToDecimal(item.PeopleNum - PreModel.PeopleNum) / PreModel.PeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.OrderNum = Math.Round(PreModel.OrderNum > 0 ? Convert.ToDecimal(item.OrderNum - PreModel.OrderNum) / PreModel.OrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PayMoney = Math.Round(PreModel.PayMoney > 0 ? Convert.ToDecimal(item.PayMoney - PreModel.PayMoney) / PreModel.PayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.BuyNum = Math.Round(PreModel.BuyNum > 0 ? Convert.ToDecimal(item.BuyNum - PreModel.BuyNum) / PreModel.BuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.TotalPayPeople = Math.Round(PreModel.TotalPayPeople > 0 ? Convert.ToDecimal(item.TotalPayPeople - PreModel.TotalPayPeople) / PreModel.TotalPayPeople : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgPeopleNum = Math.Round(PreModel.MAvgPeopleNum > 0 ? Convert.ToDecimal(item.MAvgPeopleNum - PreModel.MAvgPeopleNum) / PreModel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.Profit = Math.Round(PreModel.Profit > 0 ? Convert.ToDecimal(item.Profit - PreModel.Profit) / PreModel.Profit : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PXNum = Math.Round(PreModel.PXNum > 0 ? Convert.ToDecimal(item.PXNum - PreModel.PXNum) / PreModel.PXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.VipNum = Math.Round(PreModel.VipNum > 0 ? Convert.ToDecimal(item.VipNum - PreModel.VipNum) / PreModel.VipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.YXNum = Math.Round(PreModel.YXNum > 0 ? Convert.ToDecimal(item.YXNum - PreModel.YXNum) / PreModel.YXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.JXNum = Math.Round(PreModel.JXNum > 0 ? Convert.ToDecimal(item.JXNum - PreModel.JXNum) / PreModel.JXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.TotalMNum = cmodel.PXNum + cmodel.VipNum + cmodel.YXNum + cmodel.JXNum;
                    YearSCList.Add(cmodel);
                }
            }
            YearSList.AddRange(YearSCList);
            YearSList = YearSList.OrderBy(x => x.Date).ToList();//拍一下序
            #endregion

            #region 第二表
            foreach (var item in YearAvgSList)
            {
                //第一年没有  从第二年开始
                if (item.Date != startYear.ToString())
                {
                    int PreYear = Convert.ToInt32(item.Date) - 1;
                    var PreModel = YearAvgSList.Where(x => x.Date == PreYear.ToString()).FirstOrDefault();
                    User_Statistics_Query cmodel = new User_Statistics_Query() { Date = item.Date + "成長率" };
                    // 成长率 = (当前年 - 上年） /上年
                    cmodel.MAvgPeopleNum = Math.Round(PreModel.MAvgPeopleNum > 0 ? Convert.ToDecimal(item.MAvgPeopleNum - PreModel.MAvgPeopleNum) / PreModel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgOrderNum = Math.Round(PreModel.MAvgOrderNum > 0 ? Convert.ToDecimal(item.MAvgOrderNum - PreModel.MAvgOrderNum) / PreModel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgPayMoney = Math.Round(PreModel.MAvgPayMoney > 0 ? Convert.ToDecimal(item.MAvgPayMoney - PreModel.MAvgPayMoney) / PreModel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgBuyNum = Math.Round(PreModel.MAvgBuyNum > 0 ? Convert.ToDecimal(item.MAvgBuyNum - PreModel.MAvgBuyNum) / PreModel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgOrderNum = Math.Round(PreModel.PAvgOrderNum > 0 ? Convert.ToDecimal(item.PAvgOrderNum - PreModel.PAvgOrderNum) / PreModel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyNum = Math.Round(PreModel.PAvgBuyNum > 0 ? Convert.ToDecimal(item.PAvgBuyNum - PreModel.PAvgBuyNum) / PreModel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyPrice = Math.Round(PreModel.PAvgBuyPrice > 0 ? Convert.ToDecimal(item.PAvgBuyPrice - PreModel.PAvgBuyPrice) / PreModel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgUnitPrice = Math.Round(PreModel.PAvgUnitPrice > 0 ? Convert.ToDecimal(item.PAvgUnitPrice - PreModel.PAvgUnitPrice) / PreModel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgMemberNum = Math.Round(PreModel.PAvgMemberNum > 0 ? Convert.ToDecimal(item.PAvgMemberNum - PreModel.PAvgMemberNum) / PreModel.PAvgMemberNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgPaymentNum = Math.Round(PreModel.PAvgPaymentNum > 0 ? Convert.ToDecimal(item.PAvgPaymentNum - PreModel.PAvgPaymentNum) / PreModel.PAvgPaymentNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgMOrderRate = Math.Round(PreModel.PAvgMOrderRate > 0 ? Convert.ToDecimal(item.PAvgMOrderRate - PreModel.PAvgMOrderRate) / PreModel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgReBuyNum = Math.Round(PreModel.PAvgReBuyNum > 0 ? Convert.ToDecimal(item.PAvgReBuyNum - PreModel.PAvgReBuyNum) / PreModel.PAvgReBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgReBuyRate = Math.Round(PreModel.PAvgReBuyRate > 0 ? Convert.ToDecimal(item.PAvgReBuyRate - PreModel.PAvgReBuyRate) / PreModel.PAvgReBuyRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgNewPeopleNum = Math.Round(PreModel.PAvgNewPeopleNum > 0 ? Convert.ToDecimal(item.PAvgNewPeopleNum - PreModel.PAvgNewPeopleNum) / PreModel.PAvgNewPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgProfitRate = Math.Round(PreModel.PAvgProfitRate > 0 ? Convert.ToDecimal(item.PAvgProfitRate - PreModel.PAvgProfitRate) / PreModel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    YearAvgSCList.Add(cmodel);
                }
            }
            YearAvgSList.AddRange(YearAvgSCList);
            YearAvgSList = YearAvgSList.OrderBy(x => x.Date).ToList();
            #endregion

            #region 第三表
            foreach (var item in YearRateSList)
            {
                //第一年没有  从第二年开始
                if (item.Date != startYear.ToString())
                {
                    int PreYear = Convert.ToInt32(item.Date) - 1;
                    var PreModel = YearRateSList.Where(x => x.Date == PreYear.ToString()).FirstOrDefault();
                    User_Statistics_Rate_Query cmodel = new User_Statistics_Rate_Query() { Date = item.Date + "成長率" };
                    // 成长率 = (当前年 - 上年） /上年
                    cmodel.MAvgPeopleNum = Math.Round(PreModel.MAvgPeopleNum > 0 ? Convert.ToDecimal(item.MAvgPeopleNum - PreModel.MAvgPeopleNum) / PreModel.MAvgPeopleNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgOrderNum = Math.Round(PreModel.MAvgOrderNum > 0 ? Convert.ToDecimal(item.MAvgOrderNum - PreModel.MAvgOrderNum) / PreModel.MAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgPayMoney = Math.Round(PreModel.MAvgPayMoney > 0 ? Convert.ToDecimal(item.MAvgPayMoney - PreModel.MAvgPayMoney) / PreModel.MAvgPayMoney : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.MAvgBuyNum = Math.Round(PreModel.MAvgBuyNum > 0 ? Convert.ToDecimal(item.MAvgBuyNum - PreModel.MAvgBuyNum) / PreModel.MAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgOrderNum = Math.Round(PreModel.PAvgOrderNum > 0 ? Convert.ToDecimal(item.PAvgOrderNum - PreModel.PAvgOrderNum) / PreModel.PAvgOrderNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyNum = Math.Round(PreModel.PAvgBuyNum > 0 ? Convert.ToDecimal(item.PAvgBuyNum - PreModel.PAvgBuyNum) / PreModel.PAvgBuyNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgBuyPrice = Math.Round(PreModel.PAvgBuyPrice > 0 ? Convert.ToDecimal(item.PAvgBuyPrice - PreModel.PAvgBuyPrice) / PreModel.PAvgBuyPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgUnitPrice = Math.Round(PreModel.PAvgUnitPrice > 0 ? Convert.ToDecimal(item.PAvgUnitPrice - PreModel.PAvgUnitPrice) / PreModel.PAvgUnitPrice : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgMOrderRate = Math.Round(PreModel.PAvgMOrderRate > 0 ? Convert.ToDecimal(item.PAvgMOrderRate - PreModel.PAvgMOrderRate) / PreModel.PAvgMOrderRate : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgProfitRate = Math.Round(PreModel.PAvgProfitRate > 0 ? Convert.ToDecimal(item.PAvgProfitRate - PreModel.PAvgProfitRate) / PreModel.PAvgProfitRate : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    cmodel.PAvgPXNum = Math.Round(PreModel.PAvgPXNum > 0 ? Convert.ToDecimal(item.PAvgPXNum - PreModel.PAvgPXNum) / PreModel.PAvgPXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgVipNum = Math.Round(PreModel.PAvgVipNum > 0 ? Convert.ToDecimal(item.PAvgVipNum - PreModel.PAvgVipNum) / PreModel.PAvgVipNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgYXNum = Math.Round(PreModel.PAvgYXNum > 0 ? Convert.ToDecimal(item.PAvgYXNum - PreModel.PAvgYXNum) / PreModel.PAvgYXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgJXNum = Math.Round(PreModel.PAvgJXNum > 0 ? Convert.ToDecimal(item.PAvgJXNum - PreModel.PAvgJXNum) / PreModel.PAvgJXNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgTotalMNum = Math.Round(PreModel.PAvgTotalMNum > 0 ? Convert.ToDecimal(item.PAvgTotalMNum - PreModel.PAvgTotalMNum) / PreModel.PAvgTotalMNum : 1, 4, MidpointRounding.AwayFromZero) * 100;
                    cmodel.PAvgProfit = Math.Round(PreModel.PAvgProfit > 0 ? Convert.ToDecimal(item.PAvgProfit - PreModel.PAvgProfit) / PreModel.PAvgProfit : 1, 4, MidpointRounding.AwayFromZero) * 100;

                    YearRateSCList.Add(cmodel);
                }
            }
            YearRateSList.AddRange(YearRateSCList);
            YearRateSList = YearRateSList.OrderBy(x => x.Date).ToList();
            #endregion
            #endregion

            #region 组装excel数据
            List<ExcelDataSource> DataList = new List<ExcelDataSource>();
            #region 第一表
            #region 组装标题
            ExcelDataSource header1 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>() {
                    new ExcelColumn(value: "年度"){CellWidth = 25, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                },
                ColumnHight = 30
            };

            int SYear2 = startYear;
            while (true)
            {
                header1.ExcelRows.Add(new ExcelColumn(value: SYear2.ToString()) { CellWidth = 20, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
                if (SYear2 >= startYear + 1)
                {
                    header1.ExcelRows.Add(new ExcelColumn(value: SYear2.ToString() + "成長率") { CellWidth = 20, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
                }
                if (SYear2 == endYear)
                {
                    break;
                }
                SYear2 = Convert.ToDateTime(SYear2 + "-01-01").AddYears(1).Year;
            }
            DataList.Add(header1);
            #endregion

            #region 组装数据
            List<string> DateRowList = new List<string>() {
                "PeopleNum|付款人數",
                "OrderNum|付款單數",
                "PayMoney|付款金額",
                "BuyNum|購買件數",
                "TotalPayPeople|會員总数",
                "MAvgPeopleNum|累计付款人數",
                "Profit|毛利",
                "PXNum|普象",
                "VipNum|VIP",
                "YXNum|銀象",
                "JXNum|金象",
                "TotalMNum|會員總數"
            };
            foreach (var item in DateRowList)
            {
                var fileNameArr = item.Split('|');
                ExcelDataSource datarow2 = new ExcelDataSource()
                {
                    ExcelRows = new List<ExcelColumn>(23) {
                        new ExcelColumn(value: fileNameArr[1]) { },
                    },
                    ColumnHight = 30
                };

                foreach (var qitem in YearSList)
                {
                    JObject parms = JObject.Parse(JsonHelper.Serialize(qitem));
                    string mvalue = parms.GetStringValue(fileNameArr[0]);
                    datarow2.ExcelRows.Add(new ExcelColumn(value: mvalue + (qitem.Date.Contains("成長率") ? "%" : "")) { });
                }
                DataList.Add(datarow2);
            }
            #endregion

            //增加行空白
            DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { } });
            #endregion

            #region 第二表
            #region 组装标题
            ExcelDataSource header2 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>() {
                    new ExcelColumn(value: "年度"){ }
                },
                ColumnHight = 30
            };

            SYear2 = startYear;
            while (true)
            {
                header2.ExcelRows.Add(new ExcelColumn(value: SYear2.ToString()) { });
                if (SYear2 >= startYear + 1)
                {
                    header2.ExcelRows.Add(new ExcelColumn(value: SYear2.ToString() + "成長率") { });
                }
                if (SYear2 == endYear)
                {
                    break;
                }
                SYear2 = Convert.ToDateTime(SYear2 + "-01-01").AddYears(1).Year;
            }
            DataList.Add(header2);
            #endregion

            #region 组装数据
            List<string> DateRowList2 = new List<string>() {
                "MAvgPeopleNum|平均付款人數",
                "MAvgOrderNum|平均付款單數",
                "MAvgPayMoney|平均付款金額",
                "MAvgBuyNum|平均付款件數",
                "PAvgOrderNum|平均每人購買單數",
                "PAvgBuyNum|平均每人購買件數",
                "PAvgUnitPrice|平均每單單價",
                "PAvgBuyPrice|平均每人購買單價",
                "PAvgMemberNum|平均會員數",
                "PAvgPaymentNum|平均付款累計人數",
                "PAvgMOrderRate|平均會員下訂單轉換率",
                "PAvgReBuyNum|平均復夠人數",
                "PAvgReBuyRate|平均復夠率",
                "PAvgNewPeopleNum|平均新人下單",
                "PAvgProfitRate|毛利率"
            };
            foreach (var item in DateRowList2)
            {
                var fileNameArr = item.Split('|');
                ExcelDataSource datarow2 = new ExcelDataSource()
                {
                    ExcelRows = new List<ExcelColumn>(23) {
                        new ExcelColumn(value: fileNameArr[1]) { },
                    },
                    ColumnHight = 30
                };

                foreach (var qitem in YearAvgSList)
                {
                    JObject parms = JObject.Parse(JsonHelper.Serialize(qitem));
                    string mvalue = parms.GetStringValue(fileNameArr[0]);
                    datarow2.ExcelRows.Add(new ExcelColumn(value: mvalue + (qitem.Date.Contains("成長率") ? "%" : "")) { });
                }
                DataList.Add(datarow2);
            }
            #endregion

            //增加行空白
            DataList.Add(new ExcelDataSource() { ExcelRows = new List<ExcelColumn>(23) { } });
            #endregion

            #region 第三表

            #region 组装标题
            ExcelDataSource header3 = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>() {
                    new ExcelColumn(value: "年度"){ }
                },
                ColumnHight = 30
            };

            SYear2 = startYear;
            while (true)
            {
                header3.ExcelRows.Add(new ExcelColumn(value: SYear2.ToString()) { });
                if (SYear2 >= startYear + 1)
                {
                    header3.ExcelRows.Add(new ExcelColumn(value: SYear2.ToString() + "成長率") { });
                }
                if (SYear2 == endYear)
                {
                    break;
                }
                SYear2 = Convert.ToDateTime(SYear2 + "-01-01").AddYears(1).Year;
            }
            DataList.Add(header3);
            #endregion

            #region 组装数据
            List<string> DateRowList3 = new List<string>() {
                "MAvgPeopleNum|平均付款人數成長率",
                "MAvgOrderNum|平均付款單數成長率",
                "MAvgPayMoney|平均付款金額成長率",
                "MAvgBuyNum|平均付款件數成長率",
                "PAvgOrderNum|平均每人購買單數成長率",
                "PAvgBuyNum|平均每人購買件數成長率",
                "PAvgUnitPrice|平均每單單價成長率",
                "PAvgBuyPrice|平均每人購買單價成長率",
                "PAvgProfit|毛利成長率",
                "PAvgMOrderRate|會員下訂單成長率",
                "PAvgPXNum|普象會員成長率",
                "PAvgVipNum|VIP會員成長率",
                "PAvgYXNum|銀象會員成長率",
                "PAvgJXNum|金象會員成長率",
                "PAvgTotalMNum|會員總成長率"
            };
            foreach (var item in DateRowList3)
            {
                var fileNameArr = item.Split('|');
                ExcelDataSource datarow2 = new ExcelDataSource()
                {
                    ExcelRows = new List<ExcelColumn>(23) {
                        new ExcelColumn(value: fileNameArr[1]) { },
                    },
                    ColumnHight = 30
                };

                foreach (var qitem in YearRateSList)
                {
                    JObject parms = JObject.Parse(JsonHelper.Serialize(qitem));
                    string mvalue = parms.GetStringValue(fileNameArr[0]);
                    datarow2.ExcelRows.Add(new ExcelColumn(value: mvalue + (qitem.Date.Contains("成長率") ? "%" : "")) { });
                }
                DataList.Add(datarow2);
            }
            #endregion
            #endregion
            #endregion

            return DataList;
        }

        #endregion
    }
}
