﻿using Mall.Common.Enum;
using Mall.Model.Extend.User;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 小程序管理员
    /// </summary>
    public class MiniprogramAdminModule
    {
        /// <summary>
        /// 小程序管理员仓储层对象
        /// </summary>
        private readonly RB_Miniprogram_AdminRepository miniprogram_AdminRepository = new RB_Miniprogram_AdminRepository();

        /// <summary>
        /// 获取管理员分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Miniprogram_Admin_Extend> GetMiniprogramAdminPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Miniprogram_Admin_Extend query)
        {
            return miniprogram_AdminRepository.GetMiniprogramAdminPageRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 检查用户是否存在
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool CheckExistsAdminModule(RB_Miniprogram_Admin_Extend model)
        {
            var oldModel = miniprogram_AdminRepository.GetMiniprogramAdminEntityRepository(new RB_Miniprogram_Admin_Extend()
            {
                TenantId = model.TenantId,
                MallBaseId = model.MallBaseId,
                UserId = model.UserId
            });
            var flag= oldModel?.AdminId > 0;
            return flag;
        }

        /// <summary>
        /// 新增修改小程序管理员
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetMiniprogramAdminModule(RB_Miniprogram_Admin_Extend model)
        {
            bool flag;
            var oldModel = miniprogram_AdminRepository.GetMiniprogramAdminEntityRepository(new RB_Miniprogram_Admin_Extend()
            {
                TenantId = model.TenantId,
                MallBaseId = model.MallBaseId,
                UserId = model.UserId
            });
            model.AdminId = oldModel?.AdminId ?? 0;
            if (model.AdminId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Miniprogram_Admin_Extend.UpdateDate),model.UpdateDate }
                };
                flag = miniprogram_AdminRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Admin_Extend.AdminId),model.AdminId));
            }
            else
            {
                var newId = miniprogram_AdminRepository.Insert(model);
                model.AdminId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号删除管理员
        /// </summary>
        /// <param name="AdminId"></param>
        /// <returns></returns>
        public bool RemoveMiniprogramAdminModule(int AdminId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Miniprogram_Admin_Extend.Status),(int)DateStateEnum.Delete }
            };
            bool flag = miniprogram_AdminRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Admin_Extend.AdminId), AdminId));
            return flag;
        }
    }
}