﻿using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Extend.BaseSetUp;
using Mall.Common.Enum;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 数据字典仓储层
    /// </summary>
    public partial class Rb_DictvalueRepository : BaseRepository<RB_Dictvalue>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Dictvalue); } }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="where"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Dictvalue_Extend> GetPageList(int pageIndex, int pageSize, RB_Dictvalue_Extend where, out long count)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat(" SELECT * FROM {0} WHERE 1=1 ", TableName);
            sb.AppendFormat(" AND {0}={1} ", nameof(RB_Dictvalue_Extend.Status), (int)DateStateEnum.Normal);
            if (where != null)
            {
                if (where.RB_Group_id > 0)
                {
                    sb.AppendFormat(" AND {0}={1} ", nameof(RB_Dictvalue_Extend.RB_Group_id), where.RB_Group_id);
                }
                if (!string.IsNullOrEmpty(where.Content))
                {
                    sb.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Dictvalue_Extend.Name), where.Content.Trim());
                }
            }
            return GetPage<RB_Dictvalue_Extend>(pageIndex, pageSize, out count, sb.ToString()).ToList();
        }

        /// <summary>
        /// 获取条件下所有的字典
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Dictvalue_Extend> GetList(RB_Dictvalue_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat(" SELECT * FROM {0} WHERE 1=1 ", TableName);
            if (where != null)
            {
                if (where.Status >= 0)
                {
                    sb.AppendFormat(" AND {0}={1} ", nameof(RB_Dictvalue_Extend.Status), (int)where.Status);
                }
                if (!string.IsNullOrEmpty(where.Name))
                {
                    sb.AppendFormat(" AND {0}='{1}' ", nameof(RB_Dictvalue_Extend.Name), where.Name.Trim());
                }
                if (!string.IsNullOrEmpty(where.Code))
                {
                    sb.AppendFormat(" AND {0}='{1}' ", nameof(RB_Dictvalue_Extend.Code), where.Code.Trim());
                }
                if (where.RB_Group_id > 0)
                {
                    sb.AppendFormat(" AND {0}={1} ", nameof(RB_Dictvalue_Extend.RB_Group_id), where.RB_Group_id);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" AND {0}={1} ", nameof(RB_Dictvalue_Extend.MallBaseId), where.MallBaseId);
                }
                if (!string.IsNullOrEmpty(where.DictKey))
                {
                    sb.AppendFormat(" AND {0}='{1}' ", nameof(RB_Dictvalue_Extend.DictKey), where.DictKey.Trim());
                }
                if (!string.IsNullOrEmpty(where.QDictKeys))
                {
                    sb.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Dictvalue_Extend.DictKey), where.QDictKeys.Trim());
                }
            }
            return Get<RB_Dictvalue_Extend>(sb.ToString()).ToList();
        }
    }
}