﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    public class RB_Education_EduSellRepository : BaseRepository<RB_Education_EduSell>
    {
        /// <summary>
        /// 获取教育销售的基础信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_EduSell_Extend> GetEducationSellBaseInfo(RB_Education_EduSell_Extend query)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Education_EduSell
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.Type), 1);
            if (query == null)
            {
                return new List<RB_Education_EduSell_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.UserId), query.UserId);
                }
                if (query.EduSellId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.EduSellId), query.EduSellId);
                }
                if (!string.IsNullOrEmpty(query.EduSellIds))
                {
                    builder.AppendFormat(" AND {0} in({1}) ", nameof(RB_Education_EduSell_Extend.EduSellId), query.EduSellIds);
                }
                if (!string.IsNullOrWhiteSpace(query.Ids))
                {
                    builder.AppendFormat($@" AND { nameof(RB_Education_EduSell_Extend.UserId)} in ({query.Ids}) ");
                }
            }
            return Get<RB_Education_EduSell_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取教育学生的绑定信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_EduSell_Extend> GetEducationStuList(RB_Education_EduSell_Extend query, bool IsAll = false)
        {

            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Education_EduSell
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.Status), (int)DateStateEnum.Normal);
            if (IsAll == false)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.Type), 2);
            }
            if (query == null)
            {
                return new List<RB_Education_EduSell_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.UserId), query.UserId);
                }
                if (query.EduSellId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.EduSellId), query.EduSellId);
                }
                if (!string.IsNullOrWhiteSpace(query.Ids))
                {
                    builder.AppendFormat($@" AND { nameof(RB_Education_EduSell_Extend.UserId)} in ({query.Ids}) ");
                }
                if (query.IsInitFreeCoffee == 1)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_EduSell_Extend.IsInitFreeCoffee), 0);
                }
            }
            return Get<RB_Education_EduSell_Extend>(builder.ToString()).ToList();
        }
    }
}
