﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单日志仓储层
    /// </summary>
    public class RB_OrderGoods_LogRepository : BaseRepository<RB_OrderGoods_Log>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_OrderGoods_Log_Extend> GetList(RB_OrderGoods_Log_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_OrderGoods_Log_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_OrderGoods_Log_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_OrderGoods_Log_Extend.Type)}={dmodel.Type}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and {nameof(RB_OrderGoods_Log_Extend.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.OrderDetailId > 0)
            {
                where += $@" and {nameof(RB_OrderGoods_Log_Extend.OrderDetailId)}={dmodel.OrderId}";
            }
            if (dmodel.CreateBy > 0)
            {
                where += $@" and {nameof(RB_OrderGoods_Log_Extend.CreateBy)}={dmodel.CreateBy}";
            }
            string sql = $@"SELECT * FROM RB_Goods_Log where {where} order by Id asc";
            return Get<RB_OrderGoods_Log_Extend>(sql).ToList();
        }
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_OrderGoods_Log_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_OrderGoods_Log_Extend dmodel)
        {
            string where = $" where 1=1 and c.{nameof(RB_Goods_Order.Status)}=0";

            if (dmodel.TenantId > 0)
            {
                where += $@" and a.{nameof(RB_OrderGoods_Log_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and a.{nameof(RB_OrderGoods_Log_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and a.{nameof(RB_OrderGoods_Log_Extend.Id)}={dmodel.Id}";
            }

            if (!string.IsNullOrWhiteSpace(dmodel.StartDate))
            {
                where += $" and  DATE_FORMAT(a.{nameof(RB_OrderGoods_Log_Extend.CreateDate)},'%Y-%m-%d' )>=DATE_FORMAT('{dmodel.StartDate}','%Y-%m-%d' ) ";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.EndDate))
            {
                where += $" and  DATE_FORMAT(a.{nameof(RB_OrderGoods_Log_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{dmodel.EndDate}','%Y-%m-%d' ) ";
            }

            if (!string.IsNullOrWhiteSpace(dmodel.OrderStartDate))
            {
                where += $" and  DATE_FORMAT(c.{nameof(RB_Goods_Order.CreateDate)},'%Y-%m-%d' )>=DATE_FORMAT('{dmodel.OrderStartDate}','%Y-%m-%d' ) ";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.OrderEndDate))
            {
                where += $" and  DATE_FORMAT(c.{nameof(RB_Goods_Order.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{dmodel.OrderEndDate}','%Y-%m-%d' ) ";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and c.{nameof(RB_Goods_Order.OrderNo)} like '%{dmodel.OrderNo}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and b.{nameof(RB_Goods_OrderDetail.GoodsName)} like '%{dmodel.GoodsName}%'";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and a.{nameof(RB_Material_Info.Type)}={dmodel.Type}";
            }

            string sql = $@"SELECT a.*,b.GoodsName,c.OrderNo,d.EmpName from rb_ordergoods_log as a 
LEFT JOIN rb_goods_orderdetail as b on a.OrderDetailId=b.Id
LEFT JOIN rb_goods_order as c on a.OrderId=c.OrderId
LEFT JOIN rb_employee as d on a.CreateBy=d.EmpId {where} order by Id desc";
            return GetPage<RB_OrderGoods_Log_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

       
    }
}
