﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Finance;
using VT.FW.DB;

namespace Mall.Model.Extend.Finance
{
    /// <summary>
    /// 财务单据明细实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_FinanceDetail_Extend: RB_FinanceDetail
    {
        #region 扩展属性
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string CostIds { get; set; }
        /// <summary>
        /// 单据ID集合
        /// </summary>
        public string FrIds { get; set; }
        /// <summary>
        /// 费用id集合
        /// </summary>
        public string FdIds { get; set; }
        /// <summary>
        /// 费用类型
        /// </summary>
        public string CostTypeName { get; set; }
        /// <summary>
        /// 币种
        /// </summary>
        public string CurrencyName { get; set; }

        /// <summary>
        /// 支付总金额
        /// </summary>
        public decimal? PayMoney { get; set; }
        /// <summary>
        /// 手续费
        /// </summary>
        public decimal? Fee { get; set; }

        /// <summary>
        /// 制单人
        /// </summary>
        public int? CreateBy { get; set; }



        /// <summary>
        /// 制单人
        /// </summary>
        public string CreateByStr { get; set; }


        /// <summary>
        /// 制单日期
        /// </summary>
        public DateTime? CreateDate { get; set; }
        /// <summary>
        /// 所属公司
        /// </summary>
        public int? BranchId { get; set; }
        /// <summary>
        /// 公司名称
        /// </summary>
        public string BranchIdName { get; set; }
        /// <summary>
        /// 集团id
        /// </summary>
        public int? GroupId { get; set; }

        /// <summary>
        /// 凭证实体
        /// </summary>
        public List<RB_Voucher_Extend> vorcherInos { get; set; }
        /// <summary>
        /// 1-收入2-支出
        /// </summary>
        public int? Type
        {
            get; set;
        }
        /// <summary>
        /// 流水号
        /// </summary>
        public string AccountNumber
        {
            get; set;
        }
        /// <summary>
        /// 开户人
        /// </summary>
        public string AccountHolder { get; set; }
        #endregion

        #region 2019-03-28 Add by:W
        /// <summary>
        /// 挂账专用
        /// </summary>
        public string TCNUM { get; set; }

        /// <summary>
        /// 0-私账1-公账2-人民币现金3-外币现金
        /// </summary>
        public int? IsPublic
        {
            get; set;
        }
        #endregion

        /// <summary>
        /// 模板id
        /// </summary>
        public int TemplateId { get; set; }

        /// <summary>
        /// 1-追加团款，0-正常制单
        /// </summary>
        public int OtherType { get; set; }
    }
}
