﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    public class RB_BrandRepository : BaseRepository<RB_Brand>
    {
        /// <summary>
        /// 获取品牌信息分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Extend> GetBrandPageList(int pageIndex, int pageSize, out long rowsCount, RB_Brand_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ClassName from rb_brand as a LEFT JOIN rb_brandclass as b on a.BrandClassId=b.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Brand_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.UserId), query.UserId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Brand_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.BrandClassId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.BrandClassId), query.BrandClassId);
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.ProjectType), (int)query.ProjectType);
                }

                if (query.RanQi > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.RanQi), query.RanQi);
                }
                if (query.KongTiao > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.KongTiao), query.KongTiao);
                }
                if (query.XinFeng > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.XinFeng), query.XinFeng);
                }
                if (query.Plumbing > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Plumbing), query.Plumbing);
                }
                if (query.Caliber > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Caliber), query.Caliber);
                }
                if (query.Sewage > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Sewage), query.Sewage);
                }
                if (query.PaiYan > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.PaiYan), query.PaiYan);
                }
                if (!string.IsNullOrEmpty(query.DianLiang))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @DianLiang ", nameof(RB_Brand_Extend.DianLiang));
                    parameters.Add("DianLiang", "%" + query.DianLiang.Trim() + "%");
                }
            }
            return GetPage<RB_Brand_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Brand_Extend GetBrand(RB_Brand_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ClassName from rb_brand as a LEFT JOIN rb_brandclass as b on a.BrandClassId=b.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new RB_Brand_Extend();
            }
            else
            {
                if (query.ID > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.ID), query.ID);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Brand_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.BrandClassId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.BrandClassId), query.BrandClassId);
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.ProjectType), (int)query.ProjectType);
                }
               
            }
            return Get<RB_Brand_Extend>(builder.ToString(), parameters).FirstOrDefault();
        }


        /// <summary>
        /// 根据查询条件获取品牌信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Extend> GetBrandListByWhere(RB_Brand_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ClassName from rb_brand as a LEFT JOIN rb_brandclass as b on a.BrandClassId=b.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Brand_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Brand_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.BrandClassId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.BrandClassId), query.BrandClassId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.UserId), query.UserId);
                }
                if (query.UserId == -1)
                {
                    builder.AppendFormat(" AND a.{0} =0 ", nameof(RB_Brand_Extend.UserId));//查询未绑定用户的
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.ProjectType), (int)query.ProjectType);
                }

                if (query.RanQi > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.RanQi), query.RanQi);
                }
                if (query.KongTiao > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.KongTiao), query.KongTiao);
                }
                if (query.XinFeng > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.XinFeng), query.XinFeng);
                }
                if (query.Plumbing > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Plumbing), query.Plumbing);
                }
                if (query.Caliber > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Caliber), query.Caliber);
                }
                if (query.Sewage > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Sewage), query.Sewage);
                }
                if (query.PaiYan > -1)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.PaiYan), query.PaiYan);
                }
                if (!string.IsNullOrEmpty(query.DianLiang))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @DianLiang ", nameof(RB_Brand_Extend.DianLiang));
                    parameters.Add("DianLiang", "%" + query.DianLiang.Trim() + "%");
                }
            }
            return Get<RB_Brand_Extend>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取品牌列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Brand_Extend> GetBrandList(RB_Brand_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ClassName from rb_brand as a LEFT JOIN rb_brandclass as b on a.BrandClassId=b.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_Brand_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Brand_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Brand_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.BrandClassId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.BrandClassId), query.BrandClassId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.UserId), query.UserId);
                }
                if (query.UserId == -1)
                {
                    builder.AppendFormat(" AND a.{0} =0 ", nameof(RB_Brand_Extend.UserId));//查询未绑定用户的
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Brand_Extend.ProjectType), (int)query.ProjectType);
                }
               

            }
            if (query.QOrderBy == 2)
            {
                builder.AppendFormat(" ORDER BY a.{0} DESC  ", nameof(RB_Brand_Extend.ID));
            }
            if (query.QTop > 0)
            {
                builder.AppendFormat(" LIMIT {0}  ", query.QTop);
            }
            return Get<RB_Brand_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
