﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 小程序用户中心配置实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_MiniProgram_UserCenterConfig
    {
        /// <summary>
        /// 主键Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 商户Id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序Id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 默认背景图
        /// </summary>
        public string DefaultBgImg { get; set; }

        /// <summary>
        /// 普通用户背景
        /// </summary>
        public string MemberBgImg { get; set; }

        /// <summary>
        /// 会员中心背景
        /// </summary>
        public string VipBgImg { get; set; }

        /// <summary>
        /// 头像样式类型(1-头像靠左，2-头像居中，3-头像内嵌)
        /// </summary>
        public int HeadStyle { get; set; }

        /// <summary>
        /// 头像样式字符串
        /// </summary>
        public string HeadStyleStr { get; set; }

        /// <summary>
        /// 是否显示收藏夹(0-显示，1-不显示)
        /// </summary>
        public int IsShowFavorite { get; set; }

        /// <summary>
        /// 我的收藏图片
        /// </summary>
        public string MyFavoriteImg { get; set; }

        /// <summary>
        /// 我的足迹图片
        /// </summary>
        public string MyFootPrintImg { get; set; }

        /// <summary>
        /// 是否显示订单栏(0-显示，1-不显示)
        /// </summary>
        public int IsShowOrderNav { get; set; }

        /// <summary>
        /// 待付款图片
        /// </summary>
        public string NoPayImg { get; set; }

        /// <summary>
        /// 待发货图片
        /// </summary>
        public string NoDeliveryImg { get; set; }

        /// <summary>
        /// 待收货图片
        /// </summary>
        public string NoReciveImg { get; set; }

        /// <summary>
        /// 待评价图片
        /// </summary>
        public string NoEvaluation { get; set; }

        /// <summary>
        /// 售后图片
        /// </summary>
        public string AfterSales { get; set; }

        /// <summary>
        /// 是否显示账户栏(0-显示，1-不显示)
        /// </summary>
        public int IsShowAccountNav { get; set; }

        /// <summary>
        /// 积分自定义名称
        /// </summary>
        public string IntegralName { get; set; }

        /// <summary>
        /// 积分图片
        /// </summary>
        public string IntegralImg { get; set; }

        /// <summary>
        /// 余额自定义名称
        /// </summary>
        public string BalanceName { get; set; }

        /// <summary>
        /// 余额自定义图片
        /// </summary>
        public string BalanceImg { get; set; }

        /// <summary>
        /// 优惠券自定义名称
        /// </summary>
        public string CouponsName { get; set; }

        /// <summary>
        /// 优惠券自定义图片
        /// </summary>
        public string CouponsImg { get; set; }

        /// <summary>
        /// 卡券名称
        /// </summary>
        public string CardName { get; set; }

        /// <summary>
        /// 卡券图片
        /// </summary>
        public string CardImg { get; set; }

        /// <summary>
        /// 是否显示菜单栏(0-显示，1-不显示)
        /// </summary>
        public int IsShowMenuNav { get; set; }

        /// <summary>
        /// 菜单栏标题
        /// </summary>
        public string MenuNavTitle { get; set; }

        /// <summary>
        /// 菜单栏样式(0-列表,1-九宫格)
        /// </summary>
        public int MenuNavStyle { get; set; }

        /// <summary>
        /// 菜单栏JSON数据
        /// </summary>
        public string MenuNavJson { get; set; }
    }
}
