﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品仓储层
    /// </summary>
    public class RB_GoodsRepository : RepositoryBase<RB_Goods>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and g.{nameof(RB_Goods_Extend.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.GoodsStatus > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.IsSelectSellOut == 1) {
                where += $@" and g.{nameof(RB_Goods_Extend.InventoryNum)}<=0";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds)) {
                where += $@" and c.{nameof(RB_Goods_Category.CategoryId)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime)) {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }
            
            string sql = $@"select g.* from RB_Goods g
inner join rb_goods_category c on g.Id=c.GoodsId 
where {where} group by g.Id order by g.CreateDate desc";
            return GetPage<RB_Goods_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetList(RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and g.{nameof(RB_Goods_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.GoodsStatus > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.IsSelectSellOut == 1)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.InventoryNum)}<=0";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds))
            {
                where += $@" and c.{nameof(RB_Goods_Category.CategoryId)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }

            string sql = $@"select g.* from RB_Goods g
inner join rb_goods_category c on g.Id=c.GoodsId 
where {where} group by g.Id order by g.CreateDate desc";
            return Get<RB_Goods_Extend>(sql).ToList();
        }
    }
}
