﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联规格值仓储层
    /// </summary>
    public class RB_Goods_SpecificationValueRepository : RepositoryBase<RB_Goods_SpecificationValue>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_SpecificationValue_Extend> GetList(RB_Goods_SpecificationValue_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Goods_SpecificationValue.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.Id)}={dmodel.Id}";
            }
            if (dmodel.SpecificationId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.SpecificationId)}={dmodel.SpecificationId}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"select * from RB_Goods_SpecificationValue where {where} order by Id desc";
            return Get<RB_Goods_SpecificationValue_Extend>(sql).ToList();
        }
    }
}
