﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// 会员优惠券仓储层
    /// </summary>
   public class RB_Member_CouponRepository:RepositoryBase<RB_Member_DiscountCoupon>
    {
        public string MemberTableName { get { return nameof(RB_Member_User); } }
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Member_DiscountCoupon); } }


        /// <summary>
        /// 会员优惠券
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_DiscountCoupon_Extend> GetIntegraStatisticslList(int pageIndex, int pageSize, out long rowCount, RB_Member_DiscountCoupon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PlatformType > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.PlatformType)}={query.PlatformType}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.UserId)}={query.UserId}");
                }
                //if (!string.IsNullOrWhiteSpace(query.StartDate))
                //{
                //    builder.Append($" AND DATE_FORMAT({nameof(RB_Member_Coupon_Extend.CreateDate)},'%Y-%m-%d' )>= DATE_FORMAT('{nameof(RB_Member_Coupon_Extend.StartDate)}','%Y-%m-%d' )");
                //}
                //if (!string.IsNullOrWhiteSpace(query.EndDate))
                //{
                //    builder.Append($" AND DATE_FORMAT({nameof(RB_Member_Coupon_Extend.CreateDate)},'%Y-%m-%d' )<= DATE_FORMAT('{nameof(RB_Member_Coupon_Extend.EndDate)}','%Y-%m-%d' )");
                //}
            }
            string sql = @$" select * from {TableName} where 1=1 {builder.ToString()} ";
            return GetPage<RB_Member_DiscountCoupon_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }


        /// <summary>
        /// 会员优惠券
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_DiscountCoupon_Extend> GetExportIntegraStatisticslList(RB_Member_DiscountCoupon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PlatformType > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.PlatformType)}={query.PlatformType}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND {nameof(RB_Member_DiscountCoupon_Extend.UserId)}={query.UserId}");
                }
            }
            string sql = @$" select * from {TableName} where 1=1 {builder.ToString()} ";
            return Get<RB_Member_DiscountCoupon_Extend>(sql).ToList();
        }
    }
}
