﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商户用户仓储层
    /// </summary>
    public class RB_Member_UserRepository : RepositoryBase<RB_Member_User>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_User_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Member_User.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Member_User.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Member_User.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Member_User.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.AliasName)) {
                where += $@" and {nameof(RB_Member_User.AliasName)} like '%{dmodel.AliasName}%'";
            }
            if (dmodel.Source > 0) {
                where += $@" and {nameof(RB_Member_User.Source)} ={(int)dmodel.Source}";
            }
            if (!string.IsNullOrEmpty(dmodel.Moblie)) {
                where += $@" and {nameof(RB_Member_User.Moblie)} like '%{dmodel.Moblie}%'";
            }
            if (dmodel.MemberGrade > 0) {
                where += $@" and {nameof(RB_Member_User.MemberGrade)}={dmodel.MemberGrade}";
            }
            if (dmodel.SuperiorId > 0) {
                where += $@" and {nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }
            string sql = $@"
select * from RB_Member_User where {where} order by CreateDate desc
";
            return GetPage<RB_Member_User_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetList(RB_Member_User_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_User.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_User.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Member_User.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.AliasName))
            {
                where += $@" and {nameof(RB_Member_User.AliasName)} like '%{dmodel.AliasName}%'";
            }
            if (dmodel.Source > 0)
            {
                where += $@" and {nameof(RB_Member_User.Source)} ={(int)dmodel.Source}";
            }
            if (!string.IsNullOrEmpty(dmodel.Moblie))
            {
                where += $@" and {nameof(RB_Member_User.Moblie)} like '%{dmodel.Moblie}%'";
            }
            if (dmodel.MemberGrade > 0)
            {
                where += $@" and {nameof(RB_Member_User.MemberGrade)}={dmodel.MemberGrade}";
            }
            if (dmodel.SuperiorId > 0)
            {
                where += $@" and {nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }
            if (!string.IsNullOrEmpty(dmodel.UserIds)) {
                where += $@" and {nameof(RB_Member_User.Id)} in({dmodel.UserIds})";
            }

            string sql = $@"
select * from RB_Member_User where {where} order by CreateDate desc
";
            return Get<RB_Member_User_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取下拉列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserDropDownList(int pageIndex, int pageSize, out long count, RB_Member_User_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_User.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_User.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Member_User.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Member_User.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.AliasName))
            {
                where += $@" and {nameof(RB_Member_User.AliasName)} like '%{dmodel.AliasName}%'";
            }
            if (dmodel.Source > 0)
            {
                where += $@" and {nameof(RB_Member_User.Source)} ={(int)dmodel.Source}";
            }
            if (!string.IsNullOrEmpty(dmodel.Moblie))
            {
                where += $@" and {nameof(RB_Member_User.Moblie)} like '%{dmodel.Moblie}%'";
            }
            if (dmodel.MemberGrade > 0)
            {
                where += $@" and {nameof(RB_Member_User.MemberGrade)}={dmodel.MemberGrade}";
            }
            if (dmodel.SuperiorId > 0)
            {
                where += $@" and {nameof(RB_Member_User.SuperiorId)}={dmodel.SuperiorId}";
            }
            if (dmodel.IsDistributor > 0) 
            {
                where += $@" and {nameof(RB_Member_User.IsDistributor)}={dmodel.IsDistributor}";
            }
            string sql = $@"select Id,Name,AliasName from RB_Member_User where {where} order by CreateDate desc";
            return GetPage<RB_Member_User_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 需更新该等级下的用户等级
        /// </summary>
        /// <param name="GradeId"></param>
        /// <param name="DefaultGId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        public bool UpdateMemberGrade(int GradeId, int DefaultGId, int tenantId, int mallBaseId)
        {
            string sql = $@" update RB_Member_User set MemberGrade={DefaultGId} where MemberGrade={GradeId} and TenantId={tenantId} and MallBaseId={mallBaseId}";
            return Execute(sql) > 0;
        }

        /// <summary>
        /// 获取下线分销商数量
        /// </summary>
        /// <param name="uids"></param>
        /// <param name="tier"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetDistributorReferralsNum(string uids, int tier, int tenantId, int mallBaseId)
        {
            if (tier == 1)
            {
                string sql = $@"SELECT u.SuperiorId,COUNT(0) AS ReferralsNum FROM rb_member_user u 
WHERE u.TenantId={tenantId} and u.MallBaseId={mallBaseId} and u.SuperiorId in ({uids}) GROUP BY u.SuperiorId";
                return Get<RB_Member_User_Extend>(sql).ToList();
            }
            else if (tier == 2)
            {
                string sql = $@"SELECT u.SuperiorId,COUNT(0) AS ReferralsNum FROM rb_member_user u 
INNER JOIN rb_member_user u1 on u.Id=u1.SuperiorId
WHERE u.TenantId={tenantId} and u.MallBaseId={mallBaseId} and u.SuperiorId in ({uids}) GROUP BY u.SuperiorId";
                return Get<RB_Member_User_Extend>(sql).ToList();
            }
            else if (tier == 3) {
                string sql = $@"SELECT u.SuperiorId,COUNT(0) AS ReferralsNum FROM rb_member_user u 
INNER JOIN rb_member_user u1 on u.Id=u1.SuperiorId
INNER JOIN rb_member_user u2 on u1.Id=u2.SuperiorId
WHERE u.TenantId={tenantId} and u.MallBaseId={mallBaseId} and u.SuperiorId in ({uids}) GROUP BY u.SuperiorId";
                return Get<RB_Member_User_Extend>(sql).ToList();
            }
            return new List<RB_Member_User_Extend>();
        }

        /// <summary>
        /// 获取下级用户列表
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="referralsType"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetDistributorReferralsPageList(int? userId, int? referralsType, int tenantId, int mallBaseId)
        {
            if (referralsType == 1)
            {
                string sql = $@"SELECT u.* FROM rb_member_user u 
WHERE u.TenantId={tenantId} and u.MallBaseId={mallBaseId} and u.SuperiorId ={userId} order by u.CreateDate asc";
                return Get<RB_Member_User_Extend>(sql).ToList();
            }
            else if (referralsType == 2)
            {
                string sql = $@"SELECT u1.* FROM rb_member_user u 
INNER JOIN rb_member_user u1 on u.Id=u1.SuperiorId
WHERE u.TenantId={tenantId} and u.MallBaseId={mallBaseId} and u.SuperiorId ={userId} order by u1.CreateDate asc";
                return Get<RB_Member_User_Extend>(sql).ToList();
            }
            else if (referralsType == 3)
            {
                string sql = $@"SELECT u2.* FROM rb_member_user u 
INNER JOIN rb_member_user u1 on u.Id=u1.SuperiorId
INNER JOIN rb_member_user u2 on u1.Id=u2.SuperiorId
WHERE u.TenantId={tenantId} and u.MallBaseId={mallBaseId} and u.SuperiorId ={userId} order by u2.CreateDate asc";
                return Get<RB_Member_User_Extend>(sql).ToList();
            }
            return new List<RB_Member_User_Extend>();
        }
    }
}
