﻿using Mall.Model.Entity.MarketingCenter;
using System;
using System.Collections.Generic;
using VT.FW.DB;

namespace Mall.Model.Extend.MarketingCenter
{
    /// <summary>
    /// 分享详情扩展实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Share_Friend_Extend : RB_Share_Friend
    {
        /// <summary>
        /// 关键字
        /// </summary>
        public string KeyWords { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>
        public string QStartDate { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public string QEndDate { get; set; }

        /// <summary>
        /// 分类Ids【逗号分割】
        /// </summary>
        public string CateIds { get; set; }

        /// <summary>
        /// 创建时间字符串
        /// </summary>
        public string CreateDateStr
        {
            get
            {
                return Convert.ToDateTime(this.CreateDate).ToString("yyyy-MM-dd HH:mm:ss");
            }
        }

        /// <summary>
        /// 分类列表
        /// </summary>
        public List<RB_Share_Category_Extend> CateList { get; set; }

        /// <summary>
        /// 图片数组
        /// </summary>
        public List<string> ImgList
        {
            get
            {
                List<string> imgList = new List<string>();
                if (!string.IsNullOrWhiteSpace(this.MaterialImg))
                {
                    imgList = Common.Plugin.JsonHelper.DeserializeObject<List<string>>(this.MaterialImg);
                }
                return imgList;
            }
        }

        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }
    }
}