﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// Vip购买表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Vip_Buy
    {
        /// <summary>
        /// 编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 单号
        /// </summary>
        public string OrderNo { get; set; }

        /// <summary>
        /// 商户单号
        /// </summary>
        public string MerchantsNo { get; set; }


        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }



        /// <summary>
        /// 购买等级id
        /// </summary>
        public int GradeId { get; set; }

        /// <summary>
        /// 等级名称
        /// </summary>
        public string GradeName { get; set; }

        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal Money { get; set; }

        /// <summary>
        /// 支付状态 0-未支付，1-已支付
        /// </summary>
        public int PayState { get; set; }

        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime? PayTime { get; set; }

        /// <summary>
        /// 支付类型 枚举  1微信  2支付宝   3银行卡 
        /// </summary>
        public int PayWay { get; set; }

        /// <summary>
        /// 到期时间(同步分销商vip到期时间)
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// 购买备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 关联订单id
        /// </summary>
        public int? ReOrderId { get; set; }
        /// <summary>
        /// 关联订单号
        /// </summary>
        public string ReOrderNum { get; set; }
    }
}
