﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 素材管理仓储层
    /// </summary>
    public class RB_Material_GroupRepository : RepositoryBase<RB_Material_Group>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Material_Group_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Material_Group_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Material_Group.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Material_Group.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Material_Group.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Material_Group.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Material_Group.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Type > 0) {
                where += $@" and {nameof(RB_Material_Group.Type)}={dmodel.Type}";
            }
            if (dmodel.Recycled > 0) {
                where += $@" and {nameof(RB_Material_Group.Recycled)}={dmodel.Recycled}";
            }
            string sql = $@"select * from RB_Material_Group where {where} order by Id desc";
            return GetPage<RB_Material_Group_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Material_Group_Extend> GetList(RB_Material_Group_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Material_Group.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Material_Group.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Material_Group.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Material_Group.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GroupIds)) {
                where += $@" and {nameof(RB_Material_Group.Id)} in({dmodel.GroupIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Material_Group.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Material_Group.Type)}={dmodel.Type}";
            }
            if (dmodel.Recycled > 0)
            {
                where += $@" and {nameof(RB_Material_Group.Recycled)}={dmodel.Recycled}";
            }
            string sql = $@"select * from RB_Material_Group where {where} order by Sort,Id desc";
            return Get<RB_Material_Group_Extend>(sql).ToList();
        }
    }
}
