﻿using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Extend.BaseSetUp;
using Mall.Common.Enum;

namespace Mall.Repository.BaseSetUp
{
    /// <summary>
    /// 地区表仓储层
    /// </summary>
    public partial class Rb_destinationRepository : RepositoryBase<RB_Destination>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Destination); } }

        /// <summary>
        /// 获取所有的地区数据
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetListExt(RB_Destination_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("SELECT * FROM {0} WHERE 1=1 ", TableName);
            sb.AppendFormat(" AND {0}={1} ", nameof(RB_Destination_Extend.Status), (int)Common.Enum.DateStateEnum.Normal);
            if (where != null)
            {
                if (where.CodeLevel > 0)
                {
                    sb.AppendFormat(" AND {0}={1}", nameof(RB_Destination_Extend.CodeLevel), (int)where.CodeLevel);
                }
                if (where.ParentID > 0)
                {
                    sb.AppendFormat(" AND {0}={1} ", nameof(RB_Destination_Extend.ParentID), where.ParentID);
                }
                if (where.QArea != null && !string.IsNullOrEmpty(where.QArea))
                {
                    var QArea = Common.ConvertHelper.ConvertInt(where.QArea);
                    if (QArea > 0)
                    {
                        sb.AppendFormat(" AND FIND_IN_SET({0},{1})  ", QArea, nameof(RB_Destination_Extend.Area));
                    }
                }
                if (where.Name != null && !string.IsNullOrEmpty(where.Name.Trim()))
                {
                    sb.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Destination_Extend.Name), where.Name.Trim());
                }
                if (!string.IsNullOrEmpty(where.NameStr))
                {
                    sb.AppendFormat(" AND {0} in({1})", nameof(RB_Destination_Extend.Name), where.NameStr);
                }
            }
            return Get<RB_Destination_Extend>(sb.ToString()).ToList();
        }

        /// <summary>
        /// 根据地区名称获取地区列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetListByNames(string[] where)
        {
            StringBuilder sbWhere = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("SELECT * FROM {0} WHERE 1=1 ", TableName);
            if (where != null && where.Length > 0)
            {
                var index = 0;
                foreach (var item in where)
                {
                    if (!string.IsNullOrEmpty(item.Trim()))
                    {
                        if (index == 0)
                        {
                            sbWhere.AppendFormat(" {0} LIKE '{1}%' ", nameof(RB_Destination_Extend.Name), item.Trim());
                        }
                        else
                        {
                            sbWhere.AppendFormat("  OR {0} LIKE '{1}%' ", nameof(RB_Destination_Extend.Name), item.Trim());
                        }
                        index++;
                    }
                }
            }
            if (!string.IsNullOrEmpty(sbWhere.ToString()))
            {
                sb.AppendFormat(" AND ({0}) ", sbWhere.ToString());
            }
            return Get<RB_Destination_Extend>(sb.ToString()).ToList();
        }


        /// <summary>
        /// 获取地区列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetAllDestinationList()
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("SELECT * FROM {0} WHERE 1=1 ", TableName);
            sb.AppendFormat(" AND {0}={1} ", nameof(RB_Destination_Extend.Status), (int)Common.Enum.DateStateEnum.Normal);
            List<RB_Destination_Extend> list = Get<RB_Destination_Extend>(sb.ToString()).ToList();
            return list;
        }

        /// <summary>
        /// 根据id 获取所有数据
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public List<RB_Destination> GetDictvalueListForIds(string Ids)
        {
            if (!string.IsNullOrEmpty(Ids))
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendFormat("SELECT * FROM {0}  ", TableName);
                sb.Append(" WHERE 1=1 ");
                sb.AppendFormat(" AND {0}={1} ", nameof(RB_Destination_Extend.Status), (int)Common.Enum.DateStateEnum.Normal);
                sb.AppendFormat(" AND Id in({0})", Ids.TrimStart(',').TrimEnd(','));
                return base.Get(sb.ToString()).ToList();
            }
            return new List<RB_Destination>();
        }
    }
}