﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Plugin;

namespace Mall.Common.Enum.Education
{
    /// <summary>
    /// 财务流程费用配置枚举
    /// </summary>
    public enum FinanceConfigTypeEnum
    {
        /// <summary>
        /// 教师课时费
        /// </summary>
        [EnumField("教师课时费")]
        ClassFees = 1,

        /// <summary>
        /// 教师绩效
        /// </summary>
        [EnumField("教师绩效")]
        Perf = 2,

        /// <summary>
        /// 学生退课
        /// </summary>
        [EnumField("学生退课")]
        DropCourse = 3,

        /// <summary>
        /// 资产采购
        /// </summary>
        [EnumField("资产采购")]
        AssetPurchase = 4,
        /// <summary>
        /// 耗材采购
        /// </summary>
        [EnumField("耗材采购")]
        SuppliesPurchase = 5,
        /// <summary>
        /// 耗材成本
        /// </summary>
        [EnumField("耗材成本")]
        SuppliesCost = 6,
        /// <summary>
        /// 耗材出库
        /// </summary>
        [EnumField("耗材出库")]
        SuppliesStockOut = 7,
        /// <summary>
        /// 学费收入
        /// </summary>
        [EnumField("学费收入")]
        Tuition = 8,
        /// <summary>
        /// 活动收入（电商）
        /// </summary>
        [EnumField("活动收入")]
        ActivityIncome = 9,

        /// <summary>
        /// 活动退款（电商）
        /// </summary>
        [EnumField("活动退款")]
        ActivityExpenditure = 10,

    }
}
