﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 品牌申请仓储
    /// </summary>
    public class RB_BrandApplyForRepository : BaseRepository<RB_BrandApplyFor>
    {

        /// <summary>
        /// 根据查询条件获取品牌信息实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_BrandApplyFor_Extend GetBrand(RB_BrandApplyFor_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ClassName from RB_BrandApplyFor as a LEFT JOIN rb_brandclass as b on a.BrandClassId=b.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_BrandApplyFor_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new RB_BrandApplyFor_Extend();
            }
            else
            {
                if (query.ID > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.ID), query.ID);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_BrandApplyFor_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.BrandClassId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.BrandClassId), query.BrandClassId);
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.ProjectType), (int)query.ProjectType);
                }
                if (query.CompanyId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.CompanyId), query.CompanyId);
                }
            }
            return Get<RB_BrandApplyFor_Extend>(builder.ToString(), parameters).FirstOrDefault();
        }


        /// <summary>
        /// 根据查询条件获取品牌信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_BrandApplyFor_Extend> GetBrandListByWhere(RB_BrandApplyFor_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ClassName from RB_BrandApplyFor as a LEFT JOIN rb_brandclass as b on a.BrandClassId=b.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_BrandApplyFor_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_BrandApplyFor_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.BrandName))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_BrandApplyFor_Extend.BrandName));
                    parameters.Add("Name", "%" + query.BrandName.Trim() + "%");
                }
                if (query.BrandClassId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.BrandClassId), query.BrandClassId);
                }
                if (query.CompanyId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.CompanyId), query.CompanyId);
                }
                if (query.ProjectType.HasValue && query.ProjectType > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_BrandApplyFor_Extend.ProjectType), (int)query.ProjectType);
                }
            }
            return Get<RB_BrandApplyFor_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
