﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 老师动态仓储
    /// </summary>
    public class Rb_Education_DynamicRepository : BaseRepository<Rb_Education_Dynamic>
    {
        /// <summary>
        /// 老师动态列表
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> DynamicList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            string where = " where a.`Status`=0  and a.IsOpen=1";
            string likeWhere = "";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and a.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and a.MallBaseId = {model.MallBaseId} ";
                }
                if (model.UserTeacher > 0)
                {
                    where += $@" and a.UserTeacher = {model.UserTeacher} ";
                }
                if (model.Id > 0)
                {
                    where += $@" and a.Id = {model.Id} ";
                }
                if (model.CreateBy > 0)
                {
                    where += $@" and a.CreateBy = {model.CreateBy} ";
                }
                if (model.UserId > 0)
                {
                    likeWhere += $@" and l.UserId = {model.UserId} ";
                }
            }
            string sql = $@"SELECT t.*,if(l.Id>0,1,0) as HasLike,e.`Name` as CreateByName,e.TeacherLogo as CrearteByPhoto
                                from (SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status` from 
                                Rb_Education_Dynamic a {where} ) as t 
                                LEFT JOIN rb_education_dynamiclike l on l.ArticleId = t.id  {likeWhere}
                                LEFT JOIN rb_education_teacher e on e.Id = t.UserTeacher 
                                ORDER BY t.CreateTime DESC";
            return GetPage<Rb_Education_Dynamic_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
        /// <summary>
        /// 老师动态列表
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> DynamicOpenList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            string where = "  and a.`Status`=0 ";
            string likeWhere = "";
            string followWhere = "";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and a.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and a.MallBaseId = {model.MallBaseId} ";
                }
                if (model.Id > 0)
                {
                    where += $@" and a.Id = {model.Id} ";
                }
                if (model.UserTeacher > 0)
                {
                    where += $@" and a.UserTeacher = {model.UserTeacher} ";
                }

                if (model.CreateBy > 0)
                {
                    where += $@" and a.CreateBy = {model.CreateBy} ";
                }
                if (model.UserId > 0)
                {
                    likeWhere += $@" and l.UserId = {model.UserId} ";
                    followWhere += $@" and b.UserId = {model.UserId} and b.`Status`=0 ";
                }
            }
            string sql = $@"SELECT t.*,if(l.Id>0,1,0) as HasLike,e.`Name` as CreateByName,e.TeacherLogo as CrearteByPhoto
                                from (SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status` from 
                                Rb_Education_Dynamic a  where a.IsOpen=1 {where}
union all SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status` from 
                                Rb_Education_Dynamic a LEFT JOIN rb_education_followteacher as b on a.UserTeacher=b.TeacherId  where a.IsOpen=2 {where} {followWhere} ) as t 
                                LEFT JOIN rb_education_dynamiclike l on l.ArticleId = t.id  {likeWhere}
                                LEFT JOIN rb_education_teacher e on e.Id = t.UserTeacher 
                                ORDER BY t.CreateTime DESC";
            return GetPage<Rb_Education_Dynamic_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }



        /// <summary>
        /// 我的动态列表
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> MyDynamicList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            string where = " where a.`Status`=0 ";
            string likeWhere = "";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and a.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and a.MallBaseId = {model.MallBaseId} ";
                }
                if (model.UserTeacher > 0)
                {
                    where += $@" and a.UserTeacher = {model.UserTeacher} ";
                }
                if (model.CreateBy > 0)
                {
                    where += $@" and a.CreateBy = {model.CreateBy} ";
                }
                if (model.IsOpen > 0)
                {
                    where += $@" and a.IsOpen = {model.IsOpen} ";
                }
                if (model.UserId > 0)
                {
                    likeWhere += $@" and l.UserId = {model.UserId} ";
                }
            }
            string sql = $@"SELECT t.*,if(l.Id>0,1,0) as HasLike,talk.Id as TalkId,
talk.Content as TalkContent,e.`Name` as CreateByName,e.TeacherLogo as CrearteByPhoto
                                from (SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status`,a.TalkId as tid from 
                                Rb_Education_Dynamic a {where} ) as t 
                                LEFT JOIN rb_education_dynamiclike l on l.ArticleId = t.id  {likeWhere}
                                LEFT JOIN rb_education_teacher e on e.Id = t.UserTeacher 
LEFT JOIN rb_education_talk as talk on talk.id=t.tid and talk.`Status`= 0
                                ORDER BY t.CreateTime DESC";
            return GetPage<Rb_Education_Dynamic_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 动态详情
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="articleId">动态id</param>
        /// <returns></returns>
        public Rb_Education_Dynamic_Extend GetDynamicDetial(Rb_Education_Dynamic_Extend model)
        {
            string where = " where a.`Status`=0 ";
            string likeWhere = "";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and a.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and a.MallBaseId = {model.MallBaseId} ";
                }
                if (model.Id > 0)
                {
                    where += $@" and a.Id = {model.Id} ";
                }
                if (model.IsOpen > 0)
                {
                    where += $@" and a.IsOpen = {model.IsOpen} ";
                }
                if (model.UserTeacher > 0)
                {
                    where += $@" and a.UserTeacher = {model.UserTeacher} ";
                }
                //if (model.CreateBy > 0)
                //{
                //    where += $@" and a.CreateBy = {model.CreateBy} ";
                //}
                if (model.UserId > 0)
                {
                    // where += $@" and a.CreateBy = {model.CreateBy} ";
                    likeWhere += $@" and l.UserId = {model.UserId} ";
                }
            }
            string sql = $@"SELECT t.*,if(l.Id>0,1,0) as HasLike,e.`Name` as CreateByName,e.TeacherLogo as CrearteByPhoto
                                from (SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status` from 
                                Rb_Education_Dynamic a {where} ) as t 
                                LEFT JOIN rb_education_dynamiclike l on l.ArticleId = t.id  {likeWhere}
                                LEFT JOIN rb_education_teacher e on e.Id = t.UserTeacher 
                                ORDER BY t.CreateTime DESC";
            return Get<Rb_Education_Dynamic_Extend>(sql).FirstOrDefault();
        }






        /// <summary>
        /// 与我相关的动态
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> AboutMeDynamicList(Rb_Education_Dynamic_Extend model, int pageIndex, int pageSize, out long count)
        {
            string sql = $@"SELECT * from ((SELECT a.Id,a.Content,a.CoverPhoto,a.FileType,a.Files,c.CreateTime,c.UserId,
                            c.Content as CommentContent,1 as RealtionType,e.`Name` as CreateByName,e.Photo as CrearteByPhoto,mu.`Name` as ReplyName,mu.Photo as ReplyPhoto,c.Id as CommentId ,talk.Id as TalkId,talk.Content as TalkContent
                            from rb_education_dynamiccomment c INNER JOIN rb_education_dynamic a on a.Id = c.ArticleId and
                            a.CreateBy={model.CreateBy} and a.TenantId={model.TenantId}  and a.MallBaseId={model.MallBaseId}  
                            and a.`Status` =0 and c.`Status` =0 and c.TenantId={model.TenantId}  and c.MallBaseId={model.MallBaseId}
                            LEFT JOIN rb_member_user e on e.Id  = c.UserId LEFT JOIN rb_education_dynamiccomment as edc on edc.Id=c.CommentId
LEFT JOIN rb_member_user as mu on mu.Id=edc.UserId LEFT JOIN rb_education_talk as talk on talk.id=a.TalkId and talk.`Status`= 0)
                            UNION ALL
                            (SELECT a.Id,a.Content,a.CoverPhoto,a.FileType,a.Files,l.CreateTime,l.UserId,
                            '' as CommentContent,2 as RealtionType,e.`Name` as CreateByName,e.Photo as CrearteByPhoto,'' as ReplyName ,'' as ReplyPhoto,0 as CommentId,talk.Id as TalkId,talk.Content as TalkContent
                            from rb_education_dynamiclike l JOIN rb_education_dynamic a on a.Id = l.ArticleId  and
                             a.CreateBy={model.CreateBy} and a.TenantId={model.TenantId}  and a.MallBaseId={model.MallBaseId}  
                            and a.`Status` =0  and l.TenantId={model.TenantId}  and l.MallBaseId={model.MallBaseId}
                            LEFT JOIN rb_member_user e on e.Id = l.UserId  LEFT JOIN rb_education_talk as talk on talk.id=a.TalkId and talk.`Status`= 0)) as t
                            ORDER BY t.CreateTime DESC";
            return GetPage<Rb_Education_Dynamic_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }




        /// <summary>
        /// 老师动态列表
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> MiAiDynamicList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            string where = " where a.`Status`=0  and a.IsOpen=1";
            string likeWhere = "";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and a.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and a.MallBaseId = {model.MallBaseId} ";
                }

                if (model.Id > 0)
                {
                    where += $@" and a.Id = {model.Id} ";
                }
                if (model.CreateBy > 0)
                {
                    where += $@" and a.CreateBy = {model.CreateBy} ";
                }
                if (model.UserId > 0)
                {
                    likeWhere += $@" and l.UserId = {model.UserId} ";
                }
            }
            string sql = $@"SELECT t.*,if(l.Id>0,1,0) as HasLike,talk.Id as TalkId,talk.Content as TalkContent,e.`Name` as CreateByName,e.Photo as CrearteByPhoto
                                from (SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status`,a.TalkId  as tid from 
                                Rb_Education_Dynamic a {where} ) as t 
                                LEFT JOIN rb_education_dynamiclike l on l.ArticleId = t.id  {likeWhere}
                               LEFT JOIN rb_member_user e on e.Id = t.CreateBy 
LEFT JOIN rb_education_talk as talk on talk.id=t.tid and talk.`Status`= 0
                                ORDER BY t.CreateTime DESC";
            return GetPage<Rb_Education_Dynamic_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
        /// <summary>
        /// 动态列表（除教育外）
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> MiAiDynamicOpenList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            string where = "  and a.`Status`=0 ";
            string likeWhere = "";
            string followWhere = "";
            string talkWhere = "";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and a.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and a.MallBaseId = {model.MallBaseId} ";
                }
                if (model.Id > 0)
                {
                    where += $@" and a.Id = {model.Id} ";
                }

                if (model.CreateBy > 0)
                {
                    where += $@" and a.CreateBy = {model.CreateBy} ";
                }
                if (model.UserId > 0)
                {
                    likeWhere += $@" and l.UserId = {model.UserId} ";
                    followWhere += $@" and (b.UserId = {model.UserId} and b.`Status`=0 or a.CreateBy = {model.UserId} ) ";
                }
                if (model.TalkId > 0)
                {
                    talkWhere = $"and talk.Id = {model.TalkId} ";
                }
            }
            string sql = $@"SELECT t.*,if(l.Id>0,1,0) as HasLike,talk.Id as TalkId,talk.Content as TalkContent,e.`Name` as CreateByName,e.Photo as CrearteByPhoto
                                from (SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status`,a.TalkId  as tid from 
                                Rb_Education_Dynamic a  where a.IsOpen=1 {where}
union all SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status`,a.TalkId  as tid from 
                                Rb_Education_Dynamic a LEFT JOIN RB_MiAi_FollowMember as b on a.CreateBy=b.UserId  where a.IsOpen=2 {where} {followWhere} ) as t 
                                LEFT JOIN rb_education_dynamiclike l on l.ArticleId = t.id  {likeWhere}
                               LEFT JOIN rb_member_user e on e.Id = t.CreateBy 
LEFT JOIN rb_education_talk as talk on talk.id=t.tid and talk.`Status`= 0  where 1=1 {talkWhere}
                                ORDER BY t.CreateTime DESC";
            return GetPage<Rb_Education_Dynamic_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }




        /// <summary>
        /// 动态详情
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="articleId">动态id</param>
        /// <returns></returns>
        public Rb_Education_Dynamic_Extend GetMiAiDynamicDetial(Rb_Education_Dynamic_Extend model)
        {
            string where = " where a.`Status`=0 ";
            string likeWhere = "";
            if (model != null)
            {
                if (model.TenantId > 0)
                {
                    where += $@" and a.TenantId = {model.TenantId} ";
                }
                if (model.MallBaseId > 0)
                {
                    where += $@" and a.MallBaseId = {model.MallBaseId} ";
                }
                if (model.Id > 0)
                {
                    where += $@" and a.Id = {model.Id} ";
                }
                if (model.IsOpen > 0)
                {
                    where += $@" and a.IsOpen = {model.IsOpen} ";
                }
                if (model.UserTeacher > 0)
                {
                    where += $@" and a.UserTeacher = {model.UserTeacher} ";
                }
                //if (model.CreateBy > 0)
                //{
                //    where += $@" and a.CreateBy = {model.CreateBy} ";
                //}
                if (model.UserId > 0)
                {
                    // where += $@" and a.CreateBy = {model.CreateBy} ";
                    likeWhere += $@" and l.UserId = {model.UserId} ";
                }
            }
            string sql = $@"SELECT t.*,if(l.Id>0,1,0) as HasLike,talk.Id as TalkId,talk.Content as TalkContent,e.`Name` as CreateByName,e.Photo as CrearteByPhoto
                                from (SELECT a.TenantId,a.MallBaseId,a.CreateBy,a.id,a.UserTeacher,a.Content,a.Files,a.LatAndLong,a.Address,a.CreateTime,a.CoverPhoto,a.FileType,a.IsOpen,a.`Status`,a.TalkId  as tid from 
                                Rb_Education_Dynamic a {where} ) as t 
                                LEFT JOIN rb_education_dynamiclike l on l.ArticleId = t.id  {likeWhere}
                                LEFT JOIN rb_member_user e on e.Id = t.CreateBy 
LEFT JOIN rb_education_talk as talk on talk.id=t.tid and talk.`Status`= 0
                                ORDER BY t.CreateTime DESC";
            return Get<Rb_Education_Dynamic_Extend>(sql).FirstOrDefault();
        }


    }
}
