﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 币种表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_Currency
    {

        /// <summary>
        /// ID
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 货币代码
        /// </summary>
        public string Code
        {
            get; set;
        }
        /// <summary>
        /// 名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 是否本位币
        /// </summary>        
        public int? IsStandardCurrency
        {
            get;
            set;
        }
        /// <summary>
        /// 汇率
        /// </summary>        
        public decimal? Rate
        {
            get;
            set;
        }
        /// <summary>
        /// 当前汇率
        /// </summary>
        public decimal? CurrentRate
        {
            get; set;
        }
        /// <summary>
        /// 买入现钞汇率
        /// </summary>
        public decimal? InCashRate { get; set; }
        /// <summary>
        /// 卖出现汇汇率
        /// </summary>
        public decimal? OutRemitRate { get; set; }
        /// <summary>
        /// 卖出现钞汇率
        /// </summary>
        public decimal? OutCashRate { get; set; }

        /// <summary>
        /// 上调汇率
        /// </summary>
        public decimal? ExchangeRates { get; set; }
        /// <summary>
        /// 集团ID
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 公司ID
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 操作人
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 操作时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 是否删除
        /// </summary>        
        public Common.Enum.DateStateEnum Status
        {
            get;
            set;
        }
    }
}
