﻿using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 财务单据币种仓储
    /// </summary>
    public partial class RB_CurrencyRepository : RepositoryBase<RB_Currency>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Currency); } }

        /// <summary>
        /// 获取币种列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Currency> GetList(RB_Currency model)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND " + nameof(RB_Currency.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND " + nameof(RB_Currency.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            //if (model.RB_Branch_Id >= 0)
            //{
            //    where += string.Format(" AND " + nameof(RB_Currency.RB_Branch_Id) + "={0} ", model.RB_Branch_Id);
            //}
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += string.Format(" AND " + nameof(RB_Currency_Extend.Name) + " like '%{0}%' ", model.Name);
            }
            if (model.IsStandardCurrency >= 0)
            {
                where += string.Format(" AND " + nameof(RB_Currency_Extend.IsStandardCurrency) + "={0} ", model.IsStandardCurrency);
            }
            return Get<RB_Currency>("select * from " + TableName + " " + where + " order by IsStandardCurrency desc ").ToList();
        }
        /// <summary>
        /// 获取币种分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="model"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Currency_Extend> GetPageList(int pageIndex, int pageSize, RB_Currency_Extend model, out long count)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND " + nameof(RB_Currency_Extend.Status) + "={0}", (int)Common.Enum.DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND " + nameof(RB_Currency_Extend.RB_Group_Id) + "={0}", model.RB_Group_Id);
            }
            //if (model.RB_Branch_Id >= 0)
            //{
            //    where += string.Format(" AND " + nameof(RB_Currency_Extend.RB_Branch_Id) + "={0}", model.RB_Branch_Id);
            //}
            if (!string.IsNullOrEmpty(model.Code))
            {
                where += string.Format(" AND " + nameof(RB_Currency_Extend.Code) + " like '%{0}%' ", model.Code);
            }
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += string.Format(" AND " + nameof(RB_Currency_Extend.Name) + " like '%{0}%' ", model.Name);
            }
            return GetPage<RB_Currency_Extend>(pageIndex, pageSize, out count, " select * from  " + TableName + "" + where).ToList();
        }

    }
}
