﻿using System.Linq;
using Mall.Common.API;
using Microsoft.AspNetCore.Mvc;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Mall.Module.MarketingCenter;
using Newtonsoft.Json;
using Mall.Model.Query;
using System;
using Mall.Common.Plugin;
using System.Collections.Generic;

namespace Mall.WebApi.Controllers.MarketingCenter
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class StatisticsController : BaseController
    {
        public StatisticsModule statisticsModule = new StatisticsModule();

        #region  数据统计
        /// <summary>
        /// 数据概况
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetOrdertSatistics()
        {

            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<DataStatistics_Query>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = statisticsModule.GetOrdertSatistics(query).FirstOrDefault();
            if (model == null)
            {
                return ApiResult.Failed("获取数据失败");
            }
            return ApiResult.Success("获取成功", model);
        }

        /// <summary>
        /// 销售情况
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetWeeklyOrder()
        {

            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<DataStatistics_Query>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = statisticsModule.GetWeeklyOrder(query);
            if (model == null)
            {
                return ApiResult.Failed("获取数据失败");
            }
            return ApiResult.Success("获取成功", model);
        }


        /// <summary>
        /// 商品购买力TOP排行
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGoosTop()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<DataStatistics_Query>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var List = statisticsModule.GetGoosTop(query).Take(10);
            return ApiResult.Success("获取成功", List);
        }


        /// <summary>
        /// 商品购买力TOP排行导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public FileContentResult GetGoosTopToExcel()
        {
            var parms = RequestParm;
            DataStatistics_Query demodel = JsonConvert.DeserializeObject<DataStatistics_Query>(parms.msg.ToString());

            string ExcelName = "商品购买力排行" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                      new ExcelColumn(value: "商品") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                     new ExcelColumn(value: "销售额") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                      new ExcelColumn(value: "销量") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                },
            };
            slist.Add(header);

            try
            {
                demodel.TenantId = UserInfo.TenantId;
                demodel.MallBaseId = parms.MallBaseId;
                var list = statisticsModule.GetGoosTop(demodel);
                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.Name) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.PayMoney.ToString("#0.00")) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.BuyNum.ToString()) { });
                    slist.Add(datarow);
                }
                #endregion

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }

        /// <summary>
        /// 用户购买力TOP排行
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberTop()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<DataStatistics_Query>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var List = statisticsModule.GetMemberTop(query).Take(10);
            return ApiResult.Success("获取成功", List);
        }


        /// <summary>
        /// 用户购买力TOP排行导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public FileContentResult GetMemberTopToExcel()
        {
            var parms = RequestParm;
            DataStatistics_Query demodel = JsonConvert.DeserializeObject<DataStatistics_Query>(parms.msg.ToString());

            string ExcelName = "商品购买力排行" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                      new ExcelColumn(value: "用户") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                     new ExcelColumn(value: "支付金额") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                      new ExcelColumn(value: "支付件数") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                },
            };
            slist.Add(header);

            try
            {
                demodel.TenantId = UserInfo.TenantId;
                demodel.MallBaseId = parms.MallBaseId;
                var list = statisticsModule.GetMemberTop(demodel);
                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.Name) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.PayMoney.ToString("#0.00")) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.BuyNum.ToString()) { });
                    slist.Add(datarow);
                }
                #endregion

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }

        #endregion

        #region 销售统计
        /// <summary>
        ///销售统计列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSellPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            DataStatistics_Query demodel = JsonConvert.DeserializeObject<DataStatistics_Query>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = statisticsModule.GetSellPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.CreateDate,
                x.GoodsNum,
                x.OrderNum,
                x.PayMoney,
                x.PayMemerNum
            });
            return ApiResult.Success("", pagelist);
        }

        [HttpPost]
        public ApiResult GetSellOrder()
        {

            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<DataStatistics_Query>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var model = statisticsModule.GetSellOrder(query);
            if (model == null)
            {
                return ApiResult.Failed("获取数据失败");
            }
            return ApiResult.Success("获取成功", model);
        }



        /// <summary>
        /// 用户购买力TOP排行导出
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public FileContentResult GetSellExcel()
        {
            var parms = RequestParm;
            DataStatistics_Query demodel = JsonConvert.DeserializeObject<DataStatistics_Query>(parms.msg.ToString());

            string ExcelName = "数据统计" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30) {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                      new ExcelColumn(value: "日期") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                     new ExcelColumn(value: "付款人数") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                      new ExcelColumn(value: "付款订单数") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                       new ExcelColumn(value: "付款金额") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER },
                      new ExcelColumn(value: "付款件数") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                },
            };
            slist.Add(header);

            try
            {
                demodel.TenantId = UserInfo.TenantId;
                demodel.MallBaseId = parms.MallBaseId;
                var list = statisticsModule.GetSellExcel(demodel);
                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.CreateDate) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.GoodsNum.ToString()) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.OrderNum.ToString()) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.PayMoney.ToString("#0.00")) { });
                    datarow.ExcelRows.Add(new ExcelColumn(value: item.PayMemerNum.ToString()) { });
                    slist.Add(datarow);
                }
                #endregion

                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);

                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }

        }
        #endregion

        #region 损益核算表
        [HttpPost]
        public ApiResult GetOrderProfitLossList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            OrderStatistics_Query demodel = JsonConvert.DeserializeObject<OrderStatistics_Query>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = statisticsModule.GetOrderProfitLossList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);

            foreach (var item in list)
            {
                item.ALLCommission = item.CostFreight + item.CostMoney + item.PackingMoney + item.GoodsFreight + item.OneCommission + item.TwoCommission + item.OtherPrice;
                item.NoPaid = item.ALLCommission - item.Paid;
                item.GrossProfit = item.AllPrice - item.ALLCommission;
                item.GrossProfitRate = item.AllPrice == 0 ? 0 : item.GrossProfit / item.AllPrice;
            }
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }
        #endregion
    }
}