﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 活力楼宇仓储层
    /// </summary>
    public class RB_BuildingRepository:BaseRepository<RB_Building>
    {
        /// <summary>
        /// 获取活力楼宇分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Extend> GetBuildingPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Building_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName
FROM RB_Building AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.CategoryId), query.CategoryId);
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Building_Extend.Name));
                    parameters.Add("@Name", "%" + query.Name.Trim() + "%");
                }
                if (!string.IsNullOrEmpty(query.Address))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Address ", nameof(RB_Building_Extend.Address));
                    parameters.Add("@Address", "%" + query.Address.Trim() + "%");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Building_Extend.BuildId));
            return GetPage<RB_Building_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取活力楼宇分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Extend> GetBuildingRepository( RB_Building_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName
FROM RB_Building AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.CategoryId), query.CategoryId);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Extend.UserId), query.UserId);
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Name ", nameof(RB_Building_Extend.Name));
                    parameters.Add("@Name", "%" + query.Name.Trim() + "%");
                }
                if (!string.IsNullOrEmpty(query.Address))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Address ", nameof(RB_Building_Extend.Address));
                    parameters.Add("@Address", "%" + query.Address.Trim() + "%");
                }
            }
            builder.AppendFormat(" ORDER BY A.{0} DESC ", nameof(RB_Building_Extend.BuildId));
            return Get<RB_Building_Extend>( builder.ToString(), parameters).ToList();
        }
    }
}
