﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Assess
{
    /// <summary>
    /// 估价商品实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
	public class RB_Assess_Goods
	{
		/// <summary>
		/// Id
		/// </summary>
		public int Id { get; set; }

		/// <summary>
		/// 分类ID
		/// </summary>
		public int CategoryId { get; set; }

		/// <summary>
		/// 品牌ID
		/// </summary>
		public int BrandId { get; set; }

		/// <summary>
		/// 用户ID
		/// </summary>
		public int UserId { get; set; }

		/// <summary>
		/// 三组图 （json格式）
		/// </summary>
		public string GoodsImg { get; set; }

		/// <summary>
		/// 更多图片  Json格式
		/// </summary>
		public string MoreImg { get; set; }

		/// <summary>
		/// 备注
		/// </summary>
		public string Remark { get; set; }

		/// <summary>
		/// 回复
		/// </summary>
		public string ReplyContent { get; set; }

		/// <summary>
		/// Status
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 商户号
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 回复时间
		/// </summary>
		public DateTime? ReplyDate { get; set; }

	}
}
