﻿using VT.FW.DB;
using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 字典表
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Dictvalue
    {
        /// <summary>
        /// 主键编号
        /// </summary>       
        public int ID
        {
            get;
            set;
        }

        /// <summary>
        /// 标识
        /// </summary>        
        public string DictKey
        {
            get;
            set;
        }

        /// <summary>
        /// 排序
        /// </summary>        
        public int SNO
        {
            get;
            set;
        }

        /// <summary>
        /// 名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 代码
        /// </summary>   
        public string Code
        {
            get;
            set;
        }

        /// <summary>
        /// 内容
        /// </summary>   
        public string Content
        {
            get;
            set;
        }

        /// <summary>
        /// 集团id
        /// </summary>        
        public int RB_Group_id
        {
            get;
            set;
        }

        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 操作人
        /// </summary>        
        public int UpdateBy
        {
            get;
            set;
        }

        /// <summary>
        /// 操作时间
        /// </summary>        
        public DateTime UpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 状态
        /// </summary>        
        public DateStateEnum Status
        {
            get;
            set;
        }

        /// <summary>
        /// 掩码
        /// </summary>
        public string Mask { get; set; }
    }
}
