﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 交易明细实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_Online_Trade_Detail
    {
        /// <summary>
        /// ID
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 支付类型1-收款2-退款
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 订单来源
        /// </summary>
        public int? OrderSource
        {
            get; set;
        }
        /// <summary>
        /// 订单号
        /// </summary>        
        public int? OrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 推送支付的订单号
        /// </summary>
        public string Pay_Order
        {
            get; set;
        }
        /// <summary>
        /// 平台订单号
        /// </summary>        
        public string Trade_Order
        {
            get;
            set;
        }
        /// <summary>
        /// 第三方订单号
        /// </summary>        
        public string Third_Order
        {
            get;
            set;
        }
        /// <summary>
        /// 交易金额
        /// </summary>        
        public decimal? Money
        {
            get;
            set;
        }
        /// <summary>
        /// 1-微信 2-QQ3-支付宝4-银联
        /// </summary>        
        public int? Pay_Way
        {
            get;
            set;
        }
        /// <summary>
        /// 接口公司
        /// </summary>        
        public int? Interface_Company
        {
            get;
            set;
        }
        /// <summary>
        /// 接口版本号
        /// </summary>        
        public string Version
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public string Mch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户标识
        /// </summary>        
        public string User_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 是否关注公众号
        /// </summary>        
        public int? Is_follow
        {
            get;
            set;
        }
        /// <summary>
        /// 公众号APPID
        /// </summary>        
        public string AppId
        {
            get;
            set;
        }
        /// <summary>
        /// 微信唯一标识
        /// </summary>        
        public string OpenId
        {
            get;
            set;
        }
        /// <summary>
        /// 货币代码
        /// </summary>        
        public string Currency_Type
        {
            get;
            set;
        }
        /// <summary>
        /// 付款机构
        /// </summary>        
        public string Institution_Type
        {
            get;
            set;
        }
        /// <summary>
        /// 卡类型
        /// </summary>        
        public int? Card_Type
        {
            get;
            set;
        }
        /// <summary>
        /// 备注附加信息
        /// </summary>        
        public string Remarks
        {
            get;
            set;
        }
        /// <summary>
        /// 0-成功其他-失败
        /// </summary>        
        public int? Pay_Result
        {
            get;
            set;
        }
        /// <summary>
        /// 交易日期
        /// </summary>        
        public DateTime? Pay_Date
        {
            get;
            set;
        }
        /// <summary>
        /// 付款方
        /// </summary>        
        public int? Payer_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 付款方类型
        /// </summary>
        public int Payer_Type
        {
            get; set;
        }
        /// <summary>
        /// 数据来源
        /// </summary>        
        public int? Data_Source
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 是否申请退款  1是
        /// </summary>
        public int? IsRefund { get => isRefund; set => isRefund = value; }

        private int? isRefund = 0;

        /// <summary>
        /// 退款商户单号
        /// </summary>
        public string RefundTrade_Order { get; set; }
        /// <summary>
        /// 退款金额
        /// </summary>
        public decimal? RefundMoney { get; set; }
        /// <summary>
        /// 退款状态
        /// </summary>
        public int? RefundStatus { get; set; }
        /// <summary>
        /// 绑定的退款财务单据id
        /// </summary>
        public int? FinanceId { get; set; }
        /// <summary>
        /// 申请退款时间
        /// </summary>
        public DateTime? RefundTime { get; set; }
    }
}
