﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 工作流程审核记录表实体类
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class Rb_Workflow_Auditrecord
    {
        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// 工作流id
        /// </summary>        
        public int? WorkFlowId
        {
            get;
            set;
        }

        /// <summary>
        /// 审核id
        /// </summary>        
        public int? AuditId
        {
            get;
            set;
        }

        /// <summary>
        /// 1未审核  2审核通过  3 不通过  4 驳回 5他人已审核
        /// </summary>        
        public Common.Enum.Finance.WFRrocessStatus? AuditStatus
        {
            get;
            set;
        }

        /// <summary>
        /// 描述
        /// </summary>        
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// 1请假  2出差  3  外出  4  补卡
        /// </summary>        
        public int? TemplateType
        {
            get;
            set;
        }

        /// <summary>
        /// 创建人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateTime
        {
            get;
            set;
        }

        /// <summary>
        /// 修改人
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }

        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime? UpdateTime
        {
            get;
            set;
        }

        /// <summary>
        /// 审批人
        /// </summary>        
        public int? AuditEmId
        {
            get;
            set;
        }
        /// <summary>
        /// 转交备注
        /// </summary>
        public string CareOfRemarks { get; set; }

        /// <summary>
        /// 图片
        /// </summary>
        public string Image { get; set; }

        /// <summary>
        /// 创建人名称
        /// </summary>
        public string RB_CreateByName { get; set; }

        /// <summary>
        /// 审核人名称
        /// </summary>
        public string AuditEmIdName { get; set; }
    }
}
