﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Goods;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品关联分类表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_WK_Course
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 商品id
        /// </summary>        
        public int? GoodsId
        {
            get;
            set;
        }
        /// <summary>
        /// 章节排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }
        /// <summary>
        /// 章节排序标题
        /// </summary>
        public string SortName { get; set; }
        /// <summary>
        /// 课程名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 附件类型  枚举
        /// </summary>
        public GoodsCourseTypeEnum? Type { get; set; }
        /// <summary>
        /// 是否可以试下  1是  2否
        /// </summary>
        public int? IsTrySee { get; set; }
        /// <summary>
        /// 试看 视频秒/word pdf页
        /// </summary>
        public int? Number { get; set; }
        /// <summary>
        /// 是否可以缓存  1是  2否
        /// </summary>
        public int? IsCache { get; set; }
        /// <summary>
        /// 文件地址
        /// </summary>
        public string FilePath { get; set; }
        /// <summary>
        /// 视频封面图
        /// </summary>
        public string VideoImage { get; set; }
        /// <summary>
        /// 视频时长
        /// </summary>
        public int? VideoTime { get; set; }
        /// <summary>
        /// 非视频 转图片 json格式  
        /// </summary>
        public string Image { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 图片生成是否OK  1是 2正在生成中
        /// </summary>
        public int? IsImageOK { get; set; }
        /// <summary>
        /// 文件存储  1腾讯  2阿里
        /// </summary>
        public int? PathType { get; set; }
    }
}
