﻿using VT.FW.DB;
using Mall.Common.Enum.Property;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 耗材盘点实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_Check
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 期数
        /// </summary>        
        public string Periods
        {
            get;
            set;
        }
        /// <summary>
        /// 开始时间
        /// </summary>        
        public DateTime? StartDate
        {
            get;
            set;
        }
        /// <summary>
        /// 结束时间
        /// </summary>        
        public DateTime? EndDate
        {
            get;
            set;
        }
        /// <summary>
        /// 公司别  (暂不启用  都是网络印象同步的)
        /// </summary>        
        public int? BranchId
        {
            get;
            set;
        }
        /// <summary>
        /// 分类ids  （暂不启用  都是电商同步的）
        /// </summary>        
        public string CategoryIds
        {
            get;
            set;
        }
        /// <summary>
        /// 仓库id
        /// </summary>        
        public int? WarehouseId
        {
            get;
            set;
        }
        /// <summary>
        /// 盘点期数状态
        /// </summary>        
        public SuppliesCheckStatusEnum? CheckState
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 状态 0正常  1删除
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// CreateBy
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateBy
        /// </summary>        
        public int? UpdateBy
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
