﻿using System;
using VT.FW.DB;
using Mall.Common.Plugin;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 耗材出库申请明细实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_StockOutApplyForDetail
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 申请id
        /// </summary>
        public int ApplyForId { get; set; }

        /// <summary>
        /// 班级id
        /// </summary>
        public int ClassId { get; set; }

        /// <summary>
        /// 班级名称
        /// </summary>
        public string ClassName { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string CourseName { get; set; }

        /// <summary>
        /// 耗材id
        /// </summary>
        public int SuppliesId { get; set; }

        /// <summary>
        /// 出库数量
        /// </summary>
        public int Number { get; set; }

        /// <summary>
        /// 已出库数量
        /// </summary>
        public int StockOutNum { get; set; }

        /// <summary>
        /// 状态 0 正常 1删除
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 公司
        /// </summary>
        public int RB_Branch_Id { get; set; }

        /// <summary>
        /// 集团
        /// </summary>
        public int RB_Group_Id { get; set; }

        /// <summary>
        /// CreateBy
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// CreateDate
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// UpdateBy
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// UpdateDate
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 校区id
        /// </summary>
        public int SchoolId { get; set; }

        /// <summary>
        /// 校区名称
        /// </summary>
        public string SchoolName { get; set; }

    }
}