﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Finance;
using VT.FW.DB;

namespace Mall.Model.Extend.Finance
{
    /// <summary>
    /// 审核步骤实体
    /// </summary>    
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class Rb_Workflow_AuditRelevance_Extend : Rb_Workflow_AuditRelevance
    {
        /// <summary>
        /// 指定员工ID列表
        /// </summary>
        public List<int> emList { get; set; }
        /// <summary>
        /// 待审核人名称
        /// </summary>
        public string ToAuditName { get; set; }
        /// <summary>
        /// 审核记录列表
        /// </summary>
      //  public List<Rb_Workflow_Auditrecord_Extend> AuditRecordList { get; set; }
        /// <summary>
        /// 是否是下一步1-是0-否
        /// </summary>
        public int? NextStep
        {
            get;
            set;
        }
        /// <summary>
        /// 是否出纳审核1-是
        /// </summary>
        public int? CashierAudit
        {
            get; set;
        }
        /// <summary>
        /// 财务审核常规流程列表
        /// </summary>
        public List<AuditInfo> AuditInfoList
        {
            get; set;
        }
        #region 财务审核步骤实体
        /// <summary>
        /// 审核人审核时间
        /// </summary>
        public class AuditInfo
        {
            /// <summary>
            /// 审核记录ID
            /// </summary>
            public int? ID
            {
                get; set;
            }
            /// <summary>
            /// 审核人
            /// </summary>
            public string AuditName
            {
                get; set;
            }
            /// <summary>
            /// 审核时间
            /// </summary>
            public DateTime? AduitDate
            {
                get; set;
            }
            /// <summary>
            /// 备注
            /// </summary>
            public string Remark
            {
                get; set;
            }
            /// <summary>
            /// 审核状态
            /// </summary>
            public int? AuditStatus
            {
                get; set;
            }
            /// <summary>
            /// 特殊节点
            /// </summary>
            public int? CashierAudit
            {
                get; set;
            }
            /// <summary>
            /// 图片集合
            /// </summary>
            public List<string> Image { get; set; }
        }
        #endregion
    }
}
