﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.Product;
using Mall.Model.Extend.User;
using Mall.Repository.BaseSetUp;
using Mall.Repository.Product;
using Mall.Repository.User;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using VT.FW.DB;

namespace Mall.Module.Product
{
    /// <summary>
    /// 报表处理层
    /// </summary>
    public class ReportModule
    {
        /// <summary>
        /// 会员
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 更新下线数据记录
        /// </summary>
        private readonly RB_User_ReferralsLogRepository user_ReferralsLogRepository = new RB_User_ReferralsLogRepository();


        /// <summary>
        /// 获取最近的更新记录
        /// </summary>
        /// <param name="mallbaseId"></param>
        /// <returns></returns>
        public RB_User_ReferralsLog GetUserReferralsNew(int mallbaseId)
        {
            return user_ReferralsLogRepository.GetNewLog(mallbaseId);
        }

        /// <summary>
        /// 初始化内部人员下线
        /// </summary>
        /// <param name="mallbaseId"></param>
        /// <returns></returns>
        public string SetInitializeReferrals(int mallbaseId, int empId) {
            try
            {
                //首先清除数据
                member_UserRepository.DelUserReferrals();
                //执行存储过程
                member_UserRepository.UpdateUserReferrals();
                //记录日志
                user_ReferralsLogRepository.Insert(new RB_User_ReferralsLog()
                {
                    Id = 0,
                    Content = "更新内部人员下线：" + empId,
                    CreateBy = empId,
                    CreateDate = DateTime.Now,
                    MallBaseId = mallbaseId
                });
                return "";
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetInitializeReferrals");
                return "出错了，请联系管理员";
            }
        }

        /// <summary>
        /// 获取下线列表
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="mallbaseId"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetNewReferralsList(string startTime, string endTime, int mallbaseId)
        {
            return member_UserRepository.GetNewReferralsList(mallbaseId, startTime, endTime);
        }

        /// <summary>
        /// 获取订单佣金排名
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="mallbaseId"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetOrderCommissionList(string startTime, string endTime, int mallbaseId)
        {
            return member_UserRepository.GetOrderCommissionList(mallbaseId, startTime, endTime);
        }

        /// <summary>
        /// 获取vip购买
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="mallbaseId"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetVipBuyList(string startTime, string endTime, int mallbaseId)
        {
            return member_UserRepository.GetVipBuyList(mallbaseId, startTime, endTime);
        }

        /// <summary>
        /// 获取新用户列表
        /// </summary>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="mallbaseId"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetNewUserList(string startTime, string endTime, int mallbaseId)
        {
            return member_UserRepository.GetNewUserList(mallbaseId, startTime, endTime);
        }
    }
}
