﻿using Mall.Common.Enum;
using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 活动评论处理类
    /// </summary>
    public class CommerceCommentModule
    {
        /// <summary>
        /// 商会活动评论表仓储层对象
        /// </summary>
        private readonly RB_Commerce_CommentRepository commerce_CommentRepository = new RB_Commerce_CommentRepository();

        /// <summary>
        /// 获取活动评论分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Comment_Extend> GetCommerceCommentPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Comment_Extend query)
        {
            return commerce_CommentRepository.GetCommerceCommentPageRepository(pageIndex, pageSize, out rowsCount, query).ToList();
        }

        /// <summary>
        /// 新增活动评论
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCommerceCommentModule(RB_Commerce_Comment_Extend model)
        {
            var newId = commerce_CommentRepository.Insert(model);
            model.Id = newId;
            bool flag = newId > 0;
            return flag;
        }

        /// <summary>
        /// 删除活动评论
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public bool RemoveCommerceCommentModule(int Id)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Commerce_Comment_Extend.Id),(int)DateStateEnum.Delete }
            };
            return commerce_CommentRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_Comment_Extend.Id), Id));
        }
    }
}
