﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Repository
{
    public class BaseRepository<T> : RepositoryBase<T> where T : class
    {
        /// <summary>
        /// 数据库连接Key
        /// </summary>
        public string ConnKey { get; set; }

        public BaseRepository(string connKey = "DefaultConnection")
        {
            try
            {
                var classAttribute = (DBAttribute)Attribute.GetCustomAttribute(typeof(T), typeof(DBAttribute));
                connKey = classAttribute.ConnectionName ?? "DefaultConnection";
            }
            catch (Exception ex)
            {
                throw ex;
            }
            ConnKey = connKey;
        }

        public string _ConnectionStr;

        public string _ProviderName;

        public override string ConnectionStr
        {
            get
            {
                _ConnectionStr = Common.Config.GetConnectionString(ConnKey);
                return _ConnectionStr;
            }
            set
            {
                _ConnectionStr = value;
            }
        }

        public override string ProviderName
        {
            get
            {
                _ProviderName = "MySql.Data.MySqlClient";
                return _ProviderName;
            }
            set
            {
                _ProviderName = value;
            }
        }
    }
}
