﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;
using Mall.Model.Extend.Miai;
using System.Linq;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 活动版块仓储层
    /// </summary>
    public class RB_Miai_ForumRepository : BaseRepository<RB_Miai_Forum>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_Forum_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Miai_Forum_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Miai_Forum_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Miai_Forum_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_Forum_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and {nameof(RB_Miai_Forum_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.IsShow > 0) {
                where += $@" and {nameof(RB_Miai_Forum_Extend.IsShow)} ={dmodel.IsShow}";
            }
            string sql = $@"select * from RB_Miai_Forum where {where} order by Id desc";
            return GetPage<RB_Miai_Forum_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_Forum_Extend> GetList(RB_Miai_Forum_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Miai_Forum_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Miai_Forum_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_Forum_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and {nameof(RB_Miai_Forum_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.IsShow > 0)
            {
                where += $@" and {nameof(RB_Miai_Forum_Extend.IsShow)} ={dmodel.IsShow}";
            }
            string sql = $@"select * from RB_Miai_Forum where {where} order by Sort asc,Id desc";
            return Get<RB_Miai_Forum_Extend>(sql).ToList();
        }
    }
}
