﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品优惠仓储类
    /// </summary>
    public class RB_Goods_PreferentialRepository : BaseRepository<RB_Goods_Preferential>
    {
        /// <summary>
        /// 获取商品优惠列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Goods_Preferential_Extend> GetGoodsPreferentialListRepostory(RB_Goods_Preferential_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" 
SELECT * 
FROM RB_Goods_Preferential 
WHERE 1=1 ");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Goods_Preferential_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Goods_Preferential_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Goods_Preferential_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Goods_Preferential_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.GoodsId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Goods_Preferential_Extend.GoodsId), query.GoodsId);
                }
                if (!string.IsNullOrEmpty(query.QGoodsIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Goods_Preferential_Extend.GoodsId), query.QGoodsIds);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Goods_Preferential_Extend.Id), query.Id);
                }
            }
            return Get<RB_Goods_Preferential_Extend>(builder.ToString()).ToList();
        }


        /// <summary>
        /// 根据商品编号删除优惠信息
        /// </summary>
        /// <param name="GoodsId">商品编号</param>
        /// <returns></returns>
        public bool DeleteGoodsPreferentialRepostory(int GoodsId)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(" DELETE FROM RB_Goods_Preferential WHERE GoodsId={0} ", GoodsId);
            return base.Execute(builder.ToString()) > 0;
        }
    }
}
