﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 拼团地区信息
    /// </summary>
    public class RB_GroupBuy_AreaRepository : BaseRepository<RB_GroupBuy_Area>
    {
        /// <summary>
        /// 根据查询条件获取地区信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_GroupBuy_Area_Extend> GetGroupBuyAreaRepository(RB_GroupBuy_Area_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT ga.*,d.Name as AreaName 
FROM rb_groupbuy_area ga INNER JOIN rb_destination d ON ga.AreaId=d.ID
WHERE 1=1 
");
            builder.Append($"   and ga.{nameof(RB_GroupBuy_Area_Extend.Status)}=0 ");

            if (query.TenantId > 0)
            {
                builder.Append($@" and ga.{nameof(RB_GroupBuy_Area_Extend.TenantId)}={query.TenantId}");
            }
            if (query.MallBaseId > 0)
            {
                builder.Append($@" and ga.{nameof(RB_GroupBuy_Area_Extend.MallBaseId)}={query.MallBaseId}");
            }
            if (query.Id > 0)
            {
                builder.Append($@" and ga.{nameof(RB_GroupBuy_Area_Extend.Id)}={query.Id}");
            }
            if (query.GoodsId > 0)
            {
                builder.Append($@" and ga.{nameof(RB_GroupBuy_Area_Extend.GoodsId)}={query.GoodsId}");
            }
            if (!string.IsNullOrEmpty(query.GoodsIds))
            {
                builder.Append($@" and ga.{nameof(RB_GroupBuy_Area_Extend.GoodsId)} in({query.GoodsIds})");
            }

            builder.AppendFormat("  order by ga.Id desc  ");
            return Get<RB_GroupBuy_Area_Extend>(builder.ToString()).ToList();
        }
    }
}
