﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 耗材仓库库存明细仓储类
    /// </summary>
    public partial class RB_Supplies_InventoryDetailRepository : BaseRepository<RB_Supplies_InventoryDetail>
    {
        /// <summary>
        /// 获取耗材仓库库存分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Supplies_InventoryDetail_Extend> GetPageList(int pageIndex, int pageSize, RB_Supplies_InventoryDetail_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_InventoryDetail_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";            
            if (dmodel.InventoryId > 0) {
                where += " and " + nameof(RB_Supplies_InventoryDetail_Extend.InventoryId) + $" ={dmodel.InventoryId}";
            }

            string sql = $@" select * from RB_Supplies_InventoryDetail {where} order by Id desc";
            return GetPage<RB_Supplies_InventoryDetail_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Supplies_InventoryDetail_Extend> GetList(RB_Supplies_InventoryDetail_Extend dmodel)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND {0}={1}", nameof(RB_Supplies_InventoryDetail_Extend.Status), 0);
            where += $@" and RB_Group_Id={dmodel.RB_Group_Id}";
            if (dmodel.InventoryId > 0)
            {
                where += " and " + nameof(RB_Supplies_InventoryDetail_Extend.InventoryId) + $" ={dmodel.InventoryId}";
            }

            string sql = $@" select * from RB_Supplies_InventoryDetail {where} order by Id desc";
            return Get<RB_Supplies_InventoryDetail_Extend>(sql).ToList();
        }
    }
}
