﻿using Mall.Model.Entity.Reserve;
using Mall.Model.Extend.Reserve;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Reserve
{
    public class RB_Reserve_ServiceTargetDateRepository : BaseRepository<RB_Reserve_ServiceTargetDate>
    {
        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServiceTargetDate_Extend> GetList(RB_Reserve_ServiceTargetDate_Extend dmodel)
        {
            string where = $" 1=1 and Date >= '{DateTime.Now.ToString("yyyy-MM-dd")}'";

            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Reserve_ServiceTargetDate.Id)}={dmodel.Id}";
            }
            if (dmodel.ServiceId > 0)
            {
                where += $@" and {nameof(RB_Reserve_ServiceTargetDate.ServiceId)}={dmodel.ServiceId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ServiceIds))
            {
                where += $@" and {nameof(RB_Reserve_ServiceTargetDate.ServiceId)} in({dmodel.ServiceIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.DateTime))
            {
                where += $@" and {nameof(RB_Reserve_ServiceTargetDate.Date)} ='{dmodel.DateTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and {nameof(RB_Reserve_ServiceTargetDate.Date)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and {nameof(RB_Reserve_ServiceTargetDate.Date)} <='{dmodel.EndTime} 23:59:59'";
            }
            if (!string.IsNullOrEmpty(dmodel.Month))
            {
                where += $@" and DATE_FORMAT(Date,'%Y-%m') ='{dmodel.Month}'";
            }
            if (dmodel.IsReserve > 0)
            {
                where += $@" and {nameof(RB_Reserve_ServiceTargetDate.IsReserve)}={dmodel.IsReserve}";
            }

            string sql = $@"select * from RB_Reserve_ServiceTargetDate where {where} order by Date asc";
            return Get<RB_Reserve_ServiceTargetDate_Extend>(sql).ToList();
        }
    }
}
