﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 认证仓储层
    /// </summary>
    public class RB_AuthenticationRepository : BaseRepository<RB_Authentication>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Authentication); } }

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Authentication_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Authentication_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Authentication_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Type)}={(int)query.Type}");
                }
               
                if (query.BrandType > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.BrandType)}={(int)query.BrandType}");
                }
                if (query.BusinessType > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.BusinessType)}={(int)query.BusinessType}");
                }
                if (query.CreateBy > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.CreateBy)}={query.CreateBy}");
                }
                if (query.Category > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Category)}={(int)query.Category}");
                }
                if (query.AuditState > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.AuditState)}={query.AuditState}");
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrEmpty(query.Contact))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Contact)} like '%{query.Contact}%'");
                }
                if (!string.IsNullOrEmpty(query.ContactMobile))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.ContactMobile)} like '%{query.ContactMobile}%'");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.OpenTime)} >= '{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.OpenTime)} <= '{query.EndTime} 23:59:59'");
                }
            }
            builder.Append($" order by Id desc");
            return GetPage<RB_Authentication_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Authentication_Extend> GetList(RB_Authentication_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Authentication_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Ids))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Id)} in({query.Ids})");
                }
                if (query.Type > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Type)}={(int)query.Type}");
                }
                if (query.BrandType > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.BrandType)}={(int)query.BrandType}");
                }
                if (query.BusinessType > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.BusinessType)}={(int)query.BusinessType}");
                }
                if (query.Category > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Category)}={(int)query.Category}");
                }
                if (query.CreateBy > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.CreateBy)}={(int)query.CreateBy}");
                }
                if (!string.IsNullOrEmpty(query.QCreateBy))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.CreateBy)} IN({query.QCreateBy}) ");
                }
                if (query.AuditState > 0)
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.AuditState)}={query.AuditState}");
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrEmpty(query.Contact))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.Contact)} like '%{query.Contact}%'");
                }
                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.OpenTime)} >= '{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($" AND {nameof(RB_Authentication_Extend.OpenTime)} <= '{query.EndTime} 23:59:59'");
                }
            }
            builder.Append($" order by Id desc");
            return Get<RB_Authentication_Extend>(builder.ToString()).ToList();
        }
    }
}
