﻿using Mall.Model.Entity.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    public class RB_SupplierCommissionRepository:BaseRepository<RB_SupplierCommission>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_SupplierCommission); } }
        /// <summary>
        /// 供应商返佣规则
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_SupplierCommission> GetSupplierCommissionPage(int pageIndex, int pageSize, out long rowCount, RB_SupplierCommission query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_SupplierCommission.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.MallBaseId)}={query.MallBaseId}");
                }
              
                if (query.CommissionType > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.CommissionType)}={query.CommissionType}");
                }
                if (query.SupplierId > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.SupplierId)}={query.SupplierId}");
                }
            }
            return GetPage<RB_SupplierCommission>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 供应商返佣规则
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_SupplierCommission> GetSupplierCommissionList(RB_SupplierCommission query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_SupplierCommission.Status)}=0 ");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.MallBaseId)}={query.MallBaseId}");
                }

                if (query.CommissionType > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.CommissionType)}={query.CommissionType}");
                }
                if (query.SupplierId > 0)
                {
                    builder.Append($" AND {nameof(RB_SupplierCommission.SupplierId)}={query.SupplierId}");
                }
            }
            return Get<RB_SupplierCommission>(builder.ToString()).ToList();
        }



        /// <summary>
        /// 供应商返佣规则
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_SupplierCommission> GetListBySupplierIds(string ids)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_SupplierCommission.Status)}=0 ");
            if (!string.IsNullOrWhiteSpace(ids))
            {
                builder.Append($" AND {nameof(RB_SupplierCommission.SupplierId)} in ({ids})");
            }
            return Get<RB_SupplierCommission>(builder.ToString()).ToList();
        }
    }
}
