﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Test.Model
{
    public class FreightRules
    {
        //http://wx.weibaoge.cn/web/index.php?r=mall%2Fpostage-rule%2Findex&page=1&keyword=   列表接口
        //http://wx.weibaoge.cn/web/index.php?r=mall%2Fpostage-rule%2Fedit&id=209  详情接口
        public int id { get; set; }
        public string name { get; set; }
        /// <summary>
        /// 默认0-否，1-是
        /// </summary>
        public int status { get; set; }


        /// <summary>
        /// 计费方式 2-件  1-重量
        /// </summary>
        public int type { get; set; }


        public string updated_at { get; set; }


        public string created_at { get; set; }
        public List<FreightPrice> detail { get; set; }

    }

    public class FreightPrice
    {

        public int first { get; set; }

        public decimal firstPrice { get; set; }


        public int second { get; set; }


        public decimal secondPrice { get; set; }

        public List<FreightArea> list { get; set; }

    }

    public class FreightArea
    {
        public int id { get; set; }
        public string name { get; set; }
    }




    /// <summary>
    /// 提现
    /// </summary>
    public class Remit
    {
        //http://wx.weibaoge.cn/web/index.php?r=mall%2Fshare%2Fcash-data&status=-1&page=1 接口请求地址
        public int id { get; set; }
        public string order_no { get; set; }
        public string pay_type { get; set; }
        /// <summary>
        /// 提现方式，auto-自动打款，wechat-微信线下转账
        /// </summary>
        public string type { get; set; }

        /// <summary>
        /// 提现状态0-未审核，1-待打款，2-已打款，3-驳回
        /// </summary>
        public int status { get; set; }


        public string status_text { get; set; }

        public UserInfo user { get; set; }
        public CashInfo cash { get; set; }
        public ExtraInfo extra { get; set; }
        public TimeInfo time { get; set; }
        public ContentInfo content { get; set; }
    }


    public class UserInfo
    {
        /// <summary>
        /// 头像
        /// </summary>
        public string avatar { get; set; }

        /// <summary>
        /// 昵称
        /// </summary>
        public string nickname { get; set; }


        /// <summary>
        /// 平台
        /// </summary>
        public string platform { get; set; }

    }

    public class CashInfo
    {
        public string price { get; set; }
        /// <summary>
        /// 手续费
        /// </summary>
        public string service_charge { get; set; }
        public string actual_price { get; set; }
    }
    public class ExtraInfo
    {
        /// <summary>
        /// 微信昵称
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 微信号
        /// </summary>
        public string mobile { get; set; }
        public string bank_name { get; set; }
    }

    public class TimeInfo
    {
        /// <summary>
        /// 申请时间
        /// </summary>
        public string created_at { get; set; }
        /// <summary>
        /// 审核时间
        /// </summary>
        public string apply_at { get; set; }
        /// <summary>
        /// 打款时间
        /// </summary>
        public string remittance_at { get; set; }

        /// <summary>
        /// 驳回时间
        /// </summary>
        public string reject_at { get; set; }
    }

    public class ContentInfo
    {
        /// <summary>
        /// 审核备注
        /// </summary>
        public string apply_content { get; set; }
        /// <summary>
        /// 打款备注
        /// </summary>
        public string remittance_content { get; set; }
        public string remittance_at { get; set; }

        /// <summary>
        /// 驳回备注
        /// </summary>
        public string reject_content { get; set; }
    }

}
