﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using Mall.Repository.Product;
using Mall.Model.Extend.Product;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Newtonsoft.Json;
using Mall.Repository.BaseSetUp;
using Mall.Common.Enum.User;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using System.Threading;
using Mall.Repository.Finance;
using NPOI.SS.Formula.Functions;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户用户处理层
    /// </summary>
    public class UserVipModule
    {
        /// <summary>
        /// vip购买自定义仓储
        /// </summary>
        private readonly RB_Distributor_FXGradeCustomRepository dXGradeCustomRepository = new RB_Distributor_FXGradeCustomRepository();
        /// <summary>
        /// vip购买仓储层
        /// </summary>
        private readonly RB_Vip_BuyRepository vipBuyRepository = new RB_Vip_BuyRepository();
        /// <summary>
        /// vip购买返佣
        /// </summary>
        private readonly RB_VipBuy_CommissionRepository vipBuy_CommissionRepository = new RB_VipBuy_CommissionRepository();
        /// <summary>
        /// 粉象等级
        /// </summary>
        private readonly RB_Distributor_FXGradeRepository distributor_FXGradeRepository = new RB_Distributor_FXGradeRepository();
        /// <summary>
        /// 用户
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();



        #region  vip购买自定义

        /// <summary>
        /// 自定义页面信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_FXGradeCustom_Extend> GetGradeCustomPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_FXGradeCustom_Extend query)
        {
            return dXGradeCustomRepository.GetGradeCustomPageList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 自定义页面信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_FXGradeCustom_Extend> GetGradeCustomList(RB_Distributor_FXGradeCustom_Extend query)
        {
            return dXGradeCustomRepository.GetGradeCustomList(query);
        }

        /// <summary>
        /// 新增/修改vip自定义购买页面信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateFXGradeCustom(RB_Distributor_FXGradeCustom_Extend model)
        {
            if (model.Id == 0)
            {
                return dXGradeCustomRepository.Insert(model) > 0;
            }
            else
            {
                IDictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Distributor_FXGradeCustom.BackColor),model.BackColor},
                    { nameof(RB_Distributor_FXGradeCustom.BackImage),model.BackImage},
                    { nameof(RB_Distributor_FXGradeCustom.BottomRule),model.BottomRule},
                    { nameof(RB_Distributor_FXGradeCustom.UpdateDate),model.UpdateDate},
                    { nameof(RB_Distributor_FXGradeCustom.VipICO),model.VipICO},
                };
                IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper (){ FiledName=nameof(RB_Distributor_FXGradeCustom.MallBaseId),FiledValue=model.MallBaseId,OperatorEnum=OperatorEnum.Equal},
                      new WhereHelper (){ FiledName=nameof(RB_Distributor_FXGradeCustom.TenantId),FiledValue=model.TenantId,OperatorEnum=OperatorEnum.Equal},
                        new WhereHelper (){ FiledName=nameof(RB_Distributor_FXGradeCustom.Id),FiledValue=model.Id,OperatorEnum=OperatorEnum.Equal}
                };
                return dXGradeCustomRepository.Update(fileds, whereHelpers);
            }
        }
        #endregion

        #region vip购买
        /// <summary>
        /// Vip购买信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Vip_Buy_Extend> GetVipBuyPageList(int pageIndex, int pageSize, out long rowCount, RB_Vip_Buy_Extend query)
        {
            return vipBuyRepository.GetVipBuyPageList(pageIndex, pageSize, out rowCount, query);

        }

        /// <summary>
        /// Vip购买信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Vip_Buy_Extend> GetVipBuyList(RB_Vip_Buy_Extend query)
        {
            return vipBuyRepository.GetVipBuyList(query);
        }

        /// <summary>
        /// 新增VIP购买记录
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddVipBuy(RB_Vip_Buy_Extend model)
        {
            int id = 0;
            if (model.Id == 0)
            {
                id = vipBuyRepository.Insert(model);

            }
            return id;
        }

        #endregion

        #region vip购买返佣

        /// <summary>
        /// 获取返佣分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Vip_Buy_Extend> GetVipBuyCommissionPageList(int pageIndex, int pageSize, out long count, RB_Vip_Buy_Extend demodel)
        {
            var list = vipBuyRepository.GetVipBuyCommissionPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                string OrderIds = string.Join(",", list.Select(x => x.Id));
                var clist = vipBuy_CommissionRepository.GetList(new RB_VipBuy_Commission_Extend() { OrderIds = OrderIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                var FXList = distributor_FXGradeRepository.GetList(new RB_Distributor_FXGrade_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                //获取用户
                var ulist = new List<RB_Member_User_Extend>();
                if (clist.Any())
                {
                    ulist = member_UserRepository.GetList(new RB_Member_User_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId, UserIds = string.Join(",", clist.Select(x => x.UserId).Distinct()) });
                }
                foreach (var item in list) {
                    item.CommissionList = clist.Where(x => x.OrderId == item.Id).ToList();

                    foreach (var qitem in item.CommissionList) {
                        var fxmodel = FXList.Where(x => x.Id == qitem.Grade).FirstOrDefault();
                        qitem.GradeDescription = fxmodel.GradeName;
                        qitem.UserName = ulist.Where(x => x.Id == qitem.UserId).FirstOrDefault()?.Name ?? "";
                    }
                }
            }

            return list;
        }
        #endregion
    }
}
