﻿using VT.FW.DB;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 存储卡实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Deposit
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }
        public string Name { get; set; }

        public string CouponIco { get; set; }

        /// <summary>
        /// 售价
        /// </summary>
        public decimal SalePrice { get; set; }

        /// <summary>
        /// 金额
        /// </summary>
        public decimal DepositPrice { get; set; }

        /// <summary>
        /// 有效天数
        /// </summary>
        public int IndateDay { get; set; }


        /// <summary>
        /// 描述
        /// </summary>
        public string Describe { get; set; }



    }
}
