﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联规格值仓储层
    /// </summary>
    public class RB_Goods_SpecificationValueRepository : BaseRepository<RB_Goods_SpecificationValue>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_SpecificationValue_Extend> GetList(RB_Goods_SpecificationValue_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Goods_SpecificationValue.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.Id)}={dmodel.Id}";
            }
            if (dmodel.SpecificationId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.SpecificationId)}={dmodel.SpecificationId}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and {nameof(RB_Goods_SpecificationValue.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"select * from RB_Goods_SpecificationValue where {where} order by Id asc";
            return Get<RB_Goods_SpecificationValue_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取规格值图片
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="specificationSort"></param>
        /// <returns></returns>
        public string GetSpecificationImage(int goodsId, string specificationSort)
        {
            try
            {
                int Sort = Convert.ToInt32(specificationSort.Split(":")[0]);
                string sql = $@"select * from RB_Goods_SpecificationValue where Status=0 and GoodsId={goodsId} and Sort={Sort} and Image<> '' order by Id asc limit 1";
                var model = Get<RB_Goods_SpecificationValue_Extend>(sql).FirstOrDefault();
                if (model != null)
                {
                    return model.Image ?? "";
                }
                return "";
            }
            catch (Exception)
            {
                return "";
            }
        }
    }
}
