﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 分销商基础设置仓储层
    /// </summary>
    public class RB_Distributor_BasicsRepository : BaseRepository<RB_Distributor_Basics>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_Basics_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_Basics_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0) {
                where += $@" and {nameof(RB_Member_User.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and {nameof(RB_Member_User.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and {nameof(RB_Member_User.Id)}={dmodel.Id}";
            }
            
            string sql = $@"select * from RB_Distributor_Basics where {where} order by Id desc";
            return GetPage<RB_Distributor_Basics_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Basics_Extend> GetList(RB_Distributor_Basics_Extend dmodel)
        {
            string where = " 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_User.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_User.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Member_User.Id)}={dmodel.Id}";
            }

            string sql = $@"select * from RB_Distributor_Basics where {where} order by Id desc";
            return Get<RB_Distributor_Basics_Extend>(sql).ToList();
        }
    }
}
