﻿using Mall.AOP.CustomerAttribute;
using Mall.Model.Extend.User;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.User
{
    /// <summary>
    /// 商城插件处理类
    /// </summary>
    public class TenantPlugModule
    {
        /// <summary>
        /// 商城插件表仓储层对象
        /// </summary>
        private readonly RB_Tenant_PlugRepository tenant_PlugRepository = new RB_Tenant_PlugRepository();

        /// <summary>
        ///  获取商城插件列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Tenant_Plug_Extend> GetTenantPlugListModule(RB_Tenant_Plug_Extend query)
        {
            return tenant_PlugRepository.GetTenantPlugListRepository(query);
        }

        /// <summary>
        /// 新增修改商户插件
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        [TransactionCallHandler]
        public bool SetTenantPlugModule(List<RB_Tenant_Plug_Extend> list)
        {
            bool flag = false;
            if (list != null && list.Count > 0)
            {
                tenant_PlugRepository.DeleteTenantPlugRepository(list[0].TenantId, list[0].QPlugTypeStr);
                foreach (var item in list)
                {
                    flag = tenant_PlugRepository.Insert(item) > 0;
                }
            }
            return flag;
        }
    }
}
