﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.BaseSetUp;

namespace Mall.Repository.BaseSetUp
{
    public class RB_Video_StoreRepository:BaseRepository<RB_Video_Store>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Video_Store); } }

        /// <summary>
        /// 获取上传视频存储信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Video_Store> GetListRepository(RB_Video_Store query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Video_Store.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Video_Store.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Video_Store.MallBaseId)}={query.MallBaseId}");
                }
                if (query.StoreType > 0)
                {
                    builder.Append($" AND {nameof(RB_Video_Store.StoreType)}={(int)query.StoreType}");
                }
                if (query.IsDefault > 0)
                {
                    builder.Append($" AND {nameof(RB_Video_Store.IsDefault)}={query.IsDefault}");
                }
            }
            return Get<RB_Video_Store>(builder.ToString()).ToList();
        }
    }
}
